package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStateWaitingBuilder extends ContainerStateWaitingFluentImpl<ContainerStateWaitingBuilder> implements VisitableBuilder<ContainerStateWaiting,ContainerStateWaitingBuilder>{
  public ContainerStateWaitingBuilder() {
    this(false);
  }
  public ContainerStateWaitingBuilder(Boolean validationEnabled) {
    this(new ContainerStateWaiting(), validationEnabled);
  }
  public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerStateWaiting(), validationEnabled);
  }
  public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent,ContainerStateWaiting instance) {
    this(fluent, instance, false);
  }
  public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent,ContainerStateWaiting instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateWaitingBuilder(ContainerStateWaiting instance) {
    this(instance,false);
  }
  public ContainerStateWaitingBuilder(ContainerStateWaiting instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ContainerStateWaitingFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerStateWaiting build() {
    ContainerStateWaiting buildable = new ContainerStateWaiting(fluent.getMessage(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}