package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntOrStringBuilder extends IntOrStringFluentImpl<IntOrStringBuilder> implements VisitableBuilder<IntOrString,IntOrStringBuilder>{
  public IntOrStringBuilder() {
    this(false);
  }
  public IntOrStringBuilder(Boolean validationEnabled) {
    this(new IntOrString(), validationEnabled);
  }
  public IntOrStringBuilder(IntOrStringFluent<?> fluent) {
    this(fluent, false);
  }
  public IntOrStringBuilder(IntOrStringFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntOrString(), validationEnabled);
  }
  public IntOrStringBuilder(IntOrStringFluent<?> fluent,IntOrString instance) {
    this(fluent, instance, false);
  }
  public IntOrStringBuilder(IntOrStringFluent<?> fluent,IntOrString instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public IntOrStringBuilder(IntOrString instance) {
    this(instance,false);
  }
  public IntOrStringBuilder(IntOrString instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  IntOrStringFluent<?> fluent;
  Boolean validationEnabled;
  public IntOrString build() {
    IntOrString buildable = new IntOrString(fluent.getValue());
    return buildable;
  }
  
}