/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapEnvSource;
import io.fabric8.kubernetes.api.model.ConfigMapEnvSourceBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapEnvSourceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvFromSourceFluent;
import io.fabric8.kubernetes.api.model.SecretEnvSource;
import io.fabric8.kubernetes.api.model.SecretEnvSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretEnvSourceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EnvFromSourceFluentImpl<A extends EnvFromSourceFluent<A>>
extends BaseFluent<A>
implements EnvFromSourceFluent<A> {
    private ConfigMapEnvSourceBuilder configMapRef;
    private String prefix;
    private SecretEnvSourceBuilder secretRef;
    private Map<String, Object> additionalProperties;

    public EnvFromSourceFluentImpl() {
    }

    public EnvFromSourceFluentImpl(EnvFromSource instance) {
        this.withConfigMapRef(instance.getConfigMapRef());
        this.withPrefix(instance.getPrefix());
        this.withSecretRef(instance.getSecretRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public ConfigMapEnvSource getConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    @Override
    public ConfigMapEnvSource buildConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    @Override
    public A withConfigMapRef(ConfigMapEnvSource configMapRef) {
        this._visitables.get("configMapRef").remove(this.configMapRef);
        if (configMapRef != null) {
            this.configMapRef = new ConfigMapEnvSourceBuilder(configMapRef);
            this._visitables.get("configMapRef").add(this.configMapRef);
        } else {
            this.configMapRef = null;
            this._visitables.get("configMapRef").remove(this.configMapRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMapRef() {
        return this.configMapRef != null;
    }

    @Override
    public A withNewConfigMapRef(String name, Boolean optional) {
        return this.withConfigMapRef(new ConfigMapEnvSource(name, optional));
    }

    @Override
    public EnvFromSourceFluent.ConfigMapRefNested<A> withNewConfigMapRef() {
        return new ConfigMapRefNestedImpl();
    }

    @Override
    public EnvFromSourceFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ConfigMapEnvSource item) {
        return new ConfigMapRefNestedImpl(item);
    }

    @Override
    public EnvFromSourceFluent.ConfigMapRefNested<A> editConfigMapRef() {
        return this.withNewConfigMapRefLike(this.getConfigMapRef());
    }

    @Override
    public EnvFromSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRef() {
        return this.withNewConfigMapRefLike(this.getConfigMapRef() != null ? this.getConfigMapRef() : new ConfigMapEnvSourceBuilder().build());
    }

    @Override
    public EnvFromSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ConfigMapEnvSource item) {
        return this.withNewConfigMapRefLike(this.getConfigMapRef() != null ? this.getConfigMapRef() : item);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public A withPrefix(String prefix) {
        this.prefix = prefix;
        return (A)this;
    }

    @Override
    public Boolean hasPrefix() {
        return this.prefix != null;
    }

    @Override
    @Deprecated
    public SecretEnvSource getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretEnvSource buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretEnvSource secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretEnvSourceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, Boolean optional) {
        return this.withSecretRef(new SecretEnvSource(name, optional));
    }

    @Override
    public EnvFromSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public EnvFromSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretEnvSource item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public EnvFromSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public EnvFromSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretEnvSourceBuilder().build());
    }

    @Override
    public EnvFromSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretEnvSource item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvFromSourceFluentImpl that = (EnvFromSourceFluentImpl)o;
        if (this.configMapRef != null ? !this.configMapRef.equals(that.configMapRef) : that.configMapRef != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configMapRef, this.prefix, this.secretRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMapRef != null) {
            sb.append("configMapRef:");
            sb.append(this.configMapRef + ",");
        }
        if (this.prefix != null) {
            sb.append("prefix:");
            sb.append(this.prefix + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretRefNestedImpl<N>
    extends SecretEnvSourceFluentImpl<EnvFromSourceFluent.SecretRefNested<N>>
    implements EnvFromSourceFluent.SecretRefNested<N>,
    Nested<N> {
        SecretEnvSourceBuilder builder;

        SecretRefNestedImpl(SecretEnvSource item) {
            this.builder = new SecretEnvSourceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretEnvSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EnvFromSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }

    class ConfigMapRefNestedImpl<N>
    extends ConfigMapEnvSourceFluentImpl<EnvFromSourceFluent.ConfigMapRefNested<N>>
    implements EnvFromSourceFluent.ConfigMapRefNested<N>,
    Nested<N> {
        ConfigMapEnvSourceBuilder builder;

        ConfigMapRefNestedImpl(ConfigMapEnvSource item) {
            this.builder = new ConfigMapEnvSourceBuilder(this, item);
        }

        ConfigMapRefNestedImpl() {
            this.builder = new ConfigMapEnvSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EnvFromSourceFluentImpl.this.withConfigMapRef(this.builder.build());
        }

        @Override
        public N endConfigMapRef() {
            return this.and();
        }
    }
}

