package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StatusDetailsFluentImpl<A extends StatusDetailsFluent<A>> extends BaseFluent<A> implements StatusDetailsFluent<A>{
  public StatusDetailsFluentImpl() {
  }
  public StatusDetailsFluentImpl(StatusDetails instance) {
    this.withCauses(instance.getCauses()); 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<StatusCauseBuilder> causes = new ArrayList<StatusCauseBuilder>();
  private String group;
  private String kind;
  private String name;
  private Integer retryAfterSeconds;
  private String uid;
  private Map<String,Object> additionalProperties;
  public A addToCauses(Integer index,StatusCause item) {
    if (this.causes == null) {this.causes = new ArrayList<StatusCauseBuilder>();}
    StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.get("causes").add(index >= 0 ? index : _visitables.get("causes").size(), builder);this.causes.add(index >= 0 ? index : causes.size(), builder); return (A)this;
  }
  public A setToCauses(Integer index,StatusCause item) {
    if (this.causes == null) {this.causes = new ArrayList<StatusCauseBuilder>();}
    StatusCauseBuilder builder = new StatusCauseBuilder(item);
    if (index < 0 || index >= _visitables.get("causes").size()) { _visitables.get("causes").add(builder); } else { _visitables.get("causes").set(index, builder);}
    if (index < 0 || index >= causes.size()) { causes.add(builder); } else { causes.set(index, builder);}
     return (A)this;
  }
  public A addToCauses(io.fabric8.kubernetes.api.model.StatusCause... items) {
    if (this.causes == null) {this.causes = new ArrayList<StatusCauseBuilder>();}
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.get("causes").add(builder);this.causes.add(builder);} return (A)this;
  }
  public A addAllToCauses(Collection<StatusCause> items) {
    if (this.causes == null) {this.causes = new ArrayList<StatusCauseBuilder>();}
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.get("causes").add(builder);this.causes.add(builder);} return (A)this;
  }
  public A removeFromCauses(io.fabric8.kubernetes.api.model.StatusCause... items) {
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.get("causes").remove(builder);if (this.causes != null) {this.causes.remove(builder);}} return (A)this;
  }
  public A removeAllFromCauses(Collection<StatusCause> items) {
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.get("causes").remove(builder);if (this.causes != null) {this.causes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCauses(Predicate<StatusCauseBuilder> predicate) {
    if (causes == null) return (A) this;
    final Iterator<StatusCauseBuilder> each = causes.iterator();
    final List visitables = _visitables.get("causes");
    while (each.hasNext()) {
      StatusCauseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCauses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StatusCause> getCauses() {
    return causes != null ? build(causes) : null;
  }
  public List<StatusCause> buildCauses() {
    return causes != null ? build(causes) : null;
  }
  public StatusCause buildCause(Integer index) {
    return this.causes.get(index).build();
  }
  public StatusCause buildFirstCause() {
    return this.causes.get(0).build();
  }
  public StatusCause buildLastCause() {
    return this.causes.get(causes.size() - 1).build();
  }
  public StatusCause buildMatchingCause(Predicate<StatusCauseBuilder> predicate) {
    for (StatusCauseBuilder item: causes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCause(Predicate<StatusCauseBuilder> predicate) {
    for (StatusCauseBuilder item: causes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCauses(List<StatusCause> causes) {
    if (this.causes != null) { _visitables.get("causes").removeAll(this.causes);}
    if (causes != null) {this.causes = new ArrayList(); for (StatusCause item : causes){this.addToCauses(item);}} else { this.causes = null;} return (A) this;
  }
  public A withCauses(io.fabric8.kubernetes.api.model.StatusCause... causes) {
    if (this.causes != null) {this.causes.clear();}
    if (causes != null) {for (StatusCause item :causes){ this.addToCauses(item);}} return (A) this;
  }
  public Boolean hasCauses() {
    return causes != null && !causes.isEmpty();
  }
  public A addNewCause(String field,String message,String reason) {
    return (A)addToCauses(new StatusCause(field, message, reason));
  }
  public StatusDetailsFluent.CausesNested<A> addNewCause() {
    return new StatusDetailsFluentImpl.CausesNestedImpl();
  }
  public StatusDetailsFluent.CausesNested<A> addNewCauseLike(StatusCause item) {
    return new StatusDetailsFluentImpl.CausesNestedImpl(-1, item);
  }
  public StatusDetailsFluent.CausesNested<A> setNewCauseLike(Integer index,StatusCause item) {
    return new StatusDetailsFluentImpl.CausesNestedImpl(index, item);
  }
  public StatusDetailsFluent.CausesNested<A> editCause(Integer index) {
    if (causes.size() <= index) throw new RuntimeException("Can't edit causes. Index exceeds size.");
    return setNewCauseLike(index, buildCause(index));
  }
  public StatusDetailsFluent.CausesNested<A> editFirstCause() {
    if (causes.size() == 0) throw new RuntimeException("Can't edit first causes. The list is empty.");
    return setNewCauseLike(0, buildCause(0));
  }
  public StatusDetailsFluent.CausesNested<A> editLastCause() {
    int index = causes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last causes. The list is empty.");
    return setNewCauseLike(index, buildCause(index));
  }
  public StatusDetailsFluent.CausesNested<A> editMatchingCause(Predicate<StatusCauseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<causes.size();i++) { 
    if (predicate.test(causes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching causes. No match found.");
    return setNewCauseLike(index, buildCause(index));
  }
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public Boolean hasGroup() {
    return this.group != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public Integer getRetryAfterSeconds() {
    return this.retryAfterSeconds;
  }
  public A withRetryAfterSeconds(Integer retryAfterSeconds) {
    this.retryAfterSeconds=retryAfterSeconds; return (A) this;
  }
  public Boolean hasRetryAfterSeconds() {
    return this.retryAfterSeconds != null;
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StatusDetailsFluentImpl that = (StatusDetailsFluentImpl) o;
    if (causes != null ? !causes.equals(that.causes) :that.causes != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (retryAfterSeconds != null ? !retryAfterSeconds.equals(that.retryAfterSeconds) :that.retryAfterSeconds != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(causes,  group,  kind,  name,  retryAfterSeconds,  uid,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (causes != null && !causes.isEmpty()) { sb.append("causes:"); sb.append(causes + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (retryAfterSeconds != null) { sb.append("retryAfterSeconds:"); sb.append(retryAfterSeconds + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CausesNestedImpl<N> extends StatusCauseFluentImpl<StatusDetailsFluent.CausesNested<N>> implements StatusDetailsFluent.CausesNested<N>,Nested<N>{
    CausesNestedImpl(Integer index,StatusCause item) {
      this.index = index;
      this.builder = new StatusCauseBuilder(this, item);
    }
    CausesNestedImpl() {
      this.index = -1;
      this.builder = new StatusCauseBuilder(this);
    }
    StatusCauseBuilder builder;
    Integer index;
    public N and() {
      return (N) StatusDetailsFluentImpl.this.setToCauses(index,builder.build());
    }
    public N endCause() {
      return and();
    }
    
  }
  
}