package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeleteOptionsFluentImpl<A extends DeleteOptionsFluent<A>> extends BaseFluent<A> implements DeleteOptionsFluent<A>{
  public DeleteOptionsFluentImpl() {
  }
  public DeleteOptionsFluentImpl(DeleteOptions instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); 
    this.withKind(instance.getKind()); 
    this.withOrphanDependents(instance.getOrphanDependents()); 
    this.withPreconditions(instance.getPreconditions()); 
    this.withPropagationPolicy(instance.getPropagationPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<String> dryRun = new ArrayList<String>();
  private Long gracePeriodSeconds;
  private String kind;
  private Boolean orphanDependents;
  private PreconditionsBuilder preconditions;
  private String propagationPolicy;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToDryRun(Integer index,String item) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    this.dryRun.add(index, item);
    return (A)this;
  }
  public A setToDryRun(Integer index,String item) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    this.dryRun.set(index, item); return (A)this;
  }
  public A addToDryRun(java.lang.String... items) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    for (String item : items) {this.dryRun.add(item);} return (A)this;
  }
  public A addAllToDryRun(Collection<String> items) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    for (String item : items) {this.dryRun.add(item);} return (A)this;
  }
  public A removeFromDryRun(java.lang.String... items) {
    for (String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
  }
  public A removeAllFromDryRun(Collection<String> items) {
    for (String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
  }
  public List<String> getDryRun() {
    return this.dryRun;
  }
  public String getDryRun(Integer index) {
    return this.dryRun.get(index);
  }
  public String getFirstDryRun() {
    return this.dryRun.get(0);
  }
  public String getLastDryRun() {
    return this.dryRun.get(dryRun.size() - 1);
  }
  public String getMatchingDryRun(Predicate<String> predicate) {
    for (String item: dryRun) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDryRun(Predicate<String> predicate) {
    for (String item: dryRun) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDryRun(List<String> dryRun) {
    if (dryRun != null) {this.dryRun = new ArrayList(); for (String item : dryRun){this.addToDryRun(item);}} else { this.dryRun = null;} return (A) this;
  }
  public A withDryRun(java.lang.String... dryRun) {
    if (this.dryRun != null) {this.dryRun.clear();}
    if (dryRun != null) {for (String item :dryRun){ this.addToDryRun(item);}} return (A) this;
  }
  public Boolean hasDryRun() {
    return dryRun != null && !dryRun.isEmpty();
  }
  public Long getGracePeriodSeconds() {
    return this.gracePeriodSeconds;
  }
  public A withGracePeriodSeconds(Long gracePeriodSeconds) {
    this.gracePeriodSeconds=gracePeriodSeconds; return (A) this;
  }
  public Boolean hasGracePeriodSeconds() {
    return this.gracePeriodSeconds != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public Boolean getOrphanDependents() {
    return this.orphanDependents;
  }
  public A withOrphanDependents(Boolean orphanDependents) {
    this.orphanDependents=orphanDependents; return (A) this;
  }
  public Boolean hasOrphanDependents() {
    return this.orphanDependents != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPreconditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public Preconditions getPreconditions() {
    return this.preconditions!=null ?this.preconditions.build():null;
  }
  public Preconditions buildPreconditions() {
    return this.preconditions!=null ?this.preconditions.build():null;
  }
  public A withPreconditions(Preconditions preconditions) {
    _visitables.get("preconditions").remove(this.preconditions);
    if (preconditions!=null){ this.preconditions= new PreconditionsBuilder(preconditions); _visitables.get("preconditions").add(this.preconditions);} else { this.preconditions = null; _visitables.get("preconditions").remove(this.preconditions); } return (A) this;
  }
  public Boolean hasPreconditions() {
    return this.preconditions != null;
  }
  public A withNewPreconditions(String resourceVersion,String uid) {
    return (A)withPreconditions(new Preconditions(resourceVersion, uid));
  }
  public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
    return new DeleteOptionsFluentImpl.PreconditionsNestedImpl();
  }
  public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item) {
    return new DeleteOptionsFluentImpl.PreconditionsNestedImpl(item);
  }
  public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
    return withNewPreconditionsLike(getPreconditions());
  }
  public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
    return withNewPreconditionsLike(getPreconditions() != null ? getPreconditions(): new PreconditionsBuilder().build());
  }
  public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(Preconditions item) {
    return withNewPreconditionsLike(getPreconditions() != null ? getPreconditions(): item);
  }
  public String getPropagationPolicy() {
    return this.propagationPolicy;
  }
  public A withPropagationPolicy(String propagationPolicy) {
    this.propagationPolicy=propagationPolicy; return (A) this;
  }
  public Boolean hasPropagationPolicy() {
    return this.propagationPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (dryRun != null ? !dryRun.equals(that.dryRun) :that.dryRun != null) return false;
    if (gracePeriodSeconds != null ? !gracePeriodSeconds.equals(that.gracePeriodSeconds) :that.gracePeriodSeconds != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (orphanDependents != null ? !orphanDependents.equals(that.orphanDependents) :that.orphanDependents != null) return false;
    if (preconditions != null ? !preconditions.equals(that.preconditions) :that.preconditions != null) return false;
    if (propagationPolicy != null ? !propagationPolicy.equals(that.propagationPolicy) :that.propagationPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  dryRun,  gracePeriodSeconds,  kind,  orphanDependents,  preconditions,  propagationPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (dryRun != null && !dryRun.isEmpty()) { sb.append("dryRun:"); sb.append(dryRun + ","); }
    if (gracePeriodSeconds != null) { sb.append("gracePeriodSeconds:"); sb.append(gracePeriodSeconds + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (orphanDependents != null) { sb.append("orphanDependents:"); sb.append(orphanDependents + ","); }
    if (preconditions != null) { sb.append("preconditions:"); sb.append(preconditions + ","); }
    if (propagationPolicy != null) { sb.append("propagationPolicy:"); sb.append(propagationPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withOrphanDependents() {
    return withOrphanDependents(true);
  }
  class PreconditionsNestedImpl<N> extends PreconditionsFluentImpl<DeleteOptionsFluent.PreconditionsNested<N>> implements DeleteOptionsFluent.PreconditionsNested<N>,Nested<N>{
    PreconditionsNestedImpl(Preconditions item) {
      this.builder = new PreconditionsBuilder(this, item);
    }
    PreconditionsNestedImpl() {
      this.builder = new PreconditionsBuilder(this);
    }
    PreconditionsBuilder builder;
    public N and() {
      return (N) DeleteOptionsFluentImpl.this.withPreconditions(builder.build());
    }
    public N endPreconditions() {
      return and();
    }
    
  }
  
}