package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PersistentVolumeSpecFluent<A extends PersistentVolumeSpecFluent<A>> extends BaseFluent<A>{
  public PersistentVolumeSpecFluent() {
  }
  
  public PersistentVolumeSpecFluent(PersistentVolumeSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> accessModes = new ArrayList<String>();
  private AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
  private AzureDiskVolumeSourceBuilder azureDisk;
  private AzureFilePersistentVolumeSourceBuilder azureFile;
  private Map<String,Quantity> capacity;
  private CephFSPersistentVolumeSourceBuilder cephfs;
  private CinderPersistentVolumeSourceBuilder cinder;
  private ObjectReferenceBuilder claimRef;
  private CSIPersistentVolumeSourceBuilder csi;
  private FCVolumeSourceBuilder fc;
  private FlexPersistentVolumeSourceBuilder flexVolume;
  private FlockerVolumeSourceBuilder flocker;
  private GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
  private GlusterfsPersistentVolumeSourceBuilder glusterfs;
  private HostPathVolumeSourceBuilder hostPath;
  private ISCSIPersistentVolumeSourceBuilder iscsi;
  private LocalVolumeSourceBuilder local;
  private List<String> mountOptions = new ArrayList<String>();
  private NFSVolumeSourceBuilder nfs;
  private VolumeNodeAffinityBuilder nodeAffinity;
  private String persistentVolumeReclaimPolicy;
  private PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
  private PortworxVolumeSourceBuilder portworxVolume;
  private QuobyteVolumeSourceBuilder quobyte;
  private RBDPersistentVolumeSourceBuilder rbd;
  private ScaleIOPersistentVolumeSourceBuilder scaleIO;
  private String storageClassName;
  private StorageOSPersistentVolumeSourceBuilder storageos;
  private String volumeAttributesClassName;
  private String volumeMode;
  private VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PersistentVolumeSpec instance) {
    instance = (instance != null ? instance : new PersistentVolumeSpec());
    if (instance != null) {
          this.withAccessModes(instance.getAccessModes());
          this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
          this.withAzureDisk(instance.getAzureDisk());
          this.withAzureFile(instance.getAzureFile());
          this.withCapacity(instance.getCapacity());
          this.withCephfs(instance.getCephfs());
          this.withCinder(instance.getCinder());
          this.withClaimRef(instance.getClaimRef());
          this.withCsi(instance.getCsi());
          this.withFc(instance.getFc());
          this.withFlexVolume(instance.getFlexVolume());
          this.withFlocker(instance.getFlocker());
          this.withGcePersistentDisk(instance.getGcePersistentDisk());
          this.withGlusterfs(instance.getGlusterfs());
          this.withHostPath(instance.getHostPath());
          this.withIscsi(instance.getIscsi());
          this.withLocal(instance.getLocal());
          this.withMountOptions(instance.getMountOptions());
          this.withNfs(instance.getNfs());
          this.withNodeAffinity(instance.getNodeAffinity());
          this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
          this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
          this.withPortworxVolume(instance.getPortworxVolume());
          this.withQuobyte(instance.getQuobyte());
          this.withRbd(instance.getRbd());
          this.withScaleIO(instance.getScaleIO());
          this.withStorageClassName(instance.getStorageClassName());
          this.withStorageos(instance.getStorageos());
          this.withVolumeAttributesClassName(instance.getVolumeAttributesClassName());
          this.withVolumeMode(instance.getVolumeMode());
          this.withVsphereVolume(instance.getVsphereVolume());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAccessModes(int index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  
  public A setToAccessModes(int index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  
  public A addAllToAccessModes(Collection<String> items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  
  public A removeFromAccessModes(java.lang.String... items) {
    if (this.accessModes == null) return (A)this;
    for (String item : items) { this.accessModes.remove(item);} return (A)this;
  }
  
  public A removeAllFromAccessModes(Collection<String> items) {
    if (this.accessModes == null) return (A)this;
    for (String item : items) { this.accessModes.remove(item);} return (A)this;
  }
  
  public List<String> getAccessModes() {
    return this.accessModes;
  }
  
  public String getAccessMode(int index) {
    return this.accessModes.get(index);
  }
  
  public String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  
  public String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  
  public String getMatchingAccessMode(Predicate<String> predicate) {
      for (String item : accessModes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAccessMode(Predicate<String> predicate) {
      for (String item : accessModes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAccessModes(List<String> accessModes) {
    if (accessModes != null) {
        this.accessModes = new ArrayList();
        for (String item : accessModes) {
          this.addToAccessModes(item);
        }
    } else {
      this.accessModes = null;
    }
    return (A) this;
  }
  
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {
        this.accessModes.clear();
        _visitables.remove("accessModes");
    }
    if (accessModes != null) {
      for (String item : accessModes) {
        this.addToAccessModes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAccessModes() {
    return this.accessModes != null && !this.accessModes.isEmpty();
  }
  
  public AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore() {
    return this.awsElasticBlockStore != null ? this.awsElasticBlockStore.build() : null;
  }
  
  public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    this._visitables.remove("awsElasticBlockStore");
    if (awsElasticBlockStore != null) {
        this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
        this._visitables.get("awsElasticBlockStore").add(this.awsElasticBlockStore);
    } else {
        this.awsElasticBlockStore = null;
        this._visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore);
    }
    return (A) this;
  }
  
  public boolean hasAwsElasticBlockStore() {
    return this.awsElasticBlockStore != null;
  }
  
  public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID) {
    return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  
  public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
    return new AwsElasticBlockStoreNested(null);
  }
  
  public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
    return new AwsElasticBlockStoreNested(item);
  }
  
  public AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(java.util.Optional.ofNullable(buildAwsElasticBlockStore()).orElse(null));
  }
  
  public AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(java.util.Optional.ofNullable(buildAwsElasticBlockStore()).orElse(new AWSElasticBlockStoreVolumeSourceBuilder().build()));
  }
  
  public AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
    return withNewAwsElasticBlockStoreLike(java.util.Optional.ofNullable(buildAwsElasticBlockStore()).orElse(item));
  }
  
  public AzureDiskVolumeSource buildAzureDisk() {
    return this.azureDisk != null ? this.azureDisk.build() : null;
  }
  
  public A withAzureDisk(AzureDiskVolumeSource azureDisk) {
    this._visitables.remove("azureDisk");
    if (azureDisk != null) {
        this.azureDisk = new AzureDiskVolumeSourceBuilder(azureDisk);
        this._visitables.get("azureDisk").add(this.azureDisk);
    } else {
        this.azureDisk = null;
        this._visitables.get("azureDisk").remove(this.azureDisk);
    }
    return (A) this;
  }
  
  public boolean hasAzureDisk() {
    return this.azureDisk != null;
  }
  
  public AzureDiskNested<A> withNewAzureDisk() {
    return new AzureDiskNested(null);
  }
  
  public AzureDiskNested<A> withNewAzureDiskLike(AzureDiskVolumeSource item) {
    return new AzureDiskNested(item);
  }
  
  public AzureDiskNested<A> editAzureDisk() {
    return withNewAzureDiskLike(java.util.Optional.ofNullable(buildAzureDisk()).orElse(null));
  }
  
  public AzureDiskNested<A> editOrNewAzureDisk() {
    return withNewAzureDiskLike(java.util.Optional.ofNullable(buildAzureDisk()).orElse(new AzureDiskVolumeSourceBuilder().build()));
  }
  
  public AzureDiskNested<A> editOrNewAzureDiskLike(AzureDiskVolumeSource item) {
    return withNewAzureDiskLike(java.util.Optional.ofNullable(buildAzureDisk()).orElse(item));
  }
  
  public AzureFilePersistentVolumeSource buildAzureFile() {
    return this.azureFile != null ? this.azureFile.build() : null;
  }
  
  public A withAzureFile(AzureFilePersistentVolumeSource azureFile) {
    this._visitables.remove("azureFile");
    if (azureFile != null) {
        this.azureFile = new AzureFilePersistentVolumeSourceBuilder(azureFile);
        this._visitables.get("azureFile").add(this.azureFile);
    } else {
        this.azureFile = null;
        this._visitables.get("azureFile").remove(this.azureFile);
    }
    return (A) this;
  }
  
  public boolean hasAzureFile() {
    return this.azureFile != null;
  }
  
  public A withNewAzureFile(Boolean readOnly,String secretName,String secretNamespace,String shareName) {
    return (A)withAzureFile(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
  }
  
  public AzureFileNested<A> withNewAzureFile() {
    return new AzureFileNested(null);
  }
  
  public AzureFileNested<A> withNewAzureFileLike(AzureFilePersistentVolumeSource item) {
    return new AzureFileNested(item);
  }
  
  public AzureFileNested<A> editAzureFile() {
    return withNewAzureFileLike(java.util.Optional.ofNullable(buildAzureFile()).orElse(null));
  }
  
  public AzureFileNested<A> editOrNewAzureFile() {
    return withNewAzureFileLike(java.util.Optional.ofNullable(buildAzureFile()).orElse(new AzureFilePersistentVolumeSourceBuilder().build()));
  }
  
  public AzureFileNested<A> editOrNewAzureFileLike(AzureFilePersistentVolumeSource item) {
    return withNewAzureFileLike(java.util.Optional.ofNullable(buildAzureFile()).orElse(item));
  }
  
  public A addToCapacity(String key,Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  
  public A addToCapacity(Map<String,Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  
  public A removeFromCapacity(String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  
  public A removeFromCapacity(Map<String,Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getCapacity() {
    return this.capacity;
  }
  
  public <K,V>A withCapacity(Map<String,Quantity> capacity) {
    if (capacity == null) {
      this.capacity = null;
    } else {
      this.capacity = new LinkedHashMap(capacity);
    }
    return (A) this;
  }
  
  public boolean hasCapacity() {
    return this.capacity != null;
  }
  
  public CephFSPersistentVolumeSource buildCephfs() {
    return this.cephfs != null ? this.cephfs.build() : null;
  }
  
  public A withCephfs(CephFSPersistentVolumeSource cephfs) {
    this._visitables.remove("cephfs");
    if (cephfs != null) {
        this.cephfs = new CephFSPersistentVolumeSourceBuilder(cephfs);
        this._visitables.get("cephfs").add(this.cephfs);
    } else {
        this.cephfs = null;
        this._visitables.get("cephfs").remove(this.cephfs);
    }
    return (A) this;
  }
  
  public boolean hasCephfs() {
    return this.cephfs != null;
  }
  
  public CephfsNested<A> withNewCephfs() {
    return new CephfsNested(null);
  }
  
  public CephfsNested<A> withNewCephfsLike(CephFSPersistentVolumeSource item) {
    return new CephfsNested(item);
  }
  
  public CephfsNested<A> editCephfs() {
    return withNewCephfsLike(java.util.Optional.ofNullable(buildCephfs()).orElse(null));
  }
  
  public CephfsNested<A> editOrNewCephfs() {
    return withNewCephfsLike(java.util.Optional.ofNullable(buildCephfs()).orElse(new CephFSPersistentVolumeSourceBuilder().build()));
  }
  
  public CephfsNested<A> editOrNewCephfsLike(CephFSPersistentVolumeSource item) {
    return withNewCephfsLike(java.util.Optional.ofNullable(buildCephfs()).orElse(item));
  }
  
  public CinderPersistentVolumeSource buildCinder() {
    return this.cinder != null ? this.cinder.build() : null;
  }
  
  public A withCinder(CinderPersistentVolumeSource cinder) {
    this._visitables.remove("cinder");
    if (cinder != null) {
        this.cinder = new CinderPersistentVolumeSourceBuilder(cinder);
        this._visitables.get("cinder").add(this.cinder);
    } else {
        this.cinder = null;
        this._visitables.get("cinder").remove(this.cinder);
    }
    return (A) this;
  }
  
  public boolean hasCinder() {
    return this.cinder != null;
  }
  
  public CinderNested<A> withNewCinder() {
    return new CinderNested(null);
  }
  
  public CinderNested<A> withNewCinderLike(CinderPersistentVolumeSource item) {
    return new CinderNested(item);
  }
  
  public CinderNested<A> editCinder() {
    return withNewCinderLike(java.util.Optional.ofNullable(buildCinder()).orElse(null));
  }
  
  public CinderNested<A> editOrNewCinder() {
    return withNewCinderLike(java.util.Optional.ofNullable(buildCinder()).orElse(new CinderPersistentVolumeSourceBuilder().build()));
  }
  
  public CinderNested<A> editOrNewCinderLike(CinderPersistentVolumeSource item) {
    return withNewCinderLike(java.util.Optional.ofNullable(buildCinder()).orElse(item));
  }
  
  public ObjectReference buildClaimRef() {
    return this.claimRef != null ? this.claimRef.build() : null;
  }
  
  public A withClaimRef(ObjectReference claimRef) {
    this._visitables.remove("claimRef");
    if (claimRef != null) {
        this.claimRef = new ObjectReferenceBuilder(claimRef);
        this._visitables.get("claimRef").add(this.claimRef);
    } else {
        this.claimRef = null;
        this._visitables.get("claimRef").remove(this.claimRef);
    }
    return (A) this;
  }
  
  public boolean hasClaimRef() {
    return this.claimRef != null;
  }
  
  public ClaimRefNested<A> withNewClaimRef() {
    return new ClaimRefNested(null);
  }
  
  public ClaimRefNested<A> withNewClaimRefLike(ObjectReference item) {
    return new ClaimRefNested(item);
  }
  
  public ClaimRefNested<A> editClaimRef() {
    return withNewClaimRefLike(java.util.Optional.ofNullable(buildClaimRef()).orElse(null));
  }
  
  public ClaimRefNested<A> editOrNewClaimRef() {
    return withNewClaimRefLike(java.util.Optional.ofNullable(buildClaimRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item) {
    return withNewClaimRefLike(java.util.Optional.ofNullable(buildClaimRef()).orElse(item));
  }
  
  public CSIPersistentVolumeSource buildCsi() {
    return this.csi != null ? this.csi.build() : null;
  }
  
  public A withCsi(CSIPersistentVolumeSource csi) {
    this._visitables.remove("csi");
    if (csi != null) {
        this.csi = new CSIPersistentVolumeSourceBuilder(csi);
        this._visitables.get("csi").add(this.csi);
    } else {
        this.csi = null;
        this._visitables.get("csi").remove(this.csi);
    }
    return (A) this;
  }
  
  public boolean hasCsi() {
    return this.csi != null;
  }
  
  public CsiNested<A> withNewCsi() {
    return new CsiNested(null);
  }
  
  public CsiNested<A> withNewCsiLike(CSIPersistentVolumeSource item) {
    return new CsiNested(item);
  }
  
  public CsiNested<A> editCsi() {
    return withNewCsiLike(java.util.Optional.ofNullable(buildCsi()).orElse(null));
  }
  
  public CsiNested<A> editOrNewCsi() {
    return withNewCsiLike(java.util.Optional.ofNullable(buildCsi()).orElse(new CSIPersistentVolumeSourceBuilder().build()));
  }
  
  public CsiNested<A> editOrNewCsiLike(CSIPersistentVolumeSource item) {
    return withNewCsiLike(java.util.Optional.ofNullable(buildCsi()).orElse(item));
  }
  
  public FCVolumeSource buildFc() {
    return this.fc != null ? this.fc.build() : null;
  }
  
  public A withFc(FCVolumeSource fc) {
    this._visitables.remove("fc");
    if (fc != null) {
        this.fc = new FCVolumeSourceBuilder(fc);
        this._visitables.get("fc").add(this.fc);
    } else {
        this.fc = null;
        this._visitables.get("fc").remove(this.fc);
    }
    return (A) this;
  }
  
  public boolean hasFc() {
    return this.fc != null;
  }
  
  public FcNested<A> withNewFc() {
    return new FcNested(null);
  }
  
  public FcNested<A> withNewFcLike(FCVolumeSource item) {
    return new FcNested(item);
  }
  
  public FcNested<A> editFc() {
    return withNewFcLike(java.util.Optional.ofNullable(buildFc()).orElse(null));
  }
  
  public FcNested<A> editOrNewFc() {
    return withNewFcLike(java.util.Optional.ofNullable(buildFc()).orElse(new FCVolumeSourceBuilder().build()));
  }
  
  public FcNested<A> editOrNewFcLike(FCVolumeSource item) {
    return withNewFcLike(java.util.Optional.ofNullable(buildFc()).orElse(item));
  }
  
  public FlexPersistentVolumeSource buildFlexVolume() {
    return this.flexVolume != null ? this.flexVolume.build() : null;
  }
  
  public A withFlexVolume(FlexPersistentVolumeSource flexVolume) {
    this._visitables.remove("flexVolume");
    if (flexVolume != null) {
        this.flexVolume = new FlexPersistentVolumeSourceBuilder(flexVolume);
        this._visitables.get("flexVolume").add(this.flexVolume);
    } else {
        this.flexVolume = null;
        this._visitables.get("flexVolume").remove(this.flexVolume);
    }
    return (A) this;
  }
  
  public boolean hasFlexVolume() {
    return this.flexVolume != null;
  }
  
  public FlexVolumeNested<A> withNewFlexVolume() {
    return new FlexVolumeNested(null);
  }
  
  public FlexVolumeNested<A> withNewFlexVolumeLike(FlexPersistentVolumeSource item) {
    return new FlexVolumeNested(item);
  }
  
  public FlexVolumeNested<A> editFlexVolume() {
    return withNewFlexVolumeLike(java.util.Optional.ofNullable(buildFlexVolume()).orElse(null));
  }
  
  public FlexVolumeNested<A> editOrNewFlexVolume() {
    return withNewFlexVolumeLike(java.util.Optional.ofNullable(buildFlexVolume()).orElse(new FlexPersistentVolumeSourceBuilder().build()));
  }
  
  public FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexPersistentVolumeSource item) {
    return withNewFlexVolumeLike(java.util.Optional.ofNullable(buildFlexVolume()).orElse(item));
  }
  
  public FlockerVolumeSource buildFlocker() {
    return this.flocker != null ? this.flocker.build() : null;
  }
  
  public A withFlocker(FlockerVolumeSource flocker) {
    this._visitables.remove("flocker");
    if (flocker != null) {
        this.flocker = new FlockerVolumeSourceBuilder(flocker);
        this._visitables.get("flocker").add(this.flocker);
    } else {
        this.flocker = null;
        this._visitables.get("flocker").remove(this.flocker);
    }
    return (A) this;
  }
  
  public boolean hasFlocker() {
    return this.flocker != null;
  }
  
  public A withNewFlocker(String datasetName,String datasetUUID) {
    return (A)withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  
  public FlockerNested<A> withNewFlocker() {
    return new FlockerNested(null);
  }
  
  public FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
    return new FlockerNested(item);
  }
  
  public FlockerNested<A> editFlocker() {
    return withNewFlockerLike(java.util.Optional.ofNullable(buildFlocker()).orElse(null));
  }
  
  public FlockerNested<A> editOrNewFlocker() {
    return withNewFlockerLike(java.util.Optional.ofNullable(buildFlocker()).orElse(new FlockerVolumeSourceBuilder().build()));
  }
  
  public FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item) {
    return withNewFlockerLike(java.util.Optional.ofNullable(buildFlocker()).orElse(item));
  }
  
  public GCEPersistentDiskVolumeSource buildGcePersistentDisk() {
    return this.gcePersistentDisk != null ? this.gcePersistentDisk.build() : null;
  }
  
  public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
    this._visitables.remove("gcePersistentDisk");
    if (gcePersistentDisk != null) {
        this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
        this._visitables.get("gcePersistentDisk").add(this.gcePersistentDisk);
    } else {
        this.gcePersistentDisk = null;
        this._visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk);
    }
    return (A) this;
  }
  
  public boolean hasGcePersistentDisk() {
    return this.gcePersistentDisk != null;
  }
  
  public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly) {
    return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  
  public GcePersistentDiskNested<A> withNewGcePersistentDisk() {
    return new GcePersistentDiskNested(null);
  }
  
  public GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
    return new GcePersistentDiskNested(item);
  }
  
  public GcePersistentDiskNested<A> editGcePersistentDisk() {
    return withNewGcePersistentDiskLike(java.util.Optional.ofNullable(buildGcePersistentDisk()).orElse(null));
  }
  
  public GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
    return withNewGcePersistentDiskLike(java.util.Optional.ofNullable(buildGcePersistentDisk()).orElse(new GCEPersistentDiskVolumeSourceBuilder().build()));
  }
  
  public GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
    return withNewGcePersistentDiskLike(java.util.Optional.ofNullable(buildGcePersistentDisk()).orElse(item));
  }
  
  public GlusterfsPersistentVolumeSource buildGlusterfs() {
    return this.glusterfs != null ? this.glusterfs.build() : null;
  }
  
  public A withGlusterfs(GlusterfsPersistentVolumeSource glusterfs) {
    this._visitables.remove("glusterfs");
    if (glusterfs != null) {
        this.glusterfs = new GlusterfsPersistentVolumeSourceBuilder(glusterfs);
        this._visitables.get("glusterfs").add(this.glusterfs);
    } else {
        this.glusterfs = null;
        this._visitables.get("glusterfs").remove(this.glusterfs);
    }
    return (A) this;
  }
  
  public boolean hasGlusterfs() {
    return this.glusterfs != null;
  }
  
  public A withNewGlusterfs(String endpoints,String endpointsNamespace,String path,Boolean readOnly) {
    return (A)withGlusterfs(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
  }
  
  public GlusterfsNested<A> withNewGlusterfs() {
    return new GlusterfsNested(null);
  }
  
  public GlusterfsNested<A> withNewGlusterfsLike(GlusterfsPersistentVolumeSource item) {
    return new GlusterfsNested(item);
  }
  
  public GlusterfsNested<A> editGlusterfs() {
    return withNewGlusterfsLike(java.util.Optional.ofNullable(buildGlusterfs()).orElse(null));
  }
  
  public GlusterfsNested<A> editOrNewGlusterfs() {
    return withNewGlusterfsLike(java.util.Optional.ofNullable(buildGlusterfs()).orElse(new GlusterfsPersistentVolumeSourceBuilder().build()));
  }
  
  public GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsPersistentVolumeSource item) {
    return withNewGlusterfsLike(java.util.Optional.ofNullable(buildGlusterfs()).orElse(item));
  }
  
  public HostPathVolumeSource buildHostPath() {
    return this.hostPath != null ? this.hostPath.build() : null;
  }
  
  public A withHostPath(HostPathVolumeSource hostPath) {
    this._visitables.remove("hostPath");
    if (hostPath != null) {
        this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
        this._visitables.get("hostPath").add(this.hostPath);
    } else {
        this.hostPath = null;
        this._visitables.get("hostPath").remove(this.hostPath);
    }
    return (A) this;
  }
  
  public boolean hasHostPath() {
    return this.hostPath != null;
  }
  
  public A withNewHostPath(String path,String type) {
    return (A)withHostPath(new HostPathVolumeSource(path, type));
  }
  
  public HostPathNested<A> withNewHostPath() {
    return new HostPathNested(null);
  }
  
  public HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
    return new HostPathNested(item);
  }
  
  public HostPathNested<A> editHostPath() {
    return withNewHostPathLike(java.util.Optional.ofNullable(buildHostPath()).orElse(null));
  }
  
  public HostPathNested<A> editOrNewHostPath() {
    return withNewHostPathLike(java.util.Optional.ofNullable(buildHostPath()).orElse(new HostPathVolumeSourceBuilder().build()));
  }
  
  public HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item) {
    return withNewHostPathLike(java.util.Optional.ofNullable(buildHostPath()).orElse(item));
  }
  
  public ISCSIPersistentVolumeSource buildIscsi() {
    return this.iscsi != null ? this.iscsi.build() : null;
  }
  
  public A withIscsi(ISCSIPersistentVolumeSource iscsi) {
    this._visitables.remove("iscsi");
    if (iscsi != null) {
        this.iscsi = new ISCSIPersistentVolumeSourceBuilder(iscsi);
        this._visitables.get("iscsi").add(this.iscsi);
    } else {
        this.iscsi = null;
        this._visitables.get("iscsi").remove(this.iscsi);
    }
    return (A) this;
  }
  
  public boolean hasIscsi() {
    return this.iscsi != null;
  }
  
  public IscsiNested<A> withNewIscsi() {
    return new IscsiNested(null);
  }
  
  public IscsiNested<A> withNewIscsiLike(ISCSIPersistentVolumeSource item) {
    return new IscsiNested(item);
  }
  
  public IscsiNested<A> editIscsi() {
    return withNewIscsiLike(java.util.Optional.ofNullable(buildIscsi()).orElse(null));
  }
  
  public IscsiNested<A> editOrNewIscsi() {
    return withNewIscsiLike(java.util.Optional.ofNullable(buildIscsi()).orElse(new ISCSIPersistentVolumeSourceBuilder().build()));
  }
  
  public IscsiNested<A> editOrNewIscsiLike(ISCSIPersistentVolumeSource item) {
    return withNewIscsiLike(java.util.Optional.ofNullable(buildIscsi()).orElse(item));
  }
  
  public LocalVolumeSource buildLocal() {
    return this.local != null ? this.local.build() : null;
  }
  
  public A withLocal(LocalVolumeSource local) {
    this._visitables.remove("local");
    if (local != null) {
        this.local = new LocalVolumeSourceBuilder(local);
        this._visitables.get("local").add(this.local);
    } else {
        this.local = null;
        this._visitables.get("local").remove(this.local);
    }
    return (A) this;
  }
  
  public boolean hasLocal() {
    return this.local != null;
  }
  
  public A withNewLocal(String fsType,String path) {
    return (A)withLocal(new LocalVolumeSource(fsType, path));
  }
  
  public LocalNested<A> withNewLocal() {
    return new LocalNested(null);
  }
  
  public LocalNested<A> withNewLocalLike(LocalVolumeSource item) {
    return new LocalNested(item);
  }
  
  public LocalNested<A> editLocal() {
    return withNewLocalLike(java.util.Optional.ofNullable(buildLocal()).orElse(null));
  }
  
  public LocalNested<A> editOrNewLocal() {
    return withNewLocalLike(java.util.Optional.ofNullable(buildLocal()).orElse(new LocalVolumeSourceBuilder().build()));
  }
  
  public LocalNested<A> editOrNewLocalLike(LocalVolumeSource item) {
    return withNewLocalLike(java.util.Optional.ofNullable(buildLocal()).orElse(item));
  }
  
  public A addToMountOptions(int index,String item) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    this.mountOptions.add(index, item);
    return (A)this;
  }
  
  public A setToMountOptions(int index,String item) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    this.mountOptions.set(index, item); return (A)this;
  }
  
  public A addToMountOptions(java.lang.String... items) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    for (String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  
  public A addAllToMountOptions(Collection<String> items) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    for (String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  
  public A removeFromMountOptions(java.lang.String... items) {
    if (this.mountOptions == null) return (A)this;
    for (String item : items) { this.mountOptions.remove(item);} return (A)this;
  }
  
  public A removeAllFromMountOptions(Collection<String> items) {
    if (this.mountOptions == null) return (A)this;
    for (String item : items) { this.mountOptions.remove(item);} return (A)this;
  }
  
  public List<String> getMountOptions() {
    return this.mountOptions;
  }
  
  public String getMountOption(int index) {
    return this.mountOptions.get(index);
  }
  
  public String getFirstMountOption() {
    return this.mountOptions.get(0);
  }
  
  public String getLastMountOption() {
    return this.mountOptions.get(mountOptions.size() - 1);
  }
  
  public String getMatchingMountOption(Predicate<String> predicate) {
      for (String item : mountOptions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMountOption(Predicate<String> predicate) {
      for (String item : mountOptions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMountOptions(List<String> mountOptions) {
    if (mountOptions != null) {
        this.mountOptions = new ArrayList();
        for (String item : mountOptions) {
          this.addToMountOptions(item);
        }
    } else {
      this.mountOptions = null;
    }
    return (A) this;
  }
  
  public A withMountOptions(java.lang.String... mountOptions) {
    if (this.mountOptions != null) {
        this.mountOptions.clear();
        _visitables.remove("mountOptions");
    }
    if (mountOptions != null) {
      for (String item : mountOptions) {
        this.addToMountOptions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMountOptions() {
    return this.mountOptions != null && !this.mountOptions.isEmpty();
  }
  
  public NFSVolumeSource buildNfs() {
    return this.nfs != null ? this.nfs.build() : null;
  }
  
  public A withNfs(NFSVolumeSource nfs) {
    this._visitables.remove("nfs");
    if (nfs != null) {
        this.nfs = new NFSVolumeSourceBuilder(nfs);
        this._visitables.get("nfs").add(this.nfs);
    } else {
        this.nfs = null;
        this._visitables.get("nfs").remove(this.nfs);
    }
    return (A) this;
  }
  
  public boolean hasNfs() {
    return this.nfs != null;
  }
  
  public A withNewNfs(String path,Boolean readOnly,String server) {
    return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
  }
  
  public NfsNested<A> withNewNfs() {
    return new NfsNested(null);
  }
  
  public NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
    return new NfsNested(item);
  }
  
  public NfsNested<A> editNfs() {
    return withNewNfsLike(java.util.Optional.ofNullable(buildNfs()).orElse(null));
  }
  
  public NfsNested<A> editOrNewNfs() {
    return withNewNfsLike(java.util.Optional.ofNullable(buildNfs()).orElse(new NFSVolumeSourceBuilder().build()));
  }
  
  public NfsNested<A> editOrNewNfsLike(NFSVolumeSource item) {
    return withNewNfsLike(java.util.Optional.ofNullable(buildNfs()).orElse(item));
  }
  
  public VolumeNodeAffinity buildNodeAffinity() {
    return this.nodeAffinity != null ? this.nodeAffinity.build() : null;
  }
  
  public A withNodeAffinity(VolumeNodeAffinity nodeAffinity) {
    this._visitables.remove("nodeAffinity");
    if (nodeAffinity != null) {
        this.nodeAffinity = new VolumeNodeAffinityBuilder(nodeAffinity);
        this._visitables.get("nodeAffinity").add(this.nodeAffinity);
    } else {
        this.nodeAffinity = null;
        this._visitables.get("nodeAffinity").remove(this.nodeAffinity);
    }
    return (A) this;
  }
  
  public boolean hasNodeAffinity() {
    return this.nodeAffinity != null;
  }
  
  public NodeAffinityNested<A> withNewNodeAffinity() {
    return new NodeAffinityNested(null);
  }
  
  public NodeAffinityNested<A> withNewNodeAffinityLike(VolumeNodeAffinity item) {
    return new NodeAffinityNested(item);
  }
  
  public NodeAffinityNested<A> editNodeAffinity() {
    return withNewNodeAffinityLike(java.util.Optional.ofNullable(buildNodeAffinity()).orElse(null));
  }
  
  public NodeAffinityNested<A> editOrNewNodeAffinity() {
    return withNewNodeAffinityLike(java.util.Optional.ofNullable(buildNodeAffinity()).orElse(new VolumeNodeAffinityBuilder().build()));
  }
  
  public NodeAffinityNested<A> editOrNewNodeAffinityLike(VolumeNodeAffinity item) {
    return withNewNodeAffinityLike(java.util.Optional.ofNullable(buildNodeAffinity()).orElse(item));
  }
  
  public String getPersistentVolumeReclaimPolicy() {
    return this.persistentVolumeReclaimPolicy;
  }
  
  public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
    this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
    return (A) this;
  }
  
  public boolean hasPersistentVolumeReclaimPolicy() {
    return this.persistentVolumeReclaimPolicy != null;
  }
  
  public PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk() {
    return this.photonPersistentDisk != null ? this.photonPersistentDisk.build() : null;
  }
  
  public A withPhotonPersistentDisk(PhotonPersistentDiskVolumeSource photonPersistentDisk) {
    this._visitables.remove("photonPersistentDisk");
    if (photonPersistentDisk != null) {
        this.photonPersistentDisk = new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk);
        this._visitables.get("photonPersistentDisk").add(this.photonPersistentDisk);
    } else {
        this.photonPersistentDisk = null;
        this._visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk);
    }
    return (A) this;
  }
  
  public boolean hasPhotonPersistentDisk() {
    return this.photonPersistentDisk != null;
  }
  
  public A withNewPhotonPersistentDisk(String fsType,String pdID) {
    return (A)withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  
  public PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk() {
    return new PhotonPersistentDiskNested(null);
  }
  
  public PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
    return new PhotonPersistentDiskNested(item);
  }
  
  public PhotonPersistentDiskNested<A> editPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(java.util.Optional.ofNullable(buildPhotonPersistentDisk()).orElse(null));
  }
  
  public PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(java.util.Optional.ofNullable(buildPhotonPersistentDisk()).orElse(new PhotonPersistentDiskVolumeSourceBuilder().build()));
  }
  
  public PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
    return withNewPhotonPersistentDiskLike(java.util.Optional.ofNullable(buildPhotonPersistentDisk()).orElse(item));
  }
  
  public PortworxVolumeSource buildPortworxVolume() {
    return this.portworxVolume != null ? this.portworxVolume.build() : null;
  }
  
  public A withPortworxVolume(PortworxVolumeSource portworxVolume) {
    this._visitables.remove("portworxVolume");
    if (portworxVolume != null) {
        this.portworxVolume = new PortworxVolumeSourceBuilder(portworxVolume);
        this._visitables.get("portworxVolume").add(this.portworxVolume);
    } else {
        this.portworxVolume = null;
        this._visitables.get("portworxVolume").remove(this.portworxVolume);
    }
    return (A) this;
  }
  
  public boolean hasPortworxVolume() {
    return this.portworxVolume != null;
  }
  
  public A withNewPortworxVolume(String fsType,Boolean readOnly,String volumeID) {
    return (A)withPortworxVolume(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  
  public PortworxVolumeNested<A> withNewPortworxVolume() {
    return new PortworxVolumeNested(null);
  }
  
  public PortworxVolumeNested<A> withNewPortworxVolumeLike(PortworxVolumeSource item) {
    return new PortworxVolumeNested(item);
  }
  
  public PortworxVolumeNested<A> editPortworxVolume() {
    return withNewPortworxVolumeLike(java.util.Optional.ofNullable(buildPortworxVolume()).orElse(null));
  }
  
  public PortworxVolumeNested<A> editOrNewPortworxVolume() {
    return withNewPortworxVolumeLike(java.util.Optional.ofNullable(buildPortworxVolume()).orElse(new PortworxVolumeSourceBuilder().build()));
  }
  
  public PortworxVolumeNested<A> editOrNewPortworxVolumeLike(PortworxVolumeSource item) {
    return withNewPortworxVolumeLike(java.util.Optional.ofNullable(buildPortworxVolume()).orElse(item));
  }
  
  public QuobyteVolumeSource buildQuobyte() {
    return this.quobyte != null ? this.quobyte.build() : null;
  }
  
  public A withQuobyte(QuobyteVolumeSource quobyte) {
    this._visitables.remove("quobyte");
    if (quobyte != null) {
        this.quobyte = new QuobyteVolumeSourceBuilder(quobyte);
        this._visitables.get("quobyte").add(this.quobyte);
    } else {
        this.quobyte = null;
        this._visitables.get("quobyte").remove(this.quobyte);
    }
    return (A) this;
  }
  
  public boolean hasQuobyte() {
    return this.quobyte != null;
  }
  
  public QuobyteNested<A> withNewQuobyte() {
    return new QuobyteNested(null);
  }
  
  public QuobyteNested<A> withNewQuobyteLike(QuobyteVolumeSource item) {
    return new QuobyteNested(item);
  }
  
  public QuobyteNested<A> editQuobyte() {
    return withNewQuobyteLike(java.util.Optional.ofNullable(buildQuobyte()).orElse(null));
  }
  
  public QuobyteNested<A> editOrNewQuobyte() {
    return withNewQuobyteLike(java.util.Optional.ofNullable(buildQuobyte()).orElse(new QuobyteVolumeSourceBuilder().build()));
  }
  
  public QuobyteNested<A> editOrNewQuobyteLike(QuobyteVolumeSource item) {
    return withNewQuobyteLike(java.util.Optional.ofNullable(buildQuobyte()).orElse(item));
  }
  
  public RBDPersistentVolumeSource buildRbd() {
    return this.rbd != null ? this.rbd.build() : null;
  }
  
  public A withRbd(RBDPersistentVolumeSource rbd) {
    this._visitables.remove("rbd");
    if (rbd != null) {
        this.rbd = new RBDPersistentVolumeSourceBuilder(rbd);
        this._visitables.get("rbd").add(this.rbd);
    } else {
        this.rbd = null;
        this._visitables.get("rbd").remove(this.rbd);
    }
    return (A) this;
  }
  
  public boolean hasRbd() {
    return this.rbd != null;
  }
  
  public RbdNested<A> withNewRbd() {
    return new RbdNested(null);
  }
  
  public RbdNested<A> withNewRbdLike(RBDPersistentVolumeSource item) {
    return new RbdNested(item);
  }
  
  public RbdNested<A> editRbd() {
    return withNewRbdLike(java.util.Optional.ofNullable(buildRbd()).orElse(null));
  }
  
  public RbdNested<A> editOrNewRbd() {
    return withNewRbdLike(java.util.Optional.ofNullable(buildRbd()).orElse(new RBDPersistentVolumeSourceBuilder().build()));
  }
  
  public RbdNested<A> editOrNewRbdLike(RBDPersistentVolumeSource item) {
    return withNewRbdLike(java.util.Optional.ofNullable(buildRbd()).orElse(item));
  }
  
  public ScaleIOPersistentVolumeSource buildScaleIO() {
    return this.scaleIO != null ? this.scaleIO.build() : null;
  }
  
  public A withScaleIO(ScaleIOPersistentVolumeSource scaleIO) {
    this._visitables.remove("scaleIO");
    if (scaleIO != null) {
        this.scaleIO = new ScaleIOPersistentVolumeSourceBuilder(scaleIO);
        this._visitables.get("scaleIO").add(this.scaleIO);
    } else {
        this.scaleIO = null;
        this._visitables.get("scaleIO").remove(this.scaleIO);
    }
    return (A) this;
  }
  
  public boolean hasScaleIO() {
    return this.scaleIO != null;
  }
  
  public ScaleIONested<A> withNewScaleIO() {
    return new ScaleIONested(null);
  }
  
  public ScaleIONested<A> withNewScaleIOLike(ScaleIOPersistentVolumeSource item) {
    return new ScaleIONested(item);
  }
  
  public ScaleIONested<A> editScaleIO() {
    return withNewScaleIOLike(java.util.Optional.ofNullable(buildScaleIO()).orElse(null));
  }
  
  public ScaleIONested<A> editOrNewScaleIO() {
    return withNewScaleIOLike(java.util.Optional.ofNullable(buildScaleIO()).orElse(new ScaleIOPersistentVolumeSourceBuilder().build()));
  }
  
  public ScaleIONested<A> editOrNewScaleIOLike(ScaleIOPersistentVolumeSource item) {
    return withNewScaleIOLike(java.util.Optional.ofNullable(buildScaleIO()).orElse(item));
  }
  
  public String getStorageClassName() {
    return this.storageClassName;
  }
  
  public A withStorageClassName(String storageClassName) {
    this.storageClassName = storageClassName;
    return (A) this;
  }
  
  public boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  
  public StorageOSPersistentVolumeSource buildStorageos() {
    return this.storageos != null ? this.storageos.build() : null;
  }
  
  public A withStorageos(StorageOSPersistentVolumeSource storageos) {
    this._visitables.remove("storageos");
    if (storageos != null) {
        this.storageos = new StorageOSPersistentVolumeSourceBuilder(storageos);
        this._visitables.get("storageos").add(this.storageos);
    } else {
        this.storageos = null;
        this._visitables.get("storageos").remove(this.storageos);
    }
    return (A) this;
  }
  
  public boolean hasStorageos() {
    return this.storageos != null;
  }
  
  public StorageosNested<A> withNewStorageos() {
    return new StorageosNested(null);
  }
  
  public StorageosNested<A> withNewStorageosLike(StorageOSPersistentVolumeSource item) {
    return new StorageosNested(item);
  }
  
  public StorageosNested<A> editStorageos() {
    return withNewStorageosLike(java.util.Optional.ofNullable(buildStorageos()).orElse(null));
  }
  
  public StorageosNested<A> editOrNewStorageos() {
    return withNewStorageosLike(java.util.Optional.ofNullable(buildStorageos()).orElse(new StorageOSPersistentVolumeSourceBuilder().build()));
  }
  
  public StorageosNested<A> editOrNewStorageosLike(StorageOSPersistentVolumeSource item) {
    return withNewStorageosLike(java.util.Optional.ofNullable(buildStorageos()).orElse(item));
  }
  
  public String getVolumeAttributesClassName() {
    return this.volumeAttributesClassName;
  }
  
  public A withVolumeAttributesClassName(String volumeAttributesClassName) {
    this.volumeAttributesClassName = volumeAttributesClassName;
    return (A) this;
  }
  
  public boolean hasVolumeAttributesClassName() {
    return this.volumeAttributesClassName != null;
  }
  
  public String getVolumeMode() {
    return this.volumeMode;
  }
  
  public A withVolumeMode(String volumeMode) {
    this.volumeMode = volumeMode;
    return (A) this;
  }
  
  public boolean hasVolumeMode() {
    return this.volumeMode != null;
  }
  
  public VsphereVirtualDiskVolumeSource buildVsphereVolume() {
    return this.vsphereVolume != null ? this.vsphereVolume.build() : null;
  }
  
  public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume) {
    this._visitables.remove("vsphereVolume");
    if (vsphereVolume != null) {
        this.vsphereVolume = new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume);
        this._visitables.get("vsphereVolume").add(this.vsphereVolume);
    } else {
        this.vsphereVolume = null;
        this._visitables.get("vsphereVolume").remove(this.vsphereVolume);
    }
    return (A) this;
  }
  
  public boolean hasVsphereVolume() {
    return this.vsphereVolume != null;
  }
  
  public A withNewVsphereVolume(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
    return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  
  public VsphereVolumeNested<A> withNewVsphereVolume() {
    return new VsphereVolumeNested(null);
  }
  
  public VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
    return new VsphereVolumeNested(item);
  }
  
  public VsphereVolumeNested<A> editVsphereVolume() {
    return withNewVsphereVolumeLike(java.util.Optional.ofNullable(buildVsphereVolume()).orElse(null));
  }
  
  public VsphereVolumeNested<A> editOrNewVsphereVolume() {
    return withNewVsphereVolumeLike(java.util.Optional.ofNullable(buildVsphereVolume()).orElse(new VsphereVirtualDiskVolumeSourceBuilder().build()));
  }
  
  public VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
    return withNewVsphereVolumeLike(java.util.Optional.ofNullable(buildVsphereVolume()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeSpecFluent that = (PersistentVolumeSpecFluent) o;
    if (!java.util.Objects.equals(accessModes, that.accessModes)) return false;
    if (!java.util.Objects.equals(awsElasticBlockStore, that.awsElasticBlockStore)) return false;
    if (!java.util.Objects.equals(azureDisk, that.azureDisk)) return false;
    if (!java.util.Objects.equals(azureFile, that.azureFile)) return false;
    if (!java.util.Objects.equals(capacity, that.capacity)) return false;
    if (!java.util.Objects.equals(cephfs, that.cephfs)) return false;
    if (!java.util.Objects.equals(cinder, that.cinder)) return false;
    if (!java.util.Objects.equals(claimRef, that.claimRef)) return false;
    if (!java.util.Objects.equals(csi, that.csi)) return false;
    if (!java.util.Objects.equals(fc, that.fc)) return false;
    if (!java.util.Objects.equals(flexVolume, that.flexVolume)) return false;
    if (!java.util.Objects.equals(flocker, that.flocker)) return false;
    if (!java.util.Objects.equals(gcePersistentDisk, that.gcePersistentDisk)) return false;
    if (!java.util.Objects.equals(glusterfs, that.glusterfs)) return false;
    if (!java.util.Objects.equals(hostPath, that.hostPath)) return false;
    if (!java.util.Objects.equals(iscsi, that.iscsi)) return false;
    if (!java.util.Objects.equals(local, that.local)) return false;
    if (!java.util.Objects.equals(mountOptions, that.mountOptions)) return false;
    if (!java.util.Objects.equals(nfs, that.nfs)) return false;
    if (!java.util.Objects.equals(nodeAffinity, that.nodeAffinity)) return false;
    if (!java.util.Objects.equals(persistentVolumeReclaimPolicy, that.persistentVolumeReclaimPolicy)) return false;
    if (!java.util.Objects.equals(photonPersistentDisk, that.photonPersistentDisk)) return false;
    if (!java.util.Objects.equals(portworxVolume, that.portworxVolume)) return false;
    if (!java.util.Objects.equals(quobyte, that.quobyte)) return false;
    if (!java.util.Objects.equals(rbd, that.rbd)) return false;
    if (!java.util.Objects.equals(scaleIO, that.scaleIO)) return false;
    if (!java.util.Objects.equals(storageClassName, that.storageClassName)) return false;
    if (!java.util.Objects.equals(storageos, that.storageos)) return false;
    if (!java.util.Objects.equals(volumeAttributesClassName, that.volumeAttributesClassName)) return false;
    if (!java.util.Objects.equals(volumeMode, that.volumeMode)) return false;
    if (!java.util.Objects.equals(vsphereVolume, that.vsphereVolume)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  awsElasticBlockStore,  azureDisk,  azureFile,  capacity,  cephfs,  cinder,  claimRef,  csi,  fc,  flexVolume,  flocker,  gcePersistentDisk,  glusterfs,  hostPath,  iscsi,  local,  mountOptions,  nfs,  nodeAffinity,  persistentVolumeReclaimPolicy,  photonPersistentDisk,  portworxVolume,  quobyte,  rbd,  scaleIO,  storageClassName,  storageos,  volumeAttributesClassName,  volumeMode,  vsphereVolume,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (awsElasticBlockStore != null) { sb.append("awsElasticBlockStore:"); sb.append(awsElasticBlockStore + ","); }
    if (azureDisk != null) { sb.append("azureDisk:"); sb.append(azureDisk + ","); }
    if (azureFile != null) { sb.append("azureFile:"); sb.append(azureFile + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (cephfs != null) { sb.append("cephfs:"); sb.append(cephfs + ","); }
    if (cinder != null) { sb.append("cinder:"); sb.append(cinder + ","); }
    if (claimRef != null) { sb.append("claimRef:"); sb.append(claimRef + ","); }
    if (csi != null) { sb.append("csi:"); sb.append(csi + ","); }
    if (fc != null) { sb.append("fc:"); sb.append(fc + ","); }
    if (flexVolume != null) { sb.append("flexVolume:"); sb.append(flexVolume + ","); }
    if (flocker != null) { sb.append("flocker:"); sb.append(flocker + ","); }
    if (gcePersistentDisk != null) { sb.append("gcePersistentDisk:"); sb.append(gcePersistentDisk + ","); }
    if (glusterfs != null) { sb.append("glusterfs:"); sb.append(glusterfs + ","); }
    if (hostPath != null) { sb.append("hostPath:"); sb.append(hostPath + ","); }
    if (iscsi != null) { sb.append("iscsi:"); sb.append(iscsi + ","); }
    if (local != null) { sb.append("local:"); sb.append(local + ","); }
    if (mountOptions != null && !mountOptions.isEmpty()) { sb.append("mountOptions:"); sb.append(mountOptions + ","); }
    if (nfs != null) { sb.append("nfs:"); sb.append(nfs + ","); }
    if (nodeAffinity != null) { sb.append("nodeAffinity:"); sb.append(nodeAffinity + ","); }
    if (persistentVolumeReclaimPolicy != null) { sb.append("persistentVolumeReclaimPolicy:"); sb.append(persistentVolumeReclaimPolicy + ","); }
    if (photonPersistentDisk != null) { sb.append("photonPersistentDisk:"); sb.append(photonPersistentDisk + ","); }
    if (portworxVolume != null) { sb.append("portworxVolume:"); sb.append(portworxVolume + ","); }
    if (quobyte != null) { sb.append("quobyte:"); sb.append(quobyte + ","); }
    if (rbd != null) { sb.append("rbd:"); sb.append(rbd + ","); }
    if (scaleIO != null) { sb.append("scaleIO:"); sb.append(scaleIO + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (storageos != null) { sb.append("storageos:"); sb.append(storageos + ","); }
    if (volumeAttributesClassName != null) { sb.append("volumeAttributesClassName:"); sb.append(volumeAttributesClassName + ","); }
    if (volumeMode != null) { sb.append("volumeMode:"); sb.append(volumeMode + ","); }
    if (vsphereVolume != null) { sb.append("vsphereVolume:"); sb.append(vsphereVolume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsElasticBlockStoreNested<N> extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>> implements Nested<N>{
    AwsElasticBlockStoreNested(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AWSElasticBlockStoreVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withAwsElasticBlockStore(builder.build());
    }
    
    public N endAwsElasticBlockStore() {
      return and();
    }
    
  
  }
  public class AzureDiskNested<N> extends AzureDiskVolumeSourceFluent<AzureDiskNested<N>> implements Nested<N>{
    AzureDiskNested(AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withAzureDisk(builder.build());
    }
    
    public N endAzureDisk() {
      return and();
    }
    
  
  }
  public class AzureFileNested<N> extends AzureFilePersistentVolumeSourceFluent<AzureFileNested<N>> implements Nested<N>{
    AzureFileNested(AzureFilePersistentVolumeSource item) {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
    }
    AzureFilePersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withAzureFile(builder.build());
    }
    
    public N endAzureFile() {
      return and();
    }
    
  
  }
  public class CephfsNested<N> extends CephFSPersistentVolumeSourceFluent<CephfsNested<N>> implements Nested<N>{
    CephfsNested(CephFSPersistentVolumeSource item) {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
    }
    CephFSPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withCephfs(builder.build());
    }
    
    public N endCephfs() {
      return and();
    }
    
  
  }
  public class CinderNested<N> extends CinderPersistentVolumeSourceFluent<CinderNested<N>> implements Nested<N>{
    CinderNested(CinderPersistentVolumeSource item) {
      this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
    }
    CinderPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withCinder(builder.build());
    }
    
    public N endCinder() {
      return and();
    }
    
  
  }
  public class ClaimRefNested<N> extends ObjectReferenceFluent<ClaimRefNested<N>> implements Nested<N>{
    ClaimRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withClaimRef(builder.build());
    }
    
    public N endClaimRef() {
      return and();
    }
    
  
  }
  public class CsiNested<N> extends CSIPersistentVolumeSourceFluent<CsiNested<N>> implements Nested<N>{
    CsiNested(CSIPersistentVolumeSource item) {
      this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
    }
    CSIPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withCsi(builder.build());
    }
    
    public N endCsi() {
      return and();
    }
    
  
  }
  public class FcNested<N> extends FCVolumeSourceFluent<FcNested<N>> implements Nested<N>{
    FcNested(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FCVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withFc(builder.build());
    }
    
    public N endFc() {
      return and();
    }
    
  
  }
  public class FlexVolumeNested<N> extends FlexPersistentVolumeSourceFluent<FlexVolumeNested<N>> implements Nested<N>{
    FlexVolumeNested(FlexPersistentVolumeSource item) {
      this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
    }
    FlexPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withFlexVolume(builder.build());
    }
    
    public N endFlexVolume() {
      return and();
    }
    
  
  }
  public class FlockerNested<N> extends FlockerVolumeSourceFluent<FlockerNested<N>> implements Nested<N>{
    FlockerNested(FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withFlocker(builder.build());
    }
    
    public N endFlocker() {
      return and();
    }
    
  
  }
  public class GcePersistentDiskNested<N> extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>> implements Nested<N>{
    GcePersistentDiskNested(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GCEPersistentDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withGcePersistentDisk(builder.build());
    }
    
    public N endGcePersistentDisk() {
      return and();
    }
    
  
  }
  public class GlusterfsNested<N> extends GlusterfsPersistentVolumeSourceFluent<GlusterfsNested<N>> implements Nested<N>{
    GlusterfsNested(GlusterfsPersistentVolumeSource item) {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
    }
    GlusterfsPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withGlusterfs(builder.build());
    }
    
    public N endGlusterfs() {
      return and();
    }
    
  
  }
  public class HostPathNested<N> extends HostPathVolumeSourceFluent<HostPathNested<N>> implements Nested<N>{
    HostPathNested(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withHostPath(builder.build());
    }
    
    public N endHostPath() {
      return and();
    }
    
  
  }
  public class IscsiNested<N> extends ISCSIPersistentVolumeSourceFluent<IscsiNested<N>> implements Nested<N>{
    IscsiNested(ISCSIPersistentVolumeSource item) {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
    }
    ISCSIPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withIscsi(builder.build());
    }
    
    public N endIscsi() {
      return and();
    }
    
  
  }
  public class LocalNested<N> extends LocalVolumeSourceFluent<LocalNested<N>> implements Nested<N>{
    LocalNested(LocalVolumeSource item) {
      this.builder = new LocalVolumeSourceBuilder(this, item);
    }
    LocalVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withLocal(builder.build());
    }
    
    public N endLocal() {
      return and();
    }
    
  
  }
  public class NfsNested<N> extends NFSVolumeSourceFluent<NfsNested<N>> implements Nested<N>{
    NfsNested(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NFSVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withNfs(builder.build());
    }
    
    public N endNfs() {
      return and();
    }
    
  
  }
  public class NodeAffinityNested<N> extends VolumeNodeAffinityFluent<NodeAffinityNested<N>> implements Nested<N>{
    NodeAffinityNested(VolumeNodeAffinity item) {
      this.builder = new VolumeNodeAffinityBuilder(this, item);
    }
    VolumeNodeAffinityBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withNodeAffinity(builder.build());
    }
    
    public N endNodeAffinity() {
      return and();
    }
    
  
  }
  public class PhotonPersistentDiskNested<N> extends PhotonPersistentDiskVolumeSourceFluent<PhotonPersistentDiskNested<N>> implements Nested<N>{
    PhotonPersistentDiskNested(PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withPhotonPersistentDisk(builder.build());
    }
    
    public N endPhotonPersistentDisk() {
      return and();
    }
    
  
  }
  public class PortworxVolumeNested<N> extends PortworxVolumeSourceFluent<PortworxVolumeNested<N>> implements Nested<N>{
    PortworxVolumeNested(PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withPortworxVolume(builder.build());
    }
    
    public N endPortworxVolume() {
      return and();
    }
    
  
  }
  public class QuobyteNested<N> extends QuobyteVolumeSourceFluent<QuobyteNested<N>> implements Nested<N>{
    QuobyteNested(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withQuobyte(builder.build());
    }
    
    public N endQuobyte() {
      return and();
    }
    
  
  }
  public class RbdNested<N> extends RBDPersistentVolumeSourceFluent<RbdNested<N>> implements Nested<N>{
    RbdNested(RBDPersistentVolumeSource item) {
      this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
    }
    RBDPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withRbd(builder.build());
    }
    
    public N endRbd() {
      return and();
    }
    
  
  }
  public class ScaleIONested<N> extends ScaleIOPersistentVolumeSourceFluent<ScaleIONested<N>> implements Nested<N>{
    ScaleIONested(ScaleIOPersistentVolumeSource item) {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
    }
    ScaleIOPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withScaleIO(builder.build());
    }
    
    public N endScaleIO() {
      return and();
    }
    
  
  }
  public class StorageosNested<N> extends StorageOSPersistentVolumeSourceFluent<StorageosNested<N>> implements Nested<N>{
    StorageosNested(StorageOSPersistentVolumeSource item) {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
    }
    StorageOSPersistentVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withStorageos(builder.build());
    }
    
    public N endStorageos() {
      return and();
    }
    
  
  }
  public class VsphereVolumeNested<N> extends VsphereVirtualDiskVolumeSourceFluent<VsphereVolumeNested<N>> implements Nested<N>{
    VsphereVolumeNested(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVirtualDiskVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PersistentVolumeSpecFluent.this.withVsphereVolume(builder.build());
    }
    
    public N endVsphereVolume() {
      return and();
    }
    
  
  }

}