package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SELinuxOptionsBuilder extends SELinuxOptionsFluent<SELinuxOptionsBuilder> implements VisitableBuilder<SELinuxOptions,SELinuxOptionsBuilder>{
  public SELinuxOptionsBuilder() {
    this(new SELinuxOptions());
  }
  
  public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent) {
    this(fluent, new SELinuxOptions());
  }
  
  public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent,SELinuxOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SELinuxOptionsBuilder(SELinuxOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SELinuxOptionsFluent<?> fluent;
  
  public SELinuxOptions build() {
    SELinuxOptions buildable = new SELinuxOptions(fluent.getLevel(),fluent.getRole(),fluent.getType(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}