package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodTemplateBuilder extends PodTemplateFluent<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,PodTemplateBuilder>{
  public PodTemplateBuilder() {
    this(new PodTemplate());
  }
  
  public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
    this(fluent, new PodTemplate());
  }
  
  public PodTemplateBuilder(PodTemplateFluent<?> fluent,PodTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodTemplateBuilder(PodTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodTemplateFluent<?> fluent;
  
  public PodTemplate build() {
    PodTemplate buildable = new PodTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}