package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentVolumeStatusBuilder extends PersistentVolumeStatusFluent<PersistentVolumeStatusBuilder> implements VisitableBuilder<PersistentVolumeStatus,PersistentVolumeStatusBuilder>{
  public PersistentVolumeStatusBuilder() {
    this(new PersistentVolumeStatus());
  }
  
  public PersistentVolumeStatusBuilder(PersistentVolumeStatusFluent<?> fluent) {
    this(fluent, new PersistentVolumeStatus());
  }
  
  public PersistentVolumeStatusBuilder(PersistentVolumeStatusFluent<?> fluent,PersistentVolumeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentVolumeStatusBuilder(PersistentVolumeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentVolumeStatusFluent<?> fluent;
  
  public PersistentVolumeStatus build() {
    PersistentVolumeStatus buildable = new PersistentVolumeStatus(fluent.getLastPhaseTransitionTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}