package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamespaceListBuilder extends NamespaceListFluent<NamespaceListBuilder> implements VisitableBuilder<NamespaceList,NamespaceListBuilder>{
  public NamespaceListBuilder() {
    this(new NamespaceList());
  }
  
  public NamespaceListBuilder(NamespaceListFluent<?> fluent) {
    this(fluent, new NamespaceList());
  }
  
  public NamespaceListBuilder(NamespaceListFluent<?> fluent,NamespaceList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamespaceListBuilder(NamespaceList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamespaceListFluent<?> fluent;
  
  public NamespaceList build() {
    NamespaceList buildable = new NamespaceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}