package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceFieldSelectorBuilder extends ResourceFieldSelectorFluent<ResourceFieldSelectorBuilder> implements VisitableBuilder<ResourceFieldSelector,ResourceFieldSelectorBuilder>{
  public ResourceFieldSelectorBuilder() {
    this(new ResourceFieldSelector());
  }
  
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
    this(fluent, new ResourceFieldSelector());
  }
  
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceFieldSelectorBuilder(ResourceFieldSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceFieldSelectorFluent<?> fluent;
  
  public ResourceFieldSelector build() {
    ResourceFieldSelector buildable = new ResourceFieldSelector(fluent.getContainerName(),fluent.buildDivisor(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}