package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PatchOptionsBuilder extends PatchOptionsFluent<PatchOptionsBuilder> implements VisitableBuilder<PatchOptions,PatchOptionsBuilder>{
  public PatchOptionsBuilder() {
    this(new PatchOptions());
  }
  
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent) {
    this(fluent, new PatchOptions());
  }
  
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,PatchOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PatchOptionsBuilder(PatchOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PatchOptionsFluent<?> fluent;
  
  public PatchOptions build() {
    PatchOptions buildable = new PatchOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getForce(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}