package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VolumeProjectionFluent<A extends VolumeProjectionFluent<A>> extends BaseFluent<A>{
  public VolumeProjectionFluent() {
  }
  
  public VolumeProjectionFluent(VolumeProjection instance) {
    this.copyInstance(instance);
  }
  private ClusterTrustBundleProjectionBuilder clusterTrustBundle;
  private ConfigMapProjectionBuilder configMap;
  private DownwardAPIProjectionBuilder downwardAPI;
  private SecretProjectionBuilder secret;
  private ServiceAccountTokenProjectionBuilder serviceAccountToken;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VolumeProjection instance) {
    instance = (instance != null ? instance : new VolumeProjection());
    if (instance != null) {
          this.withClusterTrustBundle(instance.getClusterTrustBundle());
          this.withConfigMap(instance.getConfigMap());
          this.withDownwardAPI(instance.getDownwardAPI());
          this.withSecret(instance.getSecret());
          this.withServiceAccountToken(instance.getServiceAccountToken());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ClusterTrustBundleProjection buildClusterTrustBundle() {
    return this.clusterTrustBundle != null ? this.clusterTrustBundle.build() : null;
  }
  
  public A withClusterTrustBundle(ClusterTrustBundleProjection clusterTrustBundle) {
    this._visitables.remove("clusterTrustBundle");
    if (clusterTrustBundle != null) {
        this.clusterTrustBundle = new ClusterTrustBundleProjectionBuilder(clusterTrustBundle);
        this._visitables.get("clusterTrustBundle").add(this.clusterTrustBundle);
    } else {
        this.clusterTrustBundle = null;
        this._visitables.get("clusterTrustBundle").remove(this.clusterTrustBundle);
    }
    return (A) this;
  }
  
  public boolean hasClusterTrustBundle() {
    return this.clusterTrustBundle != null;
  }
  
  public ClusterTrustBundleNested<A> withNewClusterTrustBundle() {
    return new ClusterTrustBundleNested(null);
  }
  
  public ClusterTrustBundleNested<A> withNewClusterTrustBundleLike(ClusterTrustBundleProjection item) {
    return new ClusterTrustBundleNested(item);
  }
  
  public ClusterTrustBundleNested<A> editClusterTrustBundle() {
    return withNewClusterTrustBundleLike(java.util.Optional.ofNullable(buildClusterTrustBundle()).orElse(null));
  }
  
  public ClusterTrustBundleNested<A> editOrNewClusterTrustBundle() {
    return withNewClusterTrustBundleLike(java.util.Optional.ofNullable(buildClusterTrustBundle()).orElse(new ClusterTrustBundleProjectionBuilder().build()));
  }
  
  public ClusterTrustBundleNested<A> editOrNewClusterTrustBundleLike(ClusterTrustBundleProjection item) {
    return withNewClusterTrustBundleLike(java.util.Optional.ofNullable(buildClusterTrustBundle()).orElse(item));
  }
  
  public ConfigMapProjection buildConfigMap() {
    return this.configMap != null ? this.configMap.build() : null;
  }
  
  public A withConfigMap(ConfigMapProjection configMap) {
    this._visitables.remove("configMap");
    if (configMap != null) {
        this.configMap = new ConfigMapProjectionBuilder(configMap);
        this._visitables.get("configMap").add(this.configMap);
    } else {
        this.configMap = null;
        this._visitables.get("configMap").remove(this.configMap);
    }
    return (A) this;
  }
  
  public boolean hasConfigMap() {
    return this.configMap != null;
  }
  
  public ConfigMapNested<A> withNewConfigMap() {
    return new ConfigMapNested(null);
  }
  
  public ConfigMapNested<A> withNewConfigMapLike(ConfigMapProjection item) {
    return new ConfigMapNested(item);
  }
  
  public ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(null));
  }
  
  public ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(new ConfigMapProjectionBuilder().build()));
  }
  
  public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapProjection item) {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(item));
  }
  
  public DownwardAPIProjection buildDownwardAPI() {
    return this.downwardAPI != null ? this.downwardAPI.build() : null;
  }
  
  public A withDownwardAPI(DownwardAPIProjection downwardAPI) {
    this._visitables.remove("downwardAPI");
    if (downwardAPI != null) {
        this.downwardAPI = new DownwardAPIProjectionBuilder(downwardAPI);
        this._visitables.get("downwardAPI").add(this.downwardAPI);
    } else {
        this.downwardAPI = null;
        this._visitables.get("downwardAPI").remove(this.downwardAPI);
    }
    return (A) this;
  }
  
  public boolean hasDownwardAPI() {
    return this.downwardAPI != null;
  }
  
  public DownwardAPINested<A> withNewDownwardAPI() {
    return new DownwardAPINested(null);
  }
  
  public DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIProjection item) {
    return new DownwardAPINested(item);
  }
  
  public DownwardAPINested<A> editDownwardAPI() {
    return withNewDownwardAPILike(java.util.Optional.ofNullable(buildDownwardAPI()).orElse(null));
  }
  
  public DownwardAPINested<A> editOrNewDownwardAPI() {
    return withNewDownwardAPILike(java.util.Optional.ofNullable(buildDownwardAPI()).orElse(new DownwardAPIProjectionBuilder().build()));
  }
  
  public DownwardAPINested<A> editOrNewDownwardAPILike(DownwardAPIProjection item) {
    return withNewDownwardAPILike(java.util.Optional.ofNullable(buildDownwardAPI()).orElse(item));
  }
  
  public SecretProjection buildSecret() {
    return this.secret != null ? this.secret.build() : null;
  }
  
  public A withSecret(SecretProjection secret) {
    this._visitables.remove("secret");
    if (secret != null) {
        this.secret = new SecretProjectionBuilder(secret);
        this._visitables.get("secret").add(this.secret);
    } else {
        this.secret = null;
        this._visitables.get("secret").remove(this.secret);
    }
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public SecretNested<A> withNewSecret() {
    return new SecretNested(null);
  }
  
  public SecretNested<A> withNewSecretLike(SecretProjection item) {
    return new SecretNested(item);
  }
  
  public SecretNested<A> editSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(null));
  }
  
  public SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(new SecretProjectionBuilder().build()));
  }
  
  public SecretNested<A> editOrNewSecretLike(SecretProjection item) {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(item));
  }
  
  public ServiceAccountTokenProjection buildServiceAccountToken() {
    return this.serviceAccountToken != null ? this.serviceAccountToken.build() : null;
  }
  
  public A withServiceAccountToken(ServiceAccountTokenProjection serviceAccountToken) {
    this._visitables.remove("serviceAccountToken");
    if (serviceAccountToken != null) {
        this.serviceAccountToken = new ServiceAccountTokenProjectionBuilder(serviceAccountToken);
        this._visitables.get("serviceAccountToken").add(this.serviceAccountToken);
    } else {
        this.serviceAccountToken = null;
        this._visitables.get("serviceAccountToken").remove(this.serviceAccountToken);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccountToken() {
    return this.serviceAccountToken != null;
  }
  
  public A withNewServiceAccountToken(String audience,Long expirationSeconds,String path) {
    return (A)withServiceAccountToken(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
  }
  
  public ServiceAccountTokenNested<A> withNewServiceAccountToken() {
    return new ServiceAccountTokenNested(null);
  }
  
  public ServiceAccountTokenNested<A> withNewServiceAccountTokenLike(ServiceAccountTokenProjection item) {
    return new ServiceAccountTokenNested(item);
  }
  
  public ServiceAccountTokenNested<A> editServiceAccountToken() {
    return withNewServiceAccountTokenLike(java.util.Optional.ofNullable(buildServiceAccountToken()).orElse(null));
  }
  
  public ServiceAccountTokenNested<A> editOrNewServiceAccountToken() {
    return withNewServiceAccountTokenLike(java.util.Optional.ofNullable(buildServiceAccountToken()).orElse(new ServiceAccountTokenProjectionBuilder().build()));
  }
  
  public ServiceAccountTokenNested<A> editOrNewServiceAccountTokenLike(ServiceAccountTokenProjection item) {
    return withNewServiceAccountTokenLike(java.util.Optional.ofNullable(buildServiceAccountToken()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeProjectionFluent that = (VolumeProjectionFluent) o;
    if (!java.util.Objects.equals(clusterTrustBundle, that.clusterTrustBundle)) return false;
    if (!java.util.Objects.equals(configMap, that.configMap)) return false;
    if (!java.util.Objects.equals(downwardAPI, that.downwardAPI)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(serviceAccountToken, that.serviceAccountToken)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterTrustBundle,  configMap,  downwardAPI,  secret,  serviceAccountToken,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterTrustBundle != null) { sb.append("clusterTrustBundle:"); sb.append(clusterTrustBundle + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (downwardAPI != null) { sb.append("downwardAPI:"); sb.append(downwardAPI + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (serviceAccountToken != null) { sb.append("serviceAccountToken:"); sb.append(serviceAccountToken + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterTrustBundleNested<N> extends ClusterTrustBundleProjectionFluent<ClusterTrustBundleNested<N>> implements Nested<N>{
    ClusterTrustBundleNested(ClusterTrustBundleProjection item) {
      this.builder = new ClusterTrustBundleProjectionBuilder(this, item);
    }
    ClusterTrustBundleProjectionBuilder builder;
    
    public N and() {
      return (N) VolumeProjectionFluent.this.withClusterTrustBundle(builder.build());
    }
    
    public N endClusterTrustBundle() {
      return and();
    }
    
  
  }
  public class ConfigMapNested<N> extends ConfigMapProjectionFluent<ConfigMapNested<N>> implements Nested<N>{
    ConfigMapNested(ConfigMapProjection item) {
      this.builder = new ConfigMapProjectionBuilder(this, item);
    }
    ConfigMapProjectionBuilder builder;
    
    public N and() {
      return (N) VolumeProjectionFluent.this.withConfigMap(builder.build());
    }
    
    public N endConfigMap() {
      return and();
    }
    
  
  }
  public class DownwardAPINested<N> extends DownwardAPIProjectionFluent<DownwardAPINested<N>> implements Nested<N>{
    DownwardAPINested(DownwardAPIProjection item) {
      this.builder = new DownwardAPIProjectionBuilder(this, item);
    }
    DownwardAPIProjectionBuilder builder;
    
    public N and() {
      return (N) VolumeProjectionFluent.this.withDownwardAPI(builder.build());
    }
    
    public N endDownwardAPI() {
      return and();
    }
    
  
  }
  public class SecretNested<N> extends SecretProjectionFluent<SecretNested<N>> implements Nested<N>{
    SecretNested(SecretProjection item) {
      this.builder = new SecretProjectionBuilder(this, item);
    }
    SecretProjectionBuilder builder;
    
    public N and() {
      return (N) VolumeProjectionFluent.this.withSecret(builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }
  public class ServiceAccountTokenNested<N> extends ServiceAccountTokenProjectionFluent<ServiceAccountTokenNested<N>> implements Nested<N>{
    ServiceAccountTokenNested(ServiceAccountTokenProjection item) {
      this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
    }
    ServiceAccountTokenProjectionBuilder builder;
    
    public N and() {
      return (N) VolumeProjectionFluent.this.withServiceAccountToken(builder.build());
    }
    
    public N endServiceAccountToken() {
      return and();
    }
    
  
  }

}