package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodStatusBuilder extends PodStatusFluent<PodStatusBuilder> implements VisitableBuilder<PodStatus,PodStatusBuilder>{
  public PodStatusBuilder() {
    this(new PodStatus());
  }
  
  public PodStatusBuilder(PodStatusFluent<?> fluent) {
    this(fluent, new PodStatus());
  }
  
  public PodStatusBuilder(PodStatusFluent<?> fluent,PodStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodStatusBuilder(PodStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodStatusFluent<?> fluent;
  
  public PodStatus build() {
    PodStatus buildable = new PodStatus(fluent.buildConditions(),fluent.buildContainerStatuses(),fluent.buildEphemeralContainerStatuses(),fluent.getHostIP(),fluent.buildHostIPs(),fluent.buildInitContainerStatuses(),fluent.getMessage(),fluent.getNominatedNodeName(),fluent.getPhase(),fluent.getPodIP(),fluent.buildPodIPs(),fluent.getQosClass(),fluent.getReason(),fluent.getResize(),fluent.buildResourceClaimStatuses(),fluent.getStartTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}