package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ScaleIOVolumeSourceFluentImpl<A extends ScaleIOVolumeSourceFluent<A>> extends BaseFluent<A> implements ScaleIOVolumeSourceFluent<A>{
  public ScaleIOVolumeSourceFluentImpl() {
  }
  public ScaleIOVolumeSourceFluentImpl(ScaleIOVolumeSource instance) {
    this.withFsType(instance.getFsType()); 
    this.withGateway(instance.getGateway()); 
    this.withProtectionDomain(instance.getProtectionDomain()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withSslEnabled(instance.getSslEnabled()); 
    this.withStorageMode(instance.getStorageMode()); 
    this.withStoragePool(instance.getStoragePool()); 
    this.withSystem(instance.getSystem()); 
    this.withVolumeName(instance.getVolumeName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String fsType;
  private String gateway;
  private String protectionDomain;
  private Boolean readOnly;
  private LocalObjectReferenceBuilder secretRef;
  private Boolean sslEnabled;
  private String storageMode;
  private String storagePool;
  private String system;
  private String volumeName;
  private Map<String,Object> additionalProperties;
  public String getFsType() {
    return this.fsType;
  }
  public A withFsType(String fsType) {
    this.fsType=fsType; return (A) this;
  }
  public Boolean hasFsType() {
    return this.fsType != null;
  }
  public String getGateway() {
    return this.gateway;
  }
  public A withGateway(String gateway) {
    this.gateway=gateway; return (A) this;
  }
  public Boolean hasGateway() {
    return this.gateway != null;
  }
  public String getProtectionDomain() {
    return this.protectionDomain;
  }
  public A withProtectionDomain(String protectionDomain) {
    this.protectionDomain=protectionDomain; return (A) this;
  }
  public Boolean hasProtectionDomain() {
    return this.protectionDomain != null;
  }
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public LocalObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(LocalObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(String name) {
    return (A)withSecretRef(new LocalObjectReference(name));
  }
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new ScaleIOVolumeSourceFluentImpl.SecretRefNestedImpl();
  }
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
    return new ScaleIOVolumeSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public Boolean getSslEnabled() {
    return this.sslEnabled;
  }
  public A withSslEnabled(Boolean sslEnabled) {
    this.sslEnabled=sslEnabled; return (A) this;
  }
  public Boolean hasSslEnabled() {
    return this.sslEnabled != null;
  }
  public String getStorageMode() {
    return this.storageMode;
  }
  public A withStorageMode(String storageMode) {
    this.storageMode=storageMode; return (A) this;
  }
  public Boolean hasStorageMode() {
    return this.storageMode != null;
  }
  public String getStoragePool() {
    return this.storagePool;
  }
  public A withStoragePool(String storagePool) {
    this.storagePool=storagePool; return (A) this;
  }
  public Boolean hasStoragePool() {
    return this.storagePool != null;
  }
  public String getSystem() {
    return this.system;
  }
  public A withSystem(String system) {
    this.system=system; return (A) this;
  }
  public Boolean hasSystem() {
    return this.system != null;
  }
  public String getVolumeName() {
    return this.volumeName;
  }
  public A withVolumeName(String volumeName) {
    this.volumeName=volumeName; return (A) this;
  }
  public Boolean hasVolumeName() {
    return this.volumeName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ScaleIOVolumeSourceFluentImpl that = (ScaleIOVolumeSourceFluentImpl) o;
    if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
    if (gateway != null ? !gateway.equals(that.gateway) :that.gateway != null) return false;
    if (protectionDomain != null ? !protectionDomain.equals(that.protectionDomain) :that.protectionDomain != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (sslEnabled != null ? !sslEnabled.equals(that.sslEnabled) :that.sslEnabled != null) return false;
    if (storageMode != null ? !storageMode.equals(that.storageMode) :that.storageMode != null) return false;
    if (storagePool != null ? !storagePool.equals(that.storagePool) :that.storagePool != null) return false;
    if (system != null ? !system.equals(that.system) :that.system != null) return false;
    if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsType,  gateway,  protectionDomain,  readOnly,  secretRef,  sslEnabled,  storageMode,  storagePool,  system,  volumeName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (gateway != null) { sb.append("gateway:"); sb.append(gateway + ","); }
    if (protectionDomain != null) { sb.append("protectionDomain:"); sb.append(protectionDomain + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (sslEnabled != null) { sb.append("sslEnabled:"); sb.append(sslEnabled + ","); }
    if (storageMode != null) { sb.append("storageMode:"); sb.append(storageMode + ","); }
    if (storagePool != null) { sb.append("storagePool:"); sb.append(storagePool + ","); }
    if (system != null) { sb.append("system:"); sb.append(system + ","); }
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  public A withSslEnabled() {
    return withSslEnabled(true);
  }
  class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ScaleIOVolumeSourceFluent.SecretRefNested<N>> implements ScaleIOVolumeSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ScaleIOVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}