package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PodTemplateListFluent<A extends PodTemplateListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,PodTemplate item);
  public A setToItems(Integer index,PodTemplate item);
  public A addToItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public A addAllToItems(Collection<PodTemplate> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public A removeAllFromItems(Collection<PodTemplate> items);
  public A removeMatchingFromItems(Predicate<PodTemplateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodTemplate> getItems();
  public List<PodTemplate> buildItems();
  public PodTemplate buildItem(Integer index);
  public PodTemplate buildFirstItem();
  public PodTemplate buildLastItem();
  public PodTemplate buildMatchingItem(Predicate<PodTemplateBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<PodTemplateBuilder> predicate);
  public A withItems(List<PodTemplate> items);
  public A withItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public Boolean hasItems();
  public PodTemplateListFluent.ItemsNested<A> addNewItem();
  public PodTemplateListFluent.ItemsNested<A> addNewItemLike(PodTemplate item);
  public PodTemplateListFluent.ItemsNested<A> setNewItemLike(Integer index,PodTemplate item);
  public PodTemplateListFluent.ItemsNested<A> editItem(Integer index);
  public PodTemplateListFluent.ItemsNested<A> editFirstItem();
  public PodTemplateListFluent.ItemsNested<A> editLastItem();
  public PodTemplateListFluent.ItemsNested<A> editMatchingItem(Predicate<PodTemplateBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public PodTemplateListFluent.MetadataNested<A> withNewMetadata();
  public PodTemplateListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public PodTemplateListFluent.MetadataNested<A> editMetadata();
  public PodTemplateListFluent.MetadataNested<A> editOrNewMetadata();
  public PodTemplateListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,PodTemplateFluent<PodTemplateListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PodTemplateListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}