package io.fabric8.kubernetes.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamedExtensionFluentImpl<A extends NamedExtensionFluent<A>> extends BaseFluent<A> implements NamedExtensionFluent<A>{
  public NamedExtensionFluentImpl() {
  }
  public NamedExtensionFluentImpl(NamedExtension instance) {
    this.withExtension(instance.getExtension()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private VisitableBuilder<? extends HasMetadata,?> extension;
  private String name;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public HasMetadata buildExtension() {
    return this.extension!=null?this.extension.build():null;
  }
  public A withExtension(HasMetadata extension) {
    if (extension instanceof LimitRange){ this.extension= new LimitRangeBuilder((LimitRange)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof APIService){ this.extension= new APIServiceBuilder((APIService)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Namespace){ this.extension= new NamespaceBuilder((Namespace)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Service){ this.extension= new ServiceBuilder((Service)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ReplicationController){ this.extension= new ReplicationControllerBuilder((ReplicationController)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PodTemplate){ this.extension= new PodTemplateBuilder((PodTemplate)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Event){ this.extension= new EventBuilder((Event)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolume){ this.extension= new PersistentVolumeBuilder((PersistentVolume)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof PersistentVolumeClaim){ this.extension= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof GenericKubernetesResource){ this.extension= new GenericKubernetesResourceBuilder((GenericKubernetesResource)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Endpoints){ this.extension= new EndpointsBuilder((Endpoints)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Pod){ this.extension= new PodBuilder((Pod)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ConfigMap){ this.extension= new ConfigMapBuilder((ConfigMap)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ComponentStatus){ this.extension= new ComponentStatusBuilder((ComponentStatus)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Binding){ this.extension= new BindingBuilder((Binding)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ResourceQuota){ this.extension= new ResourceQuotaBuilder((ResourceQuota)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Secret){ this.extension= new SecretBuilder((Secret)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof Node){ this.extension= new NodeBuilder((Node)extension); _visitables.get("extension").add(this.extension);}
    if (extension instanceof ServiceAccount){ this.extension= new ServiceAccountBuilder((ServiceAccount)extension); _visitables.get("extension").add(this.extension);}
    return (A) this;
  }
  public Boolean hasExtension() {
    return this.extension != null;
  }
  public A withLimitRangeExtension(LimitRange limitRangeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (limitRangeExtension!=null){ this.extension= new LimitRangeBuilder(limitRangeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.LimitRangeExtensionNested<A> withNewLimitRangeExtension() {
    return new NamedExtensionFluentImpl.LimitRangeExtensionNestedImpl();
  }
  public NamedExtensionFluent.LimitRangeExtensionNested<A> withNewLimitRangeExtensionLike(LimitRange item) {
    return new NamedExtensionFluentImpl.LimitRangeExtensionNestedImpl(item);
  }
  public A withAPIServiceExtension(APIService aPIServiceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (aPIServiceExtension!=null){ this.extension= new APIServiceBuilder(aPIServiceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.APIServiceExtensionNested<A> withNewAPIServiceExtension() {
    return new NamedExtensionFluentImpl.APIServiceExtensionNestedImpl();
  }
  public NamedExtensionFluent.APIServiceExtensionNested<A> withNewAPIServiceExtensionLike(APIService item) {
    return new NamedExtensionFluentImpl.APIServiceExtensionNestedImpl(item);
  }
  public A withNamespaceExtension(Namespace namespaceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (namespaceExtension!=null){ this.extension= new NamespaceBuilder(namespaceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NamespaceExtensionNested<A> withNewNamespaceExtension() {
    return new NamedExtensionFluentImpl.NamespaceExtensionNestedImpl();
  }
  public NamedExtensionFluent.NamespaceExtensionNested<A> withNewNamespaceExtensionLike(Namespace item) {
    return new NamedExtensionFluentImpl.NamespaceExtensionNestedImpl(item);
  }
  public A withServiceExtension(Service serviceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceExtension!=null){ this.extension= new ServiceBuilder(serviceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceExtensionNested<A> withNewServiceExtension() {
    return new NamedExtensionFluentImpl.ServiceExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceExtensionNested<A> withNewServiceExtensionLike(Service item) {
    return new NamedExtensionFluentImpl.ServiceExtensionNestedImpl(item);
  }
  public A withReplicationControllerExtension(ReplicationController replicationControllerExtension) {
    _visitables.get("extension").remove(this.extension);
    if (replicationControllerExtension!=null){ this.extension= new ReplicationControllerBuilder(replicationControllerExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ReplicationControllerExtensionNested<A> withNewReplicationControllerExtension() {
    return new NamedExtensionFluentImpl.ReplicationControllerExtensionNestedImpl();
  }
  public NamedExtensionFluent.ReplicationControllerExtensionNested<A> withNewReplicationControllerExtensionLike(ReplicationController item) {
    return new NamedExtensionFluentImpl.ReplicationControllerExtensionNestedImpl(item);
  }
  public A withPodTemplateExtension(PodTemplate podTemplateExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podTemplateExtension!=null){ this.extension= new PodTemplateBuilder(podTemplateExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodTemplateExtensionNested<A> withNewPodTemplateExtension() {
    return new NamedExtensionFluentImpl.PodTemplateExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodTemplateExtensionNested<A> withNewPodTemplateExtensionLike(PodTemplate item) {
    return new NamedExtensionFluentImpl.PodTemplateExtensionNestedImpl(item);
  }
  public A withEventExtension(Event eventExtension) {
    _visitables.get("extension").remove(this.extension);
    if (eventExtension!=null){ this.extension= new EventBuilder(eventExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EventExtensionNested<A> withNewEventExtension() {
    return new NamedExtensionFluentImpl.EventExtensionNestedImpl();
  }
  public NamedExtensionFluent.EventExtensionNested<A> withNewEventExtensionLike(Event item) {
    return new NamedExtensionFluentImpl.EventExtensionNestedImpl(item);
  }
  public A withPersistentVolumeExtension(PersistentVolume persistentVolumeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeExtension!=null){ this.extension= new PersistentVolumeBuilder(persistentVolumeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtensionLike(PersistentVolume item) {
    return new NamedExtensionFluentImpl.PersistentVolumeExtensionNestedImpl(item);
  }
  public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension) {
    _visitables.get("extension").remove(this.extension);
    if (persistentVolumeClaimExtension!=null){ this.extension= new PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimExtensionNestedImpl();
  }
  public NamedExtensionFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item) {
    return new NamedExtensionFluentImpl.PersistentVolumeClaimExtensionNestedImpl(item);
  }
  public A withGenericKubernetesResourceExtension(GenericKubernetesResource genericKubernetesResourceExtension) {
    _visitables.get("extension").remove(this.extension);
    if (genericKubernetesResourceExtension!=null){ this.extension= new GenericKubernetesResourceBuilder(genericKubernetesResourceExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.GenericKubernetesResourceExtensionNested<A> withNewGenericKubernetesResourceExtension() {
    return new NamedExtensionFluentImpl.GenericKubernetesResourceExtensionNestedImpl();
  }
  public NamedExtensionFluent.GenericKubernetesResourceExtensionNested<A> withNewGenericKubernetesResourceExtensionLike(GenericKubernetesResource item) {
    return new NamedExtensionFluentImpl.GenericKubernetesResourceExtensionNestedImpl(item);
  }
  public A withEndpointsExtension(Endpoints endpointsExtension) {
    _visitables.get("extension").remove(this.extension);
    if (endpointsExtension!=null){ this.extension= new EndpointsBuilder(endpointsExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.EndpointsExtensionNested<A> withNewEndpointsExtension() {
    return new NamedExtensionFluentImpl.EndpointsExtensionNestedImpl();
  }
  public NamedExtensionFluent.EndpointsExtensionNested<A> withNewEndpointsExtensionLike(Endpoints item) {
    return new NamedExtensionFluentImpl.EndpointsExtensionNestedImpl(item);
  }
  public A withPodExtension(Pod podExtension) {
    _visitables.get("extension").remove(this.extension);
    if (podExtension!=null){ this.extension= new PodBuilder(podExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.PodExtensionNested<A> withNewPodExtension() {
    return new NamedExtensionFluentImpl.PodExtensionNestedImpl();
  }
  public NamedExtensionFluent.PodExtensionNested<A> withNewPodExtensionLike(Pod item) {
    return new NamedExtensionFluentImpl.PodExtensionNestedImpl(item);
  }
  public A withConfigMapExtension(ConfigMap configMapExtension) {
    _visitables.get("extension").remove(this.extension);
    if (configMapExtension!=null){ this.extension= new ConfigMapBuilder(configMapExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ConfigMapExtensionNested<A> withNewConfigMapExtension() {
    return new NamedExtensionFluentImpl.ConfigMapExtensionNestedImpl();
  }
  public NamedExtensionFluent.ConfigMapExtensionNested<A> withNewConfigMapExtensionLike(ConfigMap item) {
    return new NamedExtensionFluentImpl.ConfigMapExtensionNestedImpl(item);
  }
  public A withComponentStatusExtension(ComponentStatus componentStatusExtension) {
    _visitables.get("extension").remove(this.extension);
    if (componentStatusExtension!=null){ this.extension= new ComponentStatusBuilder(componentStatusExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ComponentStatusExtensionNested<A> withNewComponentStatusExtension() {
    return new NamedExtensionFluentImpl.ComponentStatusExtensionNestedImpl();
  }
  public NamedExtensionFluent.ComponentStatusExtensionNested<A> withNewComponentStatusExtensionLike(ComponentStatus item) {
    return new NamedExtensionFluentImpl.ComponentStatusExtensionNestedImpl(item);
  }
  public A withBindingExtension(Binding bindingExtension) {
    _visitables.get("extension").remove(this.extension);
    if (bindingExtension!=null){ this.extension= new BindingBuilder(bindingExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.BindingExtensionNested<A> withNewBindingExtension() {
    return new NamedExtensionFluentImpl.BindingExtensionNestedImpl();
  }
  public NamedExtensionFluent.BindingExtensionNested<A> withNewBindingExtensionLike(Binding item) {
    return new NamedExtensionFluentImpl.BindingExtensionNestedImpl(item);
  }
  public A withResourceQuotaExtension(ResourceQuota resourceQuotaExtension) {
    _visitables.get("extension").remove(this.extension);
    if (resourceQuotaExtension!=null){ this.extension= new ResourceQuotaBuilder(resourceQuotaExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ResourceQuotaExtensionNested<A> withNewResourceQuotaExtension() {
    return new NamedExtensionFluentImpl.ResourceQuotaExtensionNestedImpl();
  }
  public NamedExtensionFluent.ResourceQuotaExtensionNested<A> withNewResourceQuotaExtensionLike(ResourceQuota item) {
    return new NamedExtensionFluentImpl.ResourceQuotaExtensionNestedImpl(item);
  }
  public A withSecretExtension(Secret secretExtension) {
    _visitables.get("extension").remove(this.extension);
    if (secretExtension!=null){ this.extension= new SecretBuilder(secretExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.SecretExtensionNested<A> withNewSecretExtension() {
    return new NamedExtensionFluentImpl.SecretExtensionNestedImpl();
  }
  public NamedExtensionFluent.SecretExtensionNested<A> withNewSecretExtensionLike(Secret item) {
    return new NamedExtensionFluentImpl.SecretExtensionNestedImpl(item);
  }
  public A withNodeExtension(Node nodeExtension) {
    _visitables.get("extension").remove(this.extension);
    if (nodeExtension!=null){ this.extension= new NodeBuilder(nodeExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.NodeExtensionNested<A> withNewNodeExtension() {
    return new NamedExtensionFluentImpl.NodeExtensionNestedImpl();
  }
  public NamedExtensionFluent.NodeExtensionNested<A> withNewNodeExtensionLike(Node item) {
    return new NamedExtensionFluentImpl.NodeExtensionNestedImpl(item);
  }
  public A withServiceAccountExtension(ServiceAccount serviceAccountExtension) {
    _visitables.get("extension").remove(this.extension);
    if (serviceAccountExtension!=null){ this.extension= new ServiceAccountBuilder(serviceAccountExtension); _visitables.get("extension").add(this.extension);} else { this.extension = null; _visitables.get("extension").remove(this.extension); } return (A) this;
  }
  public NamedExtensionFluent.ServiceAccountExtensionNested<A> withNewServiceAccountExtension() {
    return new NamedExtensionFluentImpl.ServiceAccountExtensionNestedImpl();
  }
  public NamedExtensionFluent.ServiceAccountExtensionNested<A> withNewServiceAccountExtensionLike(ServiceAccount item) {
    return new NamedExtensionFluentImpl.ServiceAccountExtensionNestedImpl(item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NamedExtensionFluentImpl that = (NamedExtensionFluentImpl) o;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(extension,  name,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LimitRangeExtensionNestedImpl<N> extends LimitRangeFluentImpl<NamedExtensionFluent.LimitRangeExtensionNested<N>> implements NamedExtensionFluent.LimitRangeExtensionNested<N>,Nested<N>{
    LimitRangeExtensionNestedImpl(LimitRange item) {
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeExtensionNestedImpl() {
      this.builder = new LimitRangeBuilder(this);
    }
    LimitRangeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endLimitRangeExtension() {
      return and();
    }
    
  }
  class APIServiceExtensionNestedImpl<N> extends APIServiceFluentImpl<NamedExtensionFluent.APIServiceExtensionNested<N>> implements NamedExtensionFluent.APIServiceExtensionNested<N>,Nested<N>{
    APIServiceExtensionNestedImpl(APIService item) {
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceExtensionNestedImpl() {
      this.builder = new APIServiceBuilder(this);
    }
    APIServiceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endAPIServiceExtension() {
      return and();
    }
    
  }
  class NamespaceExtensionNestedImpl<N> extends NamespaceFluentImpl<NamedExtensionFluent.NamespaceExtensionNested<N>> implements NamedExtensionFluent.NamespaceExtensionNested<N>,Nested<N>{
    NamespaceExtensionNestedImpl(Namespace item) {
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceExtensionNestedImpl() {
      this.builder = new NamespaceBuilder(this);
    }
    NamespaceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNamespaceExtension() {
      return and();
    }
    
  }
  class ServiceExtensionNestedImpl<N> extends ServiceFluentImpl<NamedExtensionFluent.ServiceExtensionNested<N>> implements NamedExtensionFluent.ServiceExtensionNested<N>,Nested<N>{
    ServiceExtensionNestedImpl(Service item) {
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceExtensionNestedImpl() {
      this.builder = new ServiceBuilder(this);
    }
    ServiceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceExtension() {
      return and();
    }
    
  }
  class ReplicationControllerExtensionNestedImpl<N> extends ReplicationControllerFluentImpl<NamedExtensionFluent.ReplicationControllerExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerExtensionNested<N>,Nested<N>{
    ReplicationControllerExtensionNestedImpl(ReplicationController item) {
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerExtensionNestedImpl() {
      this.builder = new ReplicationControllerBuilder(this);
    }
    ReplicationControllerBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endReplicationControllerExtension() {
      return and();
    }
    
  }
  class PodTemplateExtensionNestedImpl<N> extends PodTemplateFluentImpl<NamedExtensionFluent.PodTemplateExtensionNested<N>> implements NamedExtensionFluent.PodTemplateExtensionNested<N>,Nested<N>{
    PodTemplateExtensionNestedImpl(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateExtensionNestedImpl() {
      this.builder = new PodTemplateBuilder(this);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodTemplateExtension() {
      return and();
    }
    
  }
  class EventExtensionNestedImpl<N> extends EventFluentImpl<NamedExtensionFluent.EventExtensionNested<N>> implements NamedExtensionFluent.EventExtensionNested<N>,Nested<N>{
    EventExtensionNestedImpl(Event item) {
      this.builder = new EventBuilder(this, item);
    }
    EventExtensionNestedImpl() {
      this.builder = new EventBuilder(this);
    }
    EventBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEventExtension() {
      return and();
    }
    
  }
  class PersistentVolumeExtensionNestedImpl<N> extends PersistentVolumeFluentImpl<NamedExtensionFluent.PersistentVolumeExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeExtensionNested<N>,Nested<N>{
    PersistentVolumeExtensionNestedImpl(PersistentVolume item) {
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeExtensionNestedImpl() {
      this.builder = new PersistentVolumeBuilder(this);
    }
    PersistentVolumeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeExtension() {
      return and();
    }
    
  }
  class PersistentVolumeClaimExtensionNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NamedExtensionFluent.PersistentVolumeClaimExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimExtensionNested<N>,Nested<N>{
    PersistentVolumeClaimExtensionNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimExtensionNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPersistentVolumeClaimExtension() {
      return and();
    }
    
  }
  class GenericKubernetesResourceExtensionNestedImpl<N> extends GenericKubernetesResourceFluentImpl<NamedExtensionFluent.GenericKubernetesResourceExtensionNested<N>> implements NamedExtensionFluent.GenericKubernetesResourceExtensionNested<N>,Nested<N>{
    GenericKubernetesResourceExtensionNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceExtensionNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endGenericKubernetesResourceExtension() {
      return and();
    }
    
  }
  class EndpointsExtensionNestedImpl<N> extends EndpointsFluentImpl<NamedExtensionFluent.EndpointsExtensionNested<N>> implements NamedExtensionFluent.EndpointsExtensionNested<N>,Nested<N>{
    EndpointsExtensionNestedImpl(Endpoints item) {
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsExtensionNestedImpl() {
      this.builder = new EndpointsBuilder(this);
    }
    EndpointsBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endEndpointsExtension() {
      return and();
    }
    
  }
  class PodExtensionNestedImpl<N> extends PodFluentImpl<NamedExtensionFluent.PodExtensionNested<N>> implements NamedExtensionFluent.PodExtensionNested<N>,Nested<N>{
    PodExtensionNestedImpl(Pod item) {
      this.builder = new PodBuilder(this, item);
    }
    PodExtensionNestedImpl() {
      this.builder = new PodBuilder(this);
    }
    PodBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endPodExtension() {
      return and();
    }
    
  }
  class ConfigMapExtensionNestedImpl<N> extends ConfigMapFluentImpl<NamedExtensionFluent.ConfigMapExtensionNested<N>> implements NamedExtensionFluent.ConfigMapExtensionNested<N>,Nested<N>{
    ConfigMapExtensionNestedImpl(ConfigMap item) {
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapExtensionNestedImpl() {
      this.builder = new ConfigMapBuilder(this);
    }
    ConfigMapBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endConfigMapExtension() {
      return and();
    }
    
  }
  class ComponentStatusExtensionNestedImpl<N> extends ComponentStatusFluentImpl<NamedExtensionFluent.ComponentStatusExtensionNested<N>> implements NamedExtensionFluent.ComponentStatusExtensionNested<N>,Nested<N>{
    ComponentStatusExtensionNestedImpl(ComponentStatus item) {
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusExtensionNestedImpl() {
      this.builder = new ComponentStatusBuilder(this);
    }
    ComponentStatusBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endComponentStatusExtension() {
      return and();
    }
    
  }
  class BindingExtensionNestedImpl<N> extends BindingFluentImpl<NamedExtensionFluent.BindingExtensionNested<N>> implements NamedExtensionFluent.BindingExtensionNested<N>,Nested<N>{
    BindingExtensionNestedImpl(Binding item) {
      this.builder = new BindingBuilder(this, item);
    }
    BindingExtensionNestedImpl() {
      this.builder = new BindingBuilder(this);
    }
    BindingBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endBindingExtension() {
      return and();
    }
    
  }
  class ResourceQuotaExtensionNestedImpl<N> extends ResourceQuotaFluentImpl<NamedExtensionFluent.ResourceQuotaExtensionNested<N>> implements NamedExtensionFluent.ResourceQuotaExtensionNested<N>,Nested<N>{
    ResourceQuotaExtensionNestedImpl(ResourceQuota item) {
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaExtensionNestedImpl() {
      this.builder = new ResourceQuotaBuilder(this);
    }
    ResourceQuotaBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endResourceQuotaExtension() {
      return and();
    }
    
  }
  class SecretExtensionNestedImpl<N> extends SecretFluentImpl<NamedExtensionFluent.SecretExtensionNested<N>> implements NamedExtensionFluent.SecretExtensionNested<N>,Nested<N>{
    SecretExtensionNestedImpl(Secret item) {
      this.builder = new SecretBuilder(this, item);
    }
    SecretExtensionNestedImpl() {
      this.builder = new SecretBuilder(this);
    }
    SecretBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endSecretExtension() {
      return and();
    }
    
  }
  class NodeExtensionNestedImpl<N> extends NodeFluentImpl<NamedExtensionFluent.NodeExtensionNested<N>> implements NamedExtensionFluent.NodeExtensionNested<N>,Nested<N>{
    NodeExtensionNestedImpl(Node item) {
      this.builder = new NodeBuilder(this, item);
    }
    NodeExtensionNestedImpl() {
      this.builder = new NodeBuilder(this);
    }
    NodeBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endNodeExtension() {
      return and();
    }
    
  }
  class ServiceAccountExtensionNestedImpl<N> extends ServiceAccountFluentImpl<NamedExtensionFluent.ServiceAccountExtensionNested<N>> implements NamedExtensionFluent.ServiceAccountExtensionNested<N>,Nested<N>{
    ServiceAccountExtensionNestedImpl(ServiceAccount item) {
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountExtensionNestedImpl() {
      this.builder = new ServiceAccountBuilder(this);
    }
    ServiceAccountBuilder builder;
    public N and() {
      return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
    }
    public N endServiceAccountExtension() {
      return and();
    }
    
  }
  
}