package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPGetActionBuilder extends HTTPGetActionFluentImpl<HTTPGetActionBuilder> implements VisitableBuilder<HTTPGetAction,HTTPGetActionBuilder>{
  public HTTPGetActionBuilder() {
    this(false);
  }
  public HTTPGetActionBuilder(Boolean validationEnabled) {
    this(new HTTPGetAction(), validationEnabled);
  }
  public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPGetAction(), validationEnabled);
  }
  public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent,HTTPGetAction instance) {
    this(fluent, instance, false);
  }
  public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent,HTTPGetAction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHost(instance.getHost()); 
    fluent.withHttpHeaders(instance.getHttpHeaders()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPGetActionBuilder(HTTPGetAction instance) {
    this(instance,false);
  }
  public HTTPGetActionBuilder(HTTPGetAction instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHost(instance.getHost()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPGetActionFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPGetAction build() {
    HTTPGetAction buildable = new HTTPGetAction(fluent.getHost(),fluent.getHttpHeaders(),fluent.getPath(),fluent.getPort(),fluent.getScheme());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}