package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentStatusListBuilder extends ComponentStatusListFluentImpl<ComponentStatusListBuilder> implements VisitableBuilder<ComponentStatusList,ComponentStatusListBuilder>{
  public ComponentStatusListBuilder() {
    this(false);
  }
  public ComponentStatusListBuilder(Boolean validationEnabled) {
    this(new ComponentStatusList(), validationEnabled);
  }
  public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComponentStatusList(), validationEnabled);
  }
  public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent,ComponentStatusList instance) {
    this(fluent, instance, false);
  }
  public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent,ComponentStatusList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ComponentStatusListBuilder(ComponentStatusList instance) {
    this(instance,false);
  }
  public ComponentStatusListBuilder(ComponentStatusList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ComponentStatusListFluent<?> fluent;
  Boolean validationEnabled;
  public ComponentStatusList build() {
    ComponentStatusList buildable = new ComponentStatusList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}