package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CephFSPersistentVolumeSourceFluentImpl<A extends CephFSPersistentVolumeSourceFluent<A>> extends BaseFluent<A> implements CephFSPersistentVolumeSourceFluent<A>{
  public CephFSPersistentVolumeSourceFluentImpl() {
  }
  public CephFSPersistentVolumeSourceFluentImpl(CephFSPersistentVolumeSource instance) {
    this.withMonitors(instance.getMonitors()); 
    this.withPath(instance.getPath()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretFile(instance.getSecretFile()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> monitors = new ArrayList<String>();
  private String path;
  private Boolean readOnly;
  private String secretFile;
  private SecretReferenceBuilder secretRef;
  private String user;
  private Map<String,Object> additionalProperties;
  public A addToMonitors(Integer index,String item) {
    if (this.monitors == null) {this.monitors = new ArrayList<String>();}
    this.monitors.add(index, item);
    return (A)this;
  }
  public A setToMonitors(Integer index,String item) {
    if (this.monitors == null) {this.monitors = new ArrayList<String>();}
    this.monitors.set(index, item); return (A)this;
  }
  public A addToMonitors(java.lang.String... items) {
    if (this.monitors == null) {this.monitors = new ArrayList<String>();}
    for (String item : items) {this.monitors.add(item);} return (A)this;
  }
  public A addAllToMonitors(Collection<String> items) {
    if (this.monitors == null) {this.monitors = new ArrayList<String>();}
    for (String item : items) {this.monitors.add(item);} return (A)this;
  }
  public A removeFromMonitors(java.lang.String... items) {
    for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
  }
  public A removeAllFromMonitors(Collection<String> items) {
    for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
  }
  public List<String> getMonitors() {
    return this.monitors;
  }
  public String getMonitor(Integer index) {
    return this.monitors.get(index);
  }
  public String getFirstMonitor() {
    return this.monitors.get(0);
  }
  public String getLastMonitor() {
    return this.monitors.get(monitors.size() - 1);
  }
  public String getMatchingMonitor(Predicate<String> predicate) {
    for (String item: monitors) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMonitor(Predicate<String> predicate) {
    for (String item: monitors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMonitors(List<String> monitors) {
    if (monitors != null) {this.monitors = new ArrayList(); for (String item : monitors){this.addToMonitors(item);}} else { this.monitors = null;} return (A) this;
  }
  public A withMonitors(java.lang.String... monitors) {
    if (this.monitors != null) {this.monitors.clear();}
    if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (A) this;
  }
  public Boolean hasMonitors() {
    return monitors != null && !monitors.isEmpty();
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public String getSecretFile() {
    return this.secretFile;
  }
  public A withSecretFile(String secretFile) {
    this.secretFile=secretFile; return (A) this;
  }
  public Boolean hasSecretFile() {
    return this.secretFile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public SecretReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(SecretReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new SecretReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(String name,String namespace) {
    return (A)withSecretRef(new SecretReference(name, namespace));
  }
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new CephFSPersistentVolumeSourceFluentImpl.SecretRefNestedImpl();
  }
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
    return new CephFSPersistentVolumeSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new SecretReferenceBuilder().build());
  }
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public String getUser() {
    return this.user;
  }
  public A withUser(String user) {
    this.user=user; return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CephFSPersistentVolumeSourceFluentImpl that = (CephFSPersistentVolumeSourceFluentImpl) o;
    if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (secretFile != null ? !secretFile.equals(that.secretFile) :that.secretFile != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(monitors,  path,  readOnly,  secretFile,  secretRef,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (monitors != null && !monitors.isEmpty()) { sb.append("monitors:"); sb.append(monitors + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (secretFile != null) { sb.append("secretFile:"); sb.append(secretFile + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class SecretRefNestedImpl<N> extends SecretReferenceFluentImpl<CephFSPersistentVolumeSourceFluent.SecretRefNested<N>> implements CephFSPersistentVolumeSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(SecretReference item) {
      this.builder = new SecretReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new SecretReferenceBuilder(this);
    }
    SecretReferenceBuilder builder;
    public N and() {
      return (N) CephFSPersistentVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}