package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIResourceListBuilder extends APIResourceListFluentImpl<APIResourceListBuilder> implements VisitableBuilder<APIResourceList,APIResourceListBuilder>{
  public APIResourceListBuilder() {
    this(false);
  }
  public APIResourceListBuilder(Boolean validationEnabled) {
    this(new APIResourceList(), validationEnabled);
  }
  public APIResourceListBuilder(APIResourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIResourceListBuilder(APIResourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIResourceList(), validationEnabled);
  }
  public APIResourceListBuilder(APIResourceListFluent<?> fluent,APIResourceList instance) {
    this(fluent, instance, false);
  }
  public APIResourceListBuilder(APIResourceListFluent<?> fluent,APIResourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGroupVersion(instance.getGroupVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withResources(instance.getResources()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIResourceListBuilder(APIResourceList instance) {
    this(instance,false);
  }
  public APIResourceListBuilder(APIResourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupVersion(instance.getGroupVersion()); 
    this.withKind(instance.getKind()); 
    this.withResources(instance.getResources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  APIResourceListFluent<?> fluent;
  Boolean validationEnabled;
  public APIResourceList build() {
    APIResourceList buildable = new APIResourceList(fluent.getApiVersion(),fluent.getGroupVersion(),fluent.getKind(),fluent.getResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}