package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PatchOptionsFluentImpl<A extends PatchOptionsFluent<A>> extends BaseFluent<A> implements PatchOptionsFluent<A>{
  public PatchOptionsFluentImpl() {
  }
  public PatchOptionsFluentImpl(PatchOptions instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withFieldManager(instance.getFieldManager()); 
    this.withFieldValidation(instance.getFieldValidation()); 
    this.withForce(instance.getForce()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<String> dryRun = new ArrayList<String>();
  private String fieldManager;
  private String fieldValidation;
  private Boolean force;
  private String kind;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToDryRun(Integer index,String item) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    this.dryRun.add(index, item);
    return (A)this;
  }
  public A setToDryRun(Integer index,String item) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    this.dryRun.set(index, item); return (A)this;
  }
  public A addToDryRun(java.lang.String... items) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    for (String item : items) {this.dryRun.add(item);} return (A)this;
  }
  public A addAllToDryRun(Collection<String> items) {
    if (this.dryRun == null) {this.dryRun = new ArrayList<String>();}
    for (String item : items) {this.dryRun.add(item);} return (A)this;
  }
  public A removeFromDryRun(java.lang.String... items) {
    for (String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
  }
  public A removeAllFromDryRun(Collection<String> items) {
    for (String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
  }
  public List<String> getDryRun() {
    return this.dryRun;
  }
  public String getDryRun(Integer index) {
    return this.dryRun.get(index);
  }
  public String getFirstDryRun() {
    return this.dryRun.get(0);
  }
  public String getLastDryRun() {
    return this.dryRun.get(dryRun.size() - 1);
  }
  public String getMatchingDryRun(Predicate<String> predicate) {
    for (String item: dryRun) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDryRun(Predicate<String> predicate) {
    for (String item: dryRun) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDryRun(List<String> dryRun) {
    if (dryRun != null) {this.dryRun = new ArrayList(); for (String item : dryRun){this.addToDryRun(item);}} else { this.dryRun = null;} return (A) this;
  }
  public A withDryRun(java.lang.String... dryRun) {
    if (this.dryRun != null) {this.dryRun.clear();}
    if (dryRun != null) {for (String item :dryRun){ this.addToDryRun(item);}} return (A) this;
  }
  public Boolean hasDryRun() {
    return dryRun != null && !dryRun.isEmpty();
  }
  public String getFieldManager() {
    return this.fieldManager;
  }
  public A withFieldManager(String fieldManager) {
    this.fieldManager=fieldManager; return (A) this;
  }
  public Boolean hasFieldManager() {
    return this.fieldManager != null;
  }
  public String getFieldValidation() {
    return this.fieldValidation;
  }
  public A withFieldValidation(String fieldValidation) {
    this.fieldValidation=fieldValidation; return (A) this;
  }
  public Boolean hasFieldValidation() {
    return this.fieldValidation != null;
  }
  public Boolean getForce() {
    return this.force;
  }
  public A withForce(Boolean force) {
    this.force=force; return (A) this;
  }
  public Boolean hasForce() {
    return this.force != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PatchOptionsFluentImpl that = (PatchOptionsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (dryRun != null ? !dryRun.equals(that.dryRun) :that.dryRun != null) return false;
    if (fieldManager != null ? !fieldManager.equals(that.fieldManager) :that.fieldManager != null) return false;
    if (fieldValidation != null ? !fieldValidation.equals(that.fieldValidation) :that.fieldValidation != null) return false;
    if (force != null ? !force.equals(that.force) :that.force != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  dryRun,  fieldManager,  fieldValidation,  force,  kind,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (dryRun != null && !dryRun.isEmpty()) { sb.append("dryRun:"); sb.append(dryRun + ","); }
    if (fieldManager != null) { sb.append("fieldManager:"); sb.append(fieldManager + ","); }
    if (fieldValidation != null) { sb.append("fieldValidation:"); sb.append(fieldValidation + ","); }
    if (force != null) { sb.append("force:"); sb.append(force + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withForce() {
    return withForce(true);
  }
  
}