package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LabelSelectorFluentImpl<A extends LabelSelectorFluent<A>> extends BaseFluent<A> implements LabelSelectorFluent<A>{
  public LabelSelectorFluentImpl() {
  }
  public LabelSelectorFluentImpl(LabelSelector instance) {
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withMatchLabels(instance.getMatchLabels()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<LabelSelectorRequirementBuilder> matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
  private Map<String,String> matchLabels;
  private Map<String,Object> additionalProperties;
  public A addToMatchExpressions(Integer index,LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();}
    LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(index >= 0 ? index : _visitables.get("matchExpressions").size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
  }
  public A setToMatchExpressions(Integer index,LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();}
    LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
    if (index < 0 || index >= _visitables.get("matchExpressions").size()) { _visitables.get("matchExpressions").add(builder); } else { _visitables.get("matchExpressions").set(index, builder);}
    if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
     return (A)this;
  }
  public A addToMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();}
    for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
  }
  public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();}
    for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
  }
  public A removeFromMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
    for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatchExpressions(Predicate<LabelSelectorRequirementBuilder> predicate) {
    if (matchExpressions == null) return (A) this;
    final Iterator<LabelSelectorRequirementBuilder> each = matchExpressions.iterator();
    final List visitables = _visitables.get("matchExpressions");
    while (each.hasNext()) {
      LabelSelectorRequirementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchExpressions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LabelSelectorRequirement> getMatchExpressions() {
    return matchExpressions != null ? build(matchExpressions) : null;
  }
  public List<LabelSelectorRequirement> buildMatchExpressions() {
    return matchExpressions != null ? build(matchExpressions) : null;
  }
  public LabelSelectorRequirement buildMatchExpression(Integer index) {
    return this.matchExpressions.get(index).build();
  }
  public LabelSelectorRequirement buildFirstMatchExpression() {
    return this.matchExpressions.get(0).build();
  }
  public LabelSelectorRequirement buildLastMatchExpression() {
    return this.matchExpressions.get(matchExpressions.size() - 1).build();
  }
  public LabelSelectorRequirement buildMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
    for (LabelSelectorRequirementBuilder item: matchExpressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
    for (LabelSelectorRequirementBuilder item: matchExpressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
    if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
    if (matchExpressions != null) {this.matchExpressions = new ArrayList(); for (LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
  }
  public A withMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... matchExpressions) {
    if (this.matchExpressions != null) {this.matchExpressions.clear();}
    if (matchExpressions != null) {for (LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
  }
  public Boolean hasMatchExpressions() {
    return matchExpressions != null && !matchExpressions.isEmpty();
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression() {
    return new LabelSelectorFluentImpl.MatchExpressionsNestedImpl();
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item) {
    return new LabelSelectorFluentImpl.MatchExpressionsNestedImpl(-1, item);
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(Integer index,LabelSelectorRequirement item) {
    return new LabelSelectorFluentImpl.MatchExpressionsNestedImpl(index, item);
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> editMatchExpression(Integer index) {
    if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression() {
    if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
    return setNewMatchExpressionLike(0, buildMatchExpression(0));
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression() {
    int index = matchExpressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchExpressions.size();i++) { 
    if (predicate.test(matchExpressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public A addToMatchLabels(String key,String value) {
    if(this.matchLabels == null && key != null && value != null) { this.matchLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
  }
  public A addToMatchLabels(Map<String,String> map) {
    if(this.matchLabels == null && map != null) { this.matchLabels = new LinkedHashMap(); }
    if(map != null) { this.matchLabels.putAll(map);} return (A)this;
  }
  public A removeFromMatchLabels(String key) {
    if(this.matchLabels == null) { return (A) this; }
    if(key != null && this.matchLabels != null) {this.matchLabels.remove(key);} return (A)this;
  }
  public A removeFromMatchLabels(Map<String,String> map) {
    if(this.matchLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.matchLabels != null){this.matchLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMatchLabels() {
    return this.matchLabels;
  }
  public <K,V>A withMatchLabels(Map<String,String> matchLabels) {
    if (matchLabels == null) { this.matchLabels =  null;} else {this.matchLabels = new LinkedHashMap(matchLabels);} return (A) this;
  }
  public Boolean hasMatchLabels() {
    return this.matchLabels != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LabelSelectorFluentImpl that = (LabelSelectorFluentImpl) o;
    if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
    if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchExpressions,  matchLabels,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchExpressions != null && !matchExpressions.isEmpty()) { sb.append("matchExpressions:"); sb.append(matchExpressions + ","); }
    if (matchLabels != null && !matchLabels.isEmpty()) { sb.append("matchLabels:"); sb.append(matchLabels + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchExpressionsNestedImpl<N> extends LabelSelectorRequirementFluentImpl<LabelSelectorFluent.MatchExpressionsNested<N>> implements LabelSelectorFluent.MatchExpressionsNested<N>,Nested<N>{
    MatchExpressionsNestedImpl(Integer index,LabelSelectorRequirement item) {
      this.index = index;
      this.builder = new LabelSelectorRequirementBuilder(this, item);
    }
    MatchExpressionsNestedImpl() {
      this.index = -1;
      this.builder = new LabelSelectorRequirementBuilder(this);
    }
    LabelSelectorRequirementBuilder builder;
    Integer index;
    public N and() {
      return (N) LabelSelectorFluentImpl.this.setToMatchExpressions(index,builder.build());
    }
    public N endMatchExpression() {
      return and();
    }
    
  }
  
}