package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIPersistentVolumeSourceBuilder extends CSIPersistentVolumeSourceFluentImpl<CSIPersistentVolumeSourceBuilder> implements VisitableBuilder<CSIPersistentVolumeSource,CSIPersistentVolumeSourceBuilder>{
  public CSIPersistentVolumeSourceBuilder() {
    this(false);
  }
  public CSIPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CSIPersistentVolumeSource(), validationEnabled);
  }
  public CSIPersistentVolumeSourceBuilder(CSIPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIPersistentVolumeSourceBuilder(CSIPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIPersistentVolumeSource(), validationEnabled);
  }
  public CSIPersistentVolumeSourceBuilder(CSIPersistentVolumeSourceFluent<?> fluent,CSIPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CSIPersistentVolumeSourceBuilder(CSIPersistentVolumeSourceFluent<?> fluent,CSIPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withControllerExpandSecretRef(instance.getControllerExpandSecretRef()); 
    fluent.withControllerPublishSecretRef(instance.getControllerPublishSecretRef()); 
    fluent.withDriver(instance.getDriver()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    fluent.withNodeStageSecretRef(instance.getNodeStageSecretRef()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withVolumeAttributes(instance.getVolumeAttributes()); 
    fluent.withVolumeHandle(instance.getVolumeHandle()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSIPersistentVolumeSourceBuilder(CSIPersistentVolumeSource instance) {
    this(instance,false);
  }
  public CSIPersistentVolumeSourceBuilder(CSIPersistentVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef()); 
    this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef()); 
    this.withDriver(instance.getDriver()); 
    this.withFsType(instance.getFsType()); 
    this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
    this.withNodeStageSecretRef(instance.getNodeStageSecretRef()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withVolumeAttributes(instance.getVolumeAttributes()); 
    this.withVolumeHandle(instance.getVolumeHandle()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSIPersistentVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CSIPersistentVolumeSource build() {
    CSIPersistentVolumeSource buildable = new CSIPersistentVolumeSource(fluent.getControllerExpandSecretRef(),fluent.getControllerPublishSecretRef(),fluent.getDriver(),fluent.getFsType(),fluent.getNodePublishSecretRef(),fluent.getNodeStageSecretRef(),fluent.getReadOnly(),fluent.getVolumeAttributes(),fluent.getVolumeHandle());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}