package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>> extends BaseFluent<A> implements BaseKubernetesListFluent<A>{
  public BaseKubernetesListFluentImpl() {
  }
  public BaseKubernetesListFluentImpl(BaseKubernetesList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<VisitableBuilder<? extends HasMetadata,?>> items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
  private String kind;
  private ListMetaBuilder metadata;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("items").add(builder);this.items.add(builder); return (A)this;
  }
  public A addToItems(Integer index,VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("items").add(index, builder);this.items.add(index, builder); return (A)this;
  }
  public A addToItems(Integer index,HasMetadata item) {
    if (item instanceof LimitRange){addToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems(index, (APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof Service){addToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){addToEventItems(index, (Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems(index, (GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){addToPodItems(index, (Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems(index, (ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems(index, (Secret)item);}
 else if (item instanceof Node){addToNodeItems(index, (Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems(index, (ServiceAccount)item);}

    return (A)this;
  }
  public A setToItems(Integer index,HasMetadata item) {
    if (item instanceof LimitRange){setToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof APIService){setToAPIServiceItems(index, (APIService)item);}
 else if (item instanceof Namespace){setToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof Service){setToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){setToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof PodTemplate){setToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){setToEventItems(index, (Event)item);}
 else if (item instanceof PersistentVolume){setToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){setToGenericKubernetesResourceItems(index, (GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){setToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){setToPodItems(index, (Pod)item);}
 else if (item instanceof ConfigMap){setToConfigMapItems(index, (ConfigMap)item);}
 else if (item instanceof ComponentStatus){setToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Binding){setToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){setToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){setToSecretItems(index, (Secret)item);}
 else if (item instanceof Node){setToNodeItems(index, (Node)item);}
 else if (item instanceof ServiceAccount){setToServiceAccountItems(index, (ServiceAccount)item);}

    return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
     if (items != null && items.length > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { 
    if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
    } return (A)this;
  }
  public A addAllToItems(Collection<HasMetadata> items) {
     if (items != null && items.size() > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { 
    if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
    } return (A)this;
  }
  public A removeFromItems(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("items").remove(builder);this.items.remove(builder); return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){removeFromAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromItems(Collection<HasMetadata> items) {
    for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){removeFromAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HasMetadata> getItems() {
    return build(items);
  }
  public List<HasMetadata> buildItems() {
    return build(items);
  }
  public HasMetadata buildItem(Integer index) {
    return this.items.get(index).build();
  }
  public HasMetadata buildFirstItem() {
    return this.items.get(0).build();
  }
  public HasMetadata buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public HasMetadata buildMatchingItem(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<HasMetadata> items) {
    if (items != null) {this.items = new ArrayList(); for (HasMetadata item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public A addToLimitRangeItems(Integer index,LimitRange item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToLimitRangeItems(Integer index,LimitRange item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    LimitRangeBuilder builder = new LimitRangeBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToLimitRangeItems(Collection<LimitRange> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromLimitRangeItems(Collection<LimitRange> items) {
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLimitRangeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem() {
    return new BaseKubernetesListFluentImpl.LimitRangeItemsNestedImpl();
  }
  public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item) {
    return new BaseKubernetesListFluentImpl.LimitRangeItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(Integer index,LimitRange item) {
    return new BaseKubernetesListFluentImpl.LimitRangeItemsNestedImpl(index, item);
  }
  public A addToAPIServiceItems(Integer index,APIService item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToAPIServiceItems(Integer index,APIService item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    APIServiceBuilder builder = new APIServiceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToAPIServiceItems(Collection<APIService> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items) {
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromAPIServiceItems(Collection<APIService> items) {
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAPIServiceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItem() {
    return new BaseKubernetesListFluentImpl.APIServiceItemsNestedImpl();
  }
  public BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItemLike(APIService item) {
    return new BaseKubernetesListFluentImpl.APIServiceItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.APIServiceItemsNested<A> setNewAPIServiceItemLike(Integer index,APIService item) {
    return new BaseKubernetesListFluentImpl.APIServiceItemsNestedImpl(index, item);
  }
  public A addToNamespaceItems(Integer index,Namespace item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToNamespaceItems(Integer index,Namespace item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NamespaceBuilder builder = new NamespaceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToNamespaceItems(Collection<Namespace> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items) {
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromNamespaceItems(Collection<Namespace> items) {
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNamespaceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem() {
    return new BaseKubernetesListFluentImpl.NamespaceItemsNestedImpl();
  }
  public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item) {
    return new BaseKubernetesListFluentImpl.NamespaceItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(Integer index,Namespace item) {
    return new BaseKubernetesListFluentImpl.NamespaceItemsNestedImpl(index, item);
  }
  public A addToServiceItems(Integer index,Service item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToServiceItems(Integer index,Service item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceBuilder builder = new ServiceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToServiceItems(io.fabric8.kubernetes.api.model.Service... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToServiceItems(Collection<Service> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromServiceItems(io.fabric8.kubernetes.api.model.Service... items) {
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceItems(Collection<Service> items) {
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem() {
    return new BaseKubernetesListFluentImpl.ServiceItemsNestedImpl();
  }
  public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item) {
    return new BaseKubernetesListFluentImpl.ServiceItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(Integer index,Service item) {
    return new BaseKubernetesListFluentImpl.ServiceItemsNestedImpl(index, item);
  }
  public A addToReplicationControllerItems(Integer index,ReplicationController item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToReplicationControllerItems(Integer index,ReplicationController item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToReplicationControllerItems(Collection<ReplicationController> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items) {
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromReplicationControllerItems(Collection<ReplicationController> items) {
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReplicationControllerItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem() {
    return new BaseKubernetesListFluentImpl.ReplicationControllerItemsNestedImpl();
  }
  public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item) {
    return new BaseKubernetesListFluentImpl.ReplicationControllerItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(Integer index,ReplicationController item) {
    return new BaseKubernetesListFluentImpl.ReplicationControllerItemsNestedImpl(index, item);
  }
  public A addToPodTemplateItems(Integer index,PodTemplate item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPodTemplateItems(Integer index,PodTemplate item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodTemplateBuilder builder = new PodTemplateBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPodTemplateItems(Collection<PodTemplate> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items) {
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodTemplateItems(Collection<PodTemplate> items) {
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodTemplateItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem() {
    return new BaseKubernetesListFluentImpl.PodTemplateItemsNestedImpl();
  }
  public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item) {
    return new BaseKubernetesListFluentImpl.PodTemplateItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(Integer index,PodTemplate item) {
    return new BaseKubernetesListFluentImpl.PodTemplateItemsNestedImpl(index, item);
  }
  public A addToEventItems(Integer index,Event item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToEventItems(Integer index,Event item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EventBuilder builder = new EventBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToEventItems(io.fabric8.kubernetes.api.model.Event... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToEventItems(Collection<Event> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromEventItems(io.fabric8.kubernetes.api.model.Event... items) {
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromEventItems(Collection<Event> items) {
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEventItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem() {
    return new BaseKubernetesListFluentImpl.EventItemsNestedImpl();
  }
  public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(Event item) {
    return new BaseKubernetesListFluentImpl.EventItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.EventItemsNested<A> setNewEventItemLike(Integer index,Event item) {
    return new BaseKubernetesListFluentImpl.EventItemsNestedImpl(index, item);
  }
  public A addToPersistentVolumeItems(Integer index,PersistentVolume item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPersistentVolumeItems(Integer index,PersistentVolume item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeItems(Collection<PersistentVolume> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items) {
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeItems(Collection<PersistentVolume> items) {
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem() {
    return new BaseKubernetesListFluentImpl.PersistentVolumeItemsNestedImpl();
  }
  public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item) {
    return new BaseKubernetesListFluentImpl.PersistentVolumeItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(Integer index,PersistentVolume item) {
    return new BaseKubernetesListFluentImpl.PersistentVolumeItemsNestedImpl(index, item);
  }
  public A addToPersistentVolumeClaimItems(Integer index,PersistentVolumeClaim item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPersistentVolumeClaimItems(Integer index,PersistentVolumeClaim item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeClaimItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem() {
    return new BaseKubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl();
  }
  public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item) {
    return new BaseKubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(Integer index,PersistentVolumeClaim item) {
    return new BaseKubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl(index, item);
  }
  public A addToGenericKubernetesResourceItems(Integer index,GenericKubernetesResource item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToGenericKubernetesResourceItems(Integer index,GenericKubernetesResource item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToGenericKubernetesResourceItems(Collection<GenericKubernetesResource> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenericKubernetesResourceItems(Collection<GenericKubernetesResource> items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenericKubernetesResourceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItem() {
    return new BaseKubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl();
  }
  public BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItemLike(GenericKubernetesResource item) {
    return new BaseKubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<A> setNewGenericKubernetesResourceItemLike(Integer index,GenericKubernetesResource item) {
    return new BaseKubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl(index, item);
  }
  public A addToEndpointsItems(Integer index,Endpoints item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToEndpointsItems(Integer index,Endpoints item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EndpointsBuilder builder = new EndpointsBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToEndpointsItems(Collection<Endpoints> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpointsItems(Collection<Endpoints> items) {
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpointsItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem() {
    return new BaseKubernetesListFluentImpl.EndpointsItemsNestedImpl();
  }
  public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item) {
    return new BaseKubernetesListFluentImpl.EndpointsItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(Integer index,Endpoints item) {
    return new BaseKubernetesListFluentImpl.EndpointsItemsNestedImpl(index, item);
  }
  public A addToPodItems(Integer index,Pod item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToPodItems(Integer index,Pod item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodBuilder builder = new PodBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToPodItems(io.fabric8.kubernetes.api.model.Pod... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPodItems(Collection<Pod> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPodItems(io.fabric8.kubernetes.api.model.Pod... items) {
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodItems(Collection<Pod> items) {
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem() {
    return new BaseKubernetesListFluentImpl.PodItemsNestedImpl();
  }
  public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item) {
    return new BaseKubernetesListFluentImpl.PodItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(Integer index,Pod item) {
    return new BaseKubernetesListFluentImpl.PodItemsNestedImpl(index, item);
  }
  public A addToConfigMapItems(Integer index,ConfigMap item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToConfigMapItems(Integer index,ConfigMap item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ConfigMapBuilder builder = new ConfigMapBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToConfigMapItems(Collection<ConfigMap> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items) {
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfigMapItems(Collection<ConfigMap> items) {
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfigMapItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem() {
    return new BaseKubernetesListFluentImpl.ConfigMapItemsNestedImpl();
  }
  public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item) {
    return new BaseKubernetesListFluentImpl.ConfigMapItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(Integer index,ConfigMap item) {
    return new BaseKubernetesListFluentImpl.ConfigMapItemsNestedImpl(index, item);
  }
  public A addToComponentStatusItems(Integer index,ComponentStatus item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToComponentStatusItems(Integer index,ComponentStatus item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ComponentStatusBuilder builder = new ComponentStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToComponentStatusItems(Collection<ComponentStatus> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items) {
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromComponentStatusItems(Collection<ComponentStatus> items) {
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromComponentStatusItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem() {
    return new BaseKubernetesListFluentImpl.ComponentStatusItemsNestedImpl();
  }
  public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item) {
    return new BaseKubernetesListFluentImpl.ComponentStatusItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(Integer index,ComponentStatus item) {
    return new BaseKubernetesListFluentImpl.ComponentStatusItemsNestedImpl(index, item);
  }
  public A addToBindingItems(Integer index,Binding item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToBindingItems(Integer index,Binding item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BindingBuilder builder = new BindingBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToBindingItems(io.fabric8.kubernetes.api.model.Binding... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToBindingItems(Collection<Binding> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromBindingItems(io.fabric8.kubernetes.api.model.Binding... items) {
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromBindingItems(Collection<Binding> items) {
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBindingItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem() {
    return new BaseKubernetesListFluentImpl.BindingItemsNestedImpl();
  }
  public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item) {
    return new BaseKubernetesListFluentImpl.BindingItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(Integer index,Binding item) {
    return new BaseKubernetesListFluentImpl.BindingItemsNestedImpl(index, item);
  }
  public A addToResourceQuotaItems(Integer index,ResourceQuota item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToResourceQuotaItems(Integer index,ResourceQuota item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToResourceQuotaItems(Collection<ResourceQuota> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceQuotaItems(Collection<ResourceQuota> items) {
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceQuotaItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem() {
    return new BaseKubernetesListFluentImpl.ResourceQuotaItemsNestedImpl();
  }
  public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item) {
    return new BaseKubernetesListFluentImpl.ResourceQuotaItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(Integer index,ResourceQuota item) {
    return new BaseKubernetesListFluentImpl.ResourceQuotaItemsNestedImpl(index, item);
  }
  public A addToSecretItems(Integer index,Secret item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToSecretItems(Integer index,Secret item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    SecretBuilder builder = new SecretBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToSecretItems(io.fabric8.kubernetes.api.model.Secret... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToSecretItems(Collection<Secret> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromSecretItems(io.fabric8.kubernetes.api.model.Secret... items) {
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecretItems(Collection<Secret> items) {
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecretItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem() {
    return new BaseKubernetesListFluentImpl.SecretItemsNestedImpl();
  }
  public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item) {
    return new BaseKubernetesListFluentImpl.SecretItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(Integer index,Secret item) {
    return new BaseKubernetesListFluentImpl.SecretItemsNestedImpl(index, item);
  }
  public A addToNodeItems(Integer index,Node item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToNodeItems(Integer index,Node item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NodeBuilder builder = new NodeBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToNodeItems(io.fabric8.kubernetes.api.model.Node... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToNodeItems(Collection<Node> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromNodeItems(io.fabric8.kubernetes.api.model.Node... items) {
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromNodeItems(Collection<Node> items) {
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNodeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem() {
    return new BaseKubernetesListFluentImpl.NodeItemsNestedImpl();
  }
  public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item) {
    return new BaseKubernetesListFluentImpl.NodeItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(Integer index,Node item) {
    return new BaseKubernetesListFluentImpl.NodeItemsNestedImpl(index, item);
  }
  public A addToServiceAccountItems(Integer index,ServiceAccount item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToServiceAccountItems(Integer index,ServiceAccount item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToServiceAccountItems(Collection<ServiceAccount> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items) {
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceAccountItems(Collection<ServiceAccount> items) {
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceAccountItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem() {
    return new BaseKubernetesListFluentImpl.ServiceAccountItemsNestedImpl();
  }
  public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item) {
    return new BaseKubernetesListFluentImpl.ServiceAccountItemsNestedImpl(-1, item);
  }
  public BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(Integer index,ServiceAccount item) {
    return new BaseKubernetesListFluentImpl.ServiceAccountItemsNestedImpl(index, item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ListMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata() {
    return new BaseKubernetesListFluentImpl.MetadataNestedImpl();
  }
  public BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
    return new BaseKubernetesListFluentImpl.MetadataNestedImpl(item);
  }
  public BaseKubernetesListFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
  }
  public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<BaseKubernetesListFluent.LimitRangeItemsNested<N>> implements BaseKubernetesListFluent.LimitRangeItemsNested<N>,Nested<N>{
    LimitRangeItemsNestedImpl(Integer index,LimitRange item) {
      this.index = index;
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeItemsNestedImpl() {
      this.index = -1;
      this.builder = new LimitRangeBuilder(this);
    }
    LimitRangeBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endLimitRangeItem() {
      return and();
    }
    
  }
  class APIServiceItemsNestedImpl<N> extends APIServiceFluentImpl<BaseKubernetesListFluent.APIServiceItemsNested<N>> implements BaseKubernetesListFluent.APIServiceItemsNested<N>,Nested<N>{
    APIServiceItemsNestedImpl(Integer index,APIService item) {
      this.index = index;
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceItemsNestedImpl() {
      this.index = -1;
      this.builder = new APIServiceBuilder(this);
    }
    APIServiceBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endAPIServiceItem() {
      return and();
    }
    
  }
  class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<BaseKubernetesListFluent.NamespaceItemsNested<N>> implements BaseKubernetesListFluent.NamespaceItemsNested<N>,Nested<N>{
    NamespaceItemsNestedImpl(Integer index,Namespace item) {
      this.index = index;
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceItemsNestedImpl() {
      this.index = -1;
      this.builder = new NamespaceBuilder(this);
    }
    NamespaceBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endNamespaceItem() {
      return and();
    }
    
  }
  class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<BaseKubernetesListFluent.ServiceItemsNested<N>> implements BaseKubernetesListFluent.ServiceItemsNested<N>,Nested<N>{
    ServiceItemsNestedImpl(Integer index,Service item) {
      this.index = index;
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceItemsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceBuilder(this);
    }
    ServiceBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endServiceItem() {
      return and();
    }
    
  }
  class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>> implements BaseKubernetesListFluent.ReplicationControllerItemsNested<N>,Nested<N>{
    ReplicationControllerItemsNestedImpl(Integer index,ReplicationController item) {
      this.index = index;
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerItemsNestedImpl() {
      this.index = -1;
      this.builder = new ReplicationControllerBuilder(this);
    }
    ReplicationControllerBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endReplicationControllerItem() {
      return and();
    }
    
  }
  class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<BaseKubernetesListFluent.PodTemplateItemsNested<N>> implements BaseKubernetesListFluent.PodTemplateItemsNested<N>,Nested<N>{
    PodTemplateItemsNestedImpl(Integer index,PodTemplate item) {
      this.index = index;
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateItemsNestedImpl() {
      this.index = -1;
      this.builder = new PodTemplateBuilder(this);
    }
    PodTemplateBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPodTemplateItem() {
      return and();
    }
    
  }
  class EventItemsNestedImpl<N> extends EventFluentImpl<BaseKubernetesListFluent.EventItemsNested<N>> implements BaseKubernetesListFluent.EventItemsNested<N>,Nested<N>{
    EventItemsNestedImpl(Integer index,Event item) {
      this.index = index;
      this.builder = new EventBuilder(this, item);
    }
    EventItemsNestedImpl() {
      this.index = -1;
      this.builder = new EventBuilder(this);
    }
    EventBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endEventItem() {
      return and();
    }
    
  }
  class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeItemsNested<N>,Nested<N>{
    PersistentVolumeItemsNestedImpl(Integer index,PersistentVolume item) {
      this.index = index;
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeItemsNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeBuilder(this);
    }
    PersistentVolumeBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPersistentVolumeItem() {
      return and();
    }
    
  }
  class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>,Nested<N>{
    PersistentVolumeClaimItemsNestedImpl(Integer index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimItemsNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPersistentVolumeClaimItem() {
      return and();
    }
    
  }
  class GenericKubernetesResourceItemsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<N>> implements BaseKubernetesListFluent.GenericKubernetesResourceItemsNested<N>,Nested<N>{
    GenericKubernetesResourceItemsNestedImpl(Integer index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceItemsNestedImpl() {
      this.index = -1;
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endGenericKubernetesResourceItem() {
      return and();
    }
    
  }
  class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<BaseKubernetesListFluent.EndpointsItemsNested<N>> implements BaseKubernetesListFluent.EndpointsItemsNested<N>,Nested<N>{
    EndpointsItemsNestedImpl(Integer index,Endpoints item) {
      this.index = index;
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsItemsNestedImpl() {
      this.index = -1;
      this.builder = new EndpointsBuilder(this);
    }
    EndpointsBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endEndpointsItem() {
      return and();
    }
    
  }
  class PodItemsNestedImpl<N> extends PodFluentImpl<BaseKubernetesListFluent.PodItemsNested<N>> implements BaseKubernetesListFluent.PodItemsNested<N>,Nested<N>{
    PodItemsNestedImpl(Integer index,Pod item) {
      this.index = index;
      this.builder = new PodBuilder(this, item);
    }
    PodItemsNestedImpl() {
      this.index = -1;
      this.builder = new PodBuilder(this);
    }
    PodBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPodItem() {
      return and();
    }
    
  }
  class ConfigMapItemsNestedImpl<N> extends ConfigMapFluentImpl<BaseKubernetesListFluent.ConfigMapItemsNested<N>> implements BaseKubernetesListFluent.ConfigMapItemsNested<N>,Nested<N>{
    ConfigMapItemsNestedImpl(Integer index,ConfigMap item) {
      this.index = index;
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapItemsNestedImpl() {
      this.index = -1;
      this.builder = new ConfigMapBuilder(this);
    }
    ConfigMapBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endConfigMapItem() {
      return and();
    }
    
  }
  class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<BaseKubernetesListFluent.ComponentStatusItemsNested<N>> implements BaseKubernetesListFluent.ComponentStatusItemsNested<N>,Nested<N>{
    ComponentStatusItemsNestedImpl(Integer index,ComponentStatus item) {
      this.index = index;
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusItemsNestedImpl() {
      this.index = -1;
      this.builder = new ComponentStatusBuilder(this);
    }
    ComponentStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endComponentStatusItem() {
      return and();
    }
    
  }
  class BindingItemsNestedImpl<N> extends BindingFluentImpl<BaseKubernetesListFluent.BindingItemsNested<N>> implements BaseKubernetesListFluent.BindingItemsNested<N>,Nested<N>{
    BindingItemsNestedImpl(Integer index,Binding item) {
      this.index = index;
      this.builder = new BindingBuilder(this, item);
    }
    BindingItemsNestedImpl() {
      this.index = -1;
      this.builder = new BindingBuilder(this);
    }
    BindingBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endBindingItem() {
      return and();
    }
    
  }
  class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>> implements BaseKubernetesListFluent.ResourceQuotaItemsNested<N>,Nested<N>{
    ResourceQuotaItemsNestedImpl(Integer index,ResourceQuota item) {
      this.index = index;
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaItemsNestedImpl() {
      this.index = -1;
      this.builder = new ResourceQuotaBuilder(this);
    }
    ResourceQuotaBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endResourceQuotaItem() {
      return and();
    }
    
  }
  class SecretItemsNestedImpl<N> extends SecretFluentImpl<BaseKubernetesListFluent.SecretItemsNested<N>> implements BaseKubernetesListFluent.SecretItemsNested<N>,Nested<N>{
    SecretItemsNestedImpl(Integer index,Secret item) {
      this.index = index;
      this.builder = new SecretBuilder(this, item);
    }
    SecretItemsNestedImpl() {
      this.index = -1;
      this.builder = new SecretBuilder(this);
    }
    SecretBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endSecretItem() {
      return and();
    }
    
  }
  class NodeItemsNestedImpl<N> extends NodeFluentImpl<BaseKubernetesListFluent.NodeItemsNested<N>> implements BaseKubernetesListFluent.NodeItemsNested<N>,Nested<N>{
    NodeItemsNestedImpl(Integer index,Node item) {
      this.index = index;
      this.builder = new NodeBuilder(this, item);
    }
    NodeItemsNestedImpl() {
      this.index = -1;
      this.builder = new NodeBuilder(this);
    }
    NodeBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endNodeItem() {
      return and();
    }
    
  }
  class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<BaseKubernetesListFluent.ServiceAccountItemsNested<N>> implements BaseKubernetesListFluent.ServiceAccountItemsNested<N>,Nested<N>{
    ServiceAccountItemsNestedImpl(Integer index,ServiceAccount item) {
      this.index = index;
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountItemsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceAccountBuilder(this);
    }
    ServiceAccountBuilder builder;
    Integer index;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endServiceAccountItem() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ListMetaFluentImpl<BaseKubernetesListFluent.MetadataNested<N>> implements BaseKubernetesListFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ListMetaBuilder(this);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) BaseKubernetesListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}