package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSecurityContextFluentImpl<A extends PodSecurityContextFluent<A>> extends BaseFluent<A> implements PodSecurityContextFluent<A>{
  public PodSecurityContextFluentImpl() {
  }
  public PodSecurityContextFluentImpl(PodSecurityContext instance) {
    this.withFsGroup(instance.getFsGroup()); 
    this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    this.withSeccompProfile(instance.getSeccompProfile()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withSysctls(instance.getSysctls()); 
    this.withWindowsOptions(instance.getWindowsOptions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Long fsGroup;
  private String fsGroupChangePolicy;
  private Long runAsGroup;
  private Boolean runAsNonRoot;
  private Long runAsUser;
  private SELinuxOptionsBuilder seLinuxOptions;
  private SeccompProfileBuilder seccompProfile;
  private List<Long> supplementalGroups = new ArrayList<Long>();
  private ArrayList<SysctlBuilder> sysctls = new ArrayList<SysctlBuilder>();
  private WindowsSecurityContextOptionsBuilder windowsOptions;
  private Map<String,Object> additionalProperties;
  public Long getFsGroup() {
    return this.fsGroup;
  }
  public A withFsGroup(Long fsGroup) {
    this.fsGroup=fsGroup; return (A) this;
  }
  public Boolean hasFsGroup() {
    return this.fsGroup != null;
  }
  public String getFsGroupChangePolicy() {
    return this.fsGroupChangePolicy;
  }
  public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
    this.fsGroupChangePolicy=fsGroupChangePolicy; return (A) this;
  }
  public Boolean hasFsGroupChangePolicy() {
    return this.fsGroupChangePolicy != null;
  }
  public Long getRunAsGroup() {
    return this.runAsGroup;
  }
  public A withRunAsGroup(Long runAsGroup) {
    this.runAsGroup=runAsGroup; return (A) this;
  }
  public Boolean hasRunAsGroup() {
    return this.runAsGroup != null;
  }
  public Boolean getRunAsNonRoot() {
    return this.runAsNonRoot;
  }
  public A withRunAsNonRoot(Boolean runAsNonRoot) {
    this.runAsNonRoot=runAsNonRoot; return (A) this;
  }
  public Boolean hasRunAsNonRoot() {
    return this.runAsNonRoot != null;
  }
  public Long getRunAsUser() {
    return this.runAsUser;
  }
  public A withRunAsUser(Long runAsUser) {
    this.runAsUser=runAsUser; return (A) this;
  }
  public Boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSeLinuxOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxOptions getSeLinuxOptions() {
    return this.seLinuxOptions!=null ?this.seLinuxOptions.build():null;
  }
  public SELinuxOptions buildSeLinuxOptions() {
    return this.seLinuxOptions!=null ?this.seLinuxOptions.build():null;
  }
  public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} else { this.seLinuxOptions = null; _visitables.get("seLinuxOptions").remove(this.seLinuxOptions); } return (A) this;
  }
  public Boolean hasSeLinuxOptions() {
    return this.seLinuxOptions != null;
  }
  public A withNewSeLinuxOptions(String level,String role,String type,String user) {
    return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
  }
  public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
    return new PodSecurityContextFluentImpl.SeLinuxOptionsNestedImpl();
  }
  public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
    return new PodSecurityContextFluentImpl.SeLinuxOptionsNestedImpl(item);
  }
  public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(getSeLinuxOptions());
  }
  public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new SELinuxOptionsBuilder().build());
  }
  public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
    return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSeccompProfile instead.
   * @return The buildable object.
   */
  @Deprecated
  public SeccompProfile getSeccompProfile() {
    return this.seccompProfile!=null ?this.seccompProfile.build():null;
  }
  public SeccompProfile buildSeccompProfile() {
    return this.seccompProfile!=null ?this.seccompProfile.build():null;
  }
  public A withSeccompProfile(SeccompProfile seccompProfile) {
    _visitables.get("seccompProfile").remove(this.seccompProfile);
    if (seccompProfile!=null){ this.seccompProfile= new SeccompProfileBuilder(seccompProfile); _visitables.get("seccompProfile").add(this.seccompProfile);} else { this.seccompProfile = null; _visitables.get("seccompProfile").remove(this.seccompProfile); } return (A) this;
  }
  public Boolean hasSeccompProfile() {
    return this.seccompProfile != null;
  }
  public A withNewSeccompProfile(String localhostProfile,String type) {
    return (A)withSeccompProfile(new SeccompProfile(localhostProfile, type));
  }
  public PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
    return new PodSecurityContextFluentImpl.SeccompProfileNestedImpl();
  }
  public PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
    return new PodSecurityContextFluentImpl.SeccompProfileNestedImpl(item);
  }
  public PodSecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
    return withNewSeccompProfileLike(getSeccompProfile());
  }
  public PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
    return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): new SeccompProfileBuilder().build());
  }
  public PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
    return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): item);
  }
  public A addToSupplementalGroups(Integer index,Long item) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    this.supplementalGroups.add(index, item);
    return (A)this;
  }
  public A setToSupplementalGroups(Integer index,Long item) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    this.supplementalGroups.set(index, item); return (A)this;
  }
  public A addToSupplementalGroups(java.lang.Long... items) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
  }
  public A addAllToSupplementalGroups(Collection<Long> items) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
  }
  public A removeFromSupplementalGroups(java.lang.Long... items) {
    for (Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromSupplementalGroups(Collection<Long> items) {
    for (Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
  }
  public List<Long> getSupplementalGroups() {
    return this.supplementalGroups;
  }
  public Long getSupplementalGroup(Integer index) {
    return this.supplementalGroups.get(index);
  }
  public Long getFirstSupplementalGroup() {
    return this.supplementalGroups.get(0);
  }
  public Long getLastSupplementalGroup() {
    return this.supplementalGroups.get(supplementalGroups.size() - 1);
  }
  public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
    for (Long item: supplementalGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
    for (Long item: supplementalGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSupplementalGroups(List<Long> supplementalGroups) {
    if (supplementalGroups != null) {this.supplementalGroups = new ArrayList(); for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} else { this.supplementalGroups = null;} return (A) this;
  }
  public A withSupplementalGroups(java.lang.Long... supplementalGroups) {
    if (this.supplementalGroups != null) {this.supplementalGroups.clear();}
    if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
  }
  public Boolean hasSupplementalGroups() {
    return supplementalGroups != null && !supplementalGroups.isEmpty();
  }
  public A addToSysctls(Integer index,Sysctl item) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").add(index >= 0 ? index : _visitables.get("sysctls").size(), builder);this.sysctls.add(index >= 0 ? index : sysctls.size(), builder); return (A)this;
  }
  public A setToSysctls(Integer index,Sysctl item) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    SysctlBuilder builder = new SysctlBuilder(item);
    if (index < 0 || index >= _visitables.get("sysctls").size()) { _visitables.get("sysctls").add(builder); } else { _visitables.get("sysctls").set(index, builder);}
    if (index < 0 || index >= sysctls.size()) { sysctls.add(builder); } else { sysctls.set(index, builder);}
     return (A)this;
  }
  public A addToSysctls(io.fabric8.kubernetes.api.model.Sysctl... items) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
  }
  public A addAllToSysctls(Collection<Sysctl> items) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
  }
  public A removeFromSysctls(io.fabric8.kubernetes.api.model.Sysctl... items) {
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").remove(builder);if (this.sysctls != null) {this.sysctls.remove(builder);}} return (A)this;
  }
  public A removeAllFromSysctls(Collection<Sysctl> items) {
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").remove(builder);if (this.sysctls != null) {this.sysctls.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSysctls(Predicate<SysctlBuilder> predicate) {
    if (sysctls == null) return (A) this;
    final Iterator<SysctlBuilder> each = sysctls.iterator();
    final List visitables = _visitables.get("sysctls");
    while (each.hasNext()) {
      SysctlBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSysctls instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Sysctl> getSysctls() {
    return sysctls != null ? build(sysctls) : null;
  }
  public List<Sysctl> buildSysctls() {
    return sysctls != null ? build(sysctls) : null;
  }
  public Sysctl buildSysctl(Integer index) {
    return this.sysctls.get(index).build();
  }
  public Sysctl buildFirstSysctl() {
    return this.sysctls.get(0).build();
  }
  public Sysctl buildLastSysctl() {
    return this.sysctls.get(sysctls.size() - 1).build();
  }
  public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate) {
    for (SysctlBuilder item: sysctls) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSysctl(Predicate<SysctlBuilder> predicate) {
    for (SysctlBuilder item: sysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSysctls(List<Sysctl> sysctls) {
    if (this.sysctls != null) { _visitables.get("sysctls").removeAll(this.sysctls);}
    if (sysctls != null) {this.sysctls = new ArrayList(); for (Sysctl item : sysctls){this.addToSysctls(item);}} else { this.sysctls = null;} return (A) this;
  }
  public A withSysctls(io.fabric8.kubernetes.api.model.Sysctl... sysctls) {
    if (this.sysctls != null) {this.sysctls.clear();}
    if (sysctls != null) {for (Sysctl item :sysctls){ this.addToSysctls(item);}} return (A) this;
  }
  public Boolean hasSysctls() {
    return sysctls != null && !sysctls.isEmpty();
  }
  public A addNewSysctl(String name,String value) {
    return (A)addToSysctls(new Sysctl(name, value));
  }
  public PodSecurityContextFluent.SysctlsNested<A> addNewSysctl() {
    return new PodSecurityContextFluentImpl.SysctlsNestedImpl();
  }
  public PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(Sysctl item) {
    return new PodSecurityContextFluentImpl.SysctlsNestedImpl(-1, item);
  }
  public PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(Integer index,Sysctl item) {
    return new PodSecurityContextFluentImpl.SysctlsNestedImpl(index, item);
  }
  public PodSecurityContextFluent.SysctlsNested<A> editSysctl(Integer index) {
    if (sysctls.size() <= index) throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl() {
    if (sysctls.size() == 0) throw new RuntimeException("Can't edit first sysctls. The list is empty.");
    return setNewSysctlLike(0, buildSysctl(0));
  }
  public PodSecurityContextFluent.SysctlsNested<A> editLastSysctl() {
    int index = sysctls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sysctls. The list is empty.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sysctls.size();i++) { 
    if (predicate.test(sysctls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sysctls. No match found.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  
  /**
   * This method has been deprecated, please use method buildWindowsOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public WindowsSecurityContextOptions getWindowsOptions() {
    return this.windowsOptions!=null ?this.windowsOptions.build():null;
  }
  public WindowsSecurityContextOptions buildWindowsOptions() {
    return this.windowsOptions!=null ?this.windowsOptions.build():null;
  }
  public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
    _visitables.get("windowsOptions").remove(this.windowsOptions);
    if (windowsOptions!=null){ this.windowsOptions= new WindowsSecurityContextOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} else { this.windowsOptions = null; _visitables.get("windowsOptions").remove(this.windowsOptions); } return (A) this;
  }
  public Boolean hasWindowsOptions() {
    return this.windowsOptions != null;
  }
  public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName) {
    return (A)withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
  }
  public PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
    return new PodSecurityContextFluentImpl.WindowsOptionsNestedImpl();
  }
  public PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
    return new PodSecurityContextFluentImpl.WindowsOptionsNestedImpl(item);
  }
  public PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
    return withNewWindowsOptionsLike(getWindowsOptions());
  }
  public PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
    return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): new WindowsSecurityContextOptionsBuilder().build());
  }
  public PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
    return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl) o;
    if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
    if (fsGroupChangePolicy != null ? !fsGroupChangePolicy.equals(that.fsGroupChangePolicy) :that.fsGroupChangePolicy != null) return false;
    if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
    if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
    if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
    if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
    if (seccompProfile != null ? !seccompProfile.equals(that.seccompProfile) :that.seccompProfile != null) return false;
    if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
    if (sysctls != null ? !sysctls.equals(that.sysctls) :that.sysctls != null) return false;
    if (windowsOptions != null ? !windowsOptions.equals(that.windowsOptions) :that.windowsOptions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsGroup,  fsGroupChangePolicy,  runAsGroup,  runAsNonRoot,  runAsUser,  seLinuxOptions,  seccompProfile,  supplementalGroups,  sysctls,  windowsOptions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsGroup != null) { sb.append("fsGroup:"); sb.append(fsGroup + ","); }
    if (fsGroupChangePolicy != null) { sb.append("fsGroupChangePolicy:"); sb.append(fsGroupChangePolicy + ","); }
    if (runAsGroup != null) { sb.append("runAsGroup:"); sb.append(runAsGroup + ","); }
    if (runAsNonRoot != null) { sb.append("runAsNonRoot:"); sb.append(runAsNonRoot + ","); }
    if (runAsUser != null) { sb.append("runAsUser:"); sb.append(runAsUser + ","); }
    if (seLinuxOptions != null) { sb.append("seLinuxOptions:"); sb.append(seLinuxOptions + ","); }
    if (seccompProfile != null) { sb.append("seccompProfile:"); sb.append(seccompProfile + ","); }
    if (supplementalGroups != null && !supplementalGroups.isEmpty()) { sb.append("supplementalGroups:"); sb.append(supplementalGroups + ","); }
    if (sysctls != null && !sysctls.isEmpty()) { sb.append("sysctls:"); sb.append(sysctls + ","); }
    if (windowsOptions != null) { sb.append("windowsOptions:"); sb.append(windowsOptions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withRunAsNonRoot() {
    return withRunAsNonRoot(true);
  }
  class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<PodSecurityContextFluent.SeLinuxOptionsNested<N>> implements PodSecurityContextFluent.SeLinuxOptionsNested<N>,Nested<N>{
    SeLinuxOptionsNestedImpl(SELinuxOptions item) {
      this.builder = new SELinuxOptionsBuilder(this, item);
    }
    SeLinuxOptionsNestedImpl() {
      this.builder = new SELinuxOptionsBuilder(this);
    }
    SELinuxOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions() {
      return and();
    }
    
  }
  class SeccompProfileNestedImpl<N> extends SeccompProfileFluentImpl<PodSecurityContextFluent.SeccompProfileNested<N>> implements PodSecurityContextFluent.SeccompProfileNested<N>,Nested<N>{
    SeccompProfileNestedImpl(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileNestedImpl() {
      this.builder = new SeccompProfileBuilder(this);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) PodSecurityContextFluentImpl.this.withSeccompProfile(builder.build());
    }
    public N endSeccompProfile() {
      return and();
    }
    
  }
  class SysctlsNestedImpl<N> extends SysctlFluentImpl<PodSecurityContextFluent.SysctlsNested<N>> implements PodSecurityContextFluent.SysctlsNested<N>,Nested<N>{
    SysctlsNestedImpl(Integer index,Sysctl item) {
      this.index = index;
      this.builder = new SysctlBuilder(this, item);
    }
    SysctlsNestedImpl() {
      this.index = -1;
      this.builder = new SysctlBuilder(this);
    }
    SysctlBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSecurityContextFluentImpl.this.setToSysctls(index,builder.build());
    }
    public N endSysctl() {
      return and();
    }
    
  }
  class WindowsOptionsNestedImpl<N> extends WindowsSecurityContextOptionsFluentImpl<PodSecurityContextFluent.WindowsOptionsNested<N>> implements PodSecurityContextFluent.WindowsOptionsNested<N>,Nested<N>{
    WindowsOptionsNestedImpl(WindowsSecurityContextOptions item) {
      this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
    }
    WindowsOptionsNestedImpl() {
      this.builder = new WindowsSecurityContextOptionsBuilder(this);
    }
    WindowsSecurityContextOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityContextFluentImpl.this.withWindowsOptions(builder.build());
    }
    public N endWindowsOptions() {
      return and();
    }
    
  }
  
}