package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface PersistentVolumeClaimSpecFluent<A extends PersistentVolumeClaimSpecFluent<A>> extends Fluent<A>{
  public A addToAccessModes(Integer index,String item);
  public A setToAccessModes(Integer index,String item);
  public A addToAccessModes(java.lang.String... items);
  public A addAllToAccessModes(Collection<String> items);
  public A removeFromAccessModes(java.lang.String... items);
  public A removeAllFromAccessModes(Collection<String> items);
  public List<String> getAccessModes();
  public String getAccessMode(Integer index);
  public String getFirstAccessMode();
  public String getLastAccessMode();
  public String getMatchingAccessMode(Predicate<String> predicate);
  public Boolean hasMatchingAccessMode(Predicate<String> predicate);
  public A withAccessModes(List<String> accessModes);
  public A withAccessModes(java.lang.String... accessModes);
  public Boolean hasAccessModes();
  
  /**
   * This method has been deprecated, please use method buildDataSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public TypedLocalObjectReference getDataSource();
  public TypedLocalObjectReference buildDataSource();
  public A withDataSource(TypedLocalObjectReference dataSource);
  public Boolean hasDataSource();
  public A withNewDataSource(String apiGroup,String kind,String name);
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource();
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(TypedLocalObjectReference item);
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource();
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource();
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(TypedLocalObjectReference item);
  
  /**
   * This method has been deprecated, please use method buildDataSourceRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public TypedLocalObjectReference getDataSourceRef();
  public TypedLocalObjectReference buildDataSourceRef();
  public A withDataSourceRef(TypedLocalObjectReference dataSourceRef);
  public Boolean hasDataSourceRef();
  public A withNewDataSourceRef(String apiGroup,String kind,String name);
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRef();
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRefLike(TypedLocalObjectReference item);
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editDataSourceRef();
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRef();
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRefLike(TypedLocalObjectReference item);
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources();
  public ResourceRequirements buildResources();
  public A withResources(ResourceRequirements resources);
  public Boolean hasResources();
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources();
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources();
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources();
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector();
  public LabelSelector buildSelector();
  public A withSelector(LabelSelector selector);
  public Boolean hasSelector();
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector();
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector();
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector();
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
  public String getStorageClassName();
  public A withStorageClassName(String storageClassName);
  public Boolean hasStorageClassName();
  public String getVolumeMode();
  public A withVolumeMode(String volumeMode);
  public Boolean hasVolumeMode();
  public String getVolumeName();
  public A withVolumeName(String volumeName);
  public Boolean hasVolumeName();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface DataSourceNested<N> extends Nested<N>,TypedLocalObjectReferenceFluent<PersistentVolumeClaimSpecFluent.DataSourceNested<N>>{
    public N and();
    public N endDataSource();
    
  }
  public interface DataSourceRefNested<N> extends Nested<N>,TypedLocalObjectReferenceFluent<PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>>{
    public N and();
    public N endDataSourceRef();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResources();
    
  }
  public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<PersistentVolumeClaimSpecFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  
}