package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EventSeriesFluentImpl<A extends EventSeriesFluent<A>> extends BaseFluent<A> implements EventSeriesFluent<A>{
  public EventSeriesFluentImpl() {
  }
  public EventSeriesFluentImpl(EventSeries instance) {
    this.withCount(instance.getCount()); 
    this.withLastObservedTime(instance.getLastObservedTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer count;
  private MicroTimeBuilder lastObservedTime;
  private Map<String,Object> additionalProperties;
  public Integer getCount() {
    return this.count;
  }
  public A withCount(Integer count) {
    this.count=count; return (A) this;
  }
  public Boolean hasCount() {
    return this.count != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLastObservedTime instead.
   * @return The buildable object.
   */
  @Deprecated
  public MicroTime getLastObservedTime() {
    return this.lastObservedTime!=null ?this.lastObservedTime.build():null;
  }
  public MicroTime buildLastObservedTime() {
    return this.lastObservedTime!=null ?this.lastObservedTime.build():null;
  }
  public A withLastObservedTime(MicroTime lastObservedTime) {
    _visitables.get("lastObservedTime").remove(this.lastObservedTime);
    if (lastObservedTime!=null){ this.lastObservedTime= new MicroTimeBuilder(lastObservedTime); _visitables.get("lastObservedTime").add(this.lastObservedTime);} else { this.lastObservedTime = null; _visitables.get("lastObservedTime").remove(this.lastObservedTime); } return (A) this;
  }
  public Boolean hasLastObservedTime() {
    return this.lastObservedTime != null;
  }
  public A withNewLastObservedTime(String time) {
    return (A)withLastObservedTime(new MicroTime(time));
  }
  public EventSeriesFluent.LastObservedTimeNested<A> withNewLastObservedTime() {
    return new EventSeriesFluentImpl.LastObservedTimeNestedImpl();
  }
  public EventSeriesFluent.LastObservedTimeNested<A> withNewLastObservedTimeLike(MicroTime item) {
    return new EventSeriesFluentImpl.LastObservedTimeNestedImpl(item);
  }
  public EventSeriesFluent.LastObservedTimeNested<A> editLastObservedTime() {
    return withNewLastObservedTimeLike(getLastObservedTime());
  }
  public EventSeriesFluent.LastObservedTimeNested<A> editOrNewLastObservedTime() {
    return withNewLastObservedTimeLike(getLastObservedTime() != null ? getLastObservedTime(): new MicroTimeBuilder().build());
  }
  public EventSeriesFluent.LastObservedTimeNested<A> editOrNewLastObservedTimeLike(MicroTime item) {
    return withNewLastObservedTimeLike(getLastObservedTime() != null ? getLastObservedTime(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventSeriesFluentImpl that = (EventSeriesFluentImpl) o;
    if (count != null ? !count.equals(that.count) :that.count != null) return false;
    if (lastObservedTime != null ? !lastObservedTime.equals(that.lastObservedTime) :that.lastObservedTime != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(count,  lastObservedTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (count != null) { sb.append("count:"); sb.append(count + ","); }
    if (lastObservedTime != null) { sb.append("lastObservedTime:"); sb.append(lastObservedTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LastObservedTimeNestedImpl<N> extends MicroTimeFluentImpl<EventSeriesFluent.LastObservedTimeNested<N>> implements EventSeriesFluent.LastObservedTimeNested<N>,Nested<N>{
    LastObservedTimeNestedImpl(MicroTime item) {
      this.builder = new MicroTimeBuilder(this, item);
    }
    LastObservedTimeNestedImpl() {
      this.builder = new MicroTimeBuilder(this);
    }
    MicroTimeBuilder builder;
    public N and() {
      return (N) EventSeriesFluentImpl.this.withLastObservedTime(builder.build());
    }
    public N endLastObservedTime() {
      return and();
    }
    
  }
  
}