package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EnvFromSourceFluentImpl<A extends EnvFromSourceFluent<A>> extends BaseFluent<A> implements EnvFromSourceFluent<A>{
  public EnvFromSourceFluentImpl() {
  }
  public EnvFromSourceFluentImpl(EnvFromSource instance) {
    this.withConfigMapRef(instance.getConfigMapRef()); 
    this.withPrefix(instance.getPrefix()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapEnvSourceBuilder configMapRef;
  private String prefix;
  private SecretEnvSourceBuilder secretRef;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConfigMapRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapEnvSource getConfigMapRef() {
    return this.configMapRef!=null ?this.configMapRef.build():null;
  }
  public ConfigMapEnvSource buildConfigMapRef() {
    return this.configMapRef!=null ?this.configMapRef.build():null;
  }
  public A withConfigMapRef(ConfigMapEnvSource configMapRef) {
    _visitables.get("configMapRef").remove(this.configMapRef);
    if (configMapRef!=null){ this.configMapRef= new ConfigMapEnvSourceBuilder(configMapRef); _visitables.get("configMapRef").add(this.configMapRef);} else { this.configMapRef = null; _visitables.get("configMapRef").remove(this.configMapRef); } return (A) this;
  }
  public Boolean hasConfigMapRef() {
    return this.configMapRef != null;
  }
  public A withNewConfigMapRef(String name,Boolean optional) {
    return (A)withConfigMapRef(new ConfigMapEnvSource(name, optional));
  }
  public EnvFromSourceFluent.ConfigMapRefNested<A> withNewConfigMapRef() {
    return new EnvFromSourceFluentImpl.ConfigMapRefNestedImpl();
  }
  public EnvFromSourceFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ConfigMapEnvSource item) {
    return new EnvFromSourceFluentImpl.ConfigMapRefNestedImpl(item);
  }
  public EnvFromSourceFluent.ConfigMapRefNested<A> editConfigMapRef() {
    return withNewConfigMapRefLike(getConfigMapRef());
  }
  public EnvFromSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRef() {
    return withNewConfigMapRefLike(getConfigMapRef() != null ? getConfigMapRef(): new ConfigMapEnvSourceBuilder().build());
  }
  public EnvFromSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ConfigMapEnvSource item) {
    return withNewConfigMapRefLike(getConfigMapRef() != null ? getConfigMapRef(): item);
  }
  public String getPrefix() {
    return this.prefix;
  }
  public A withPrefix(String prefix) {
    this.prefix=prefix; return (A) this;
  }
  public Boolean hasPrefix() {
    return this.prefix != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretEnvSource getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public SecretEnvSource buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(SecretEnvSource secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new SecretEnvSourceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(String name,Boolean optional) {
    return (A)withSecretRef(new SecretEnvSource(name, optional));
  }
  public EnvFromSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new EnvFromSourceFluentImpl.SecretRefNestedImpl();
  }
  public EnvFromSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretEnvSource item) {
    return new EnvFromSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public EnvFromSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public EnvFromSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new SecretEnvSourceBuilder().build());
  }
  public EnvFromSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretEnvSource item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EnvFromSourceFluentImpl that = (EnvFromSourceFluentImpl) o;
    if (configMapRef != null ? !configMapRef.equals(that.configMapRef) :that.configMapRef != null) return false;
    if (prefix != null ? !prefix.equals(that.prefix) :that.prefix != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMapRef,  prefix,  secretRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapRef != null) { sb.append("configMapRef:"); sb.append(configMapRef + ","); }
    if (prefix != null) { sb.append("prefix:"); sb.append(prefix + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigMapRefNestedImpl<N> extends ConfigMapEnvSourceFluentImpl<EnvFromSourceFluent.ConfigMapRefNested<N>> implements EnvFromSourceFluent.ConfigMapRefNested<N>,Nested<N>{
    ConfigMapRefNestedImpl(ConfigMapEnvSource item) {
      this.builder = new ConfigMapEnvSourceBuilder(this, item);
    }
    ConfigMapRefNestedImpl() {
      this.builder = new ConfigMapEnvSourceBuilder(this);
    }
    ConfigMapEnvSourceBuilder builder;
    public N and() {
      return (N) EnvFromSourceFluentImpl.this.withConfigMapRef(builder.build());
    }
    public N endConfigMapRef() {
      return and();
    }
    
  }
  class SecretRefNestedImpl<N> extends SecretEnvSourceFluentImpl<EnvFromSourceFluent.SecretRefNested<N>> implements EnvFromSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(SecretEnvSource item) {
      this.builder = new SecretEnvSourceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new SecretEnvSourceBuilder(this);
    }
    SecretEnvSourceBuilder builder;
    public N and() {
      return (N) EnvFromSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}