package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapNodeConfigSourceBuilder extends ConfigMapNodeConfigSourceFluentImpl<ConfigMapNodeConfigSourceBuilder> implements VisitableBuilder<ConfigMapNodeConfigSource,ConfigMapNodeConfigSourceBuilder>{
  public ConfigMapNodeConfigSourceBuilder() {
    this(false);
  }
  public ConfigMapNodeConfigSourceBuilder(Boolean validationEnabled) {
    this(new ConfigMapNodeConfigSource(), validationEnabled);
  }
  public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapNodeConfigSource(), validationEnabled);
  }
  public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent,ConfigMapNodeConfigSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSourceFluent<?> fluent,ConfigMapNodeConfigSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKubeletConfigKey(instance.getKubeletConfigKey()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSource instance) {
    this(instance,false);
  }
  public ConfigMapNodeConfigSourceBuilder(ConfigMapNodeConfigSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKubeletConfigKey(instance.getKubeletConfigKey()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigMapNodeConfigSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapNodeConfigSource build() {
    ConfigMapNodeConfigSource buildable = new ConfigMapNodeConfigSource(fluent.getKubeletConfigKey(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}