package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AttachedVolumeBuilder extends AttachedVolumeFluentImpl<AttachedVolumeBuilder> implements VisitableBuilder<AttachedVolume,AttachedVolumeBuilder>{
  public AttachedVolumeBuilder() {
    this(false);
  }
  public AttachedVolumeBuilder(Boolean validationEnabled) {
    this(new AttachedVolume(), validationEnabled);
  }
  public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AttachedVolume(), validationEnabled);
  }
  public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent,AttachedVolume instance) {
    this(fluent, instance, false);
  }
  public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent,AttachedVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDevicePath(instance.getDevicePath()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AttachedVolumeBuilder(AttachedVolume instance) {
    this(instance,false);
  }
  public AttachedVolumeBuilder(AttachedVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDevicePath(instance.getDevicePath()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AttachedVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public AttachedVolume build() {
    AttachedVolume buildable = new AttachedVolume(fluent.getDevicePath(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}