package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface APIServiceFluent<A extends APIServiceFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public APIServiceFluent.MetadataNested<A> withNewMetadata();
  public APIServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public APIServiceFluent.MetadataNested<A> editMetadata();
  public APIServiceFluent.MetadataNested<A> editOrNewMetadata();
  public APIServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServiceSpec getSpec();
  public APIServiceSpec buildSpec();
  public A withSpec(APIServiceSpec spec);
  public Boolean hasSpec();
  public APIServiceFluent.SpecNested<A> withNewSpec();
  public APIServiceFluent.SpecNested<A> withNewSpecLike(APIServiceSpec item);
  public APIServiceFluent.SpecNested<A> editSpec();
  public APIServiceFluent.SpecNested<A> editOrNewSpec();
  public APIServiceFluent.SpecNested<A> editOrNewSpecLike(APIServiceSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServiceStatus getStatus();
  public APIServiceStatus buildStatus();
  public A withStatus(APIServiceStatus status);
  public Boolean hasStatus();
  public APIServiceFluent.StatusNested<A> withNewStatus();
  public APIServiceFluent.StatusNested<A> withNewStatusLike(APIServiceStatus item);
  public APIServiceFluent.StatusNested<A> editStatus();
  public APIServiceFluent.StatusNested<A> editOrNewStatus();
  public APIServiceFluent.StatusNested<A> editOrNewStatusLike(APIServiceStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<APIServiceFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,APIServiceSpecFluent<APIServiceFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,APIServiceStatusFluent<APIServiceFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}