package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TaintBuilder extends io.fabric8.kubernetes.api.model.TaintFluentImpl<io.fabric8.kubernetes.api.model.TaintBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Taint,io.fabric8.kubernetes.api.model.TaintBuilder>{
  public TaintBuilder() {
    this(false);
  }
  public TaintBuilder(java.lang.Boolean validationEnabled) {
    this(new Taint(), validationEnabled);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent) {
    this(fluent, false);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Taint(), validationEnabled);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent,io.fabric8.kubernetes.api.model.Taint instance) {
    this(fluent, instance, false);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.TaintFluent<?> fluent,io.fabric8.kubernetes.api.model.Taint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEffect(instance.getEffect()); 
    fluent.withKey(instance.getKey()); 
    fluent.withTimeAdded(instance.getTimeAdded()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.Taint instance) {
    this(instance,false);
  }
  public TaintBuilder(io.fabric8.kubernetes.api.model.Taint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEffect(instance.getEffect()); 
    this.withKey(instance.getKey()); 
    this.withTimeAdded(instance.getTimeAdded()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TaintFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Taint build() {
    Taint buildable = new Taint(fluent.getEffect(),fluent.getKey(),fluent.getTimeAdded(),fluent.getValue());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaintBuilder that = (TaintBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}