package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceAccountBuilder extends io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl<io.fabric8.kubernetes.api.model.ServiceAccountBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServiceAccount,io.fabric8.kubernetes.api.model.ServiceAccountBuilder>{
  public ServiceAccountBuilder() {
    this(false);
  }
  public ServiceAccountBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceAccount(), validationEnabled);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceAccount(), validationEnabled);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccount instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccount instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSecrets(instance.getSecrets()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccount instance) {
    this(instance,false);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccount instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSecrets(instance.getSecrets()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceAccount build() {
    ServiceAccount buildable = new ServiceAccount(fluent.getApiVersion(),fluent.getAutomountServiceAccountToken(),fluent.getImagePullSecrets(),fluent.getKind(),fluent.getMetadata(),fluent.getSecrets());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceAccountBuilder that = (ServiceAccountBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}