package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SecurityContextBuilder extends io.fabric8.kubernetes.api.model.SecurityContextFluentImpl<io.fabric8.kubernetes.api.model.SecurityContextBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.SecurityContext,io.fabric8.kubernetes.api.model.SecurityContextBuilder>{
  public SecurityContextBuilder() {
    this(false);
  }
  public SecurityContextBuilder(java.lang.Boolean validationEnabled) {
    this(new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent,io.fabric8.kubernetes.api.model.SecurityContext instance) {
    this(fluent, instance, false);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent,io.fabric8.kubernetes.api.model.SecurityContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    fluent.withCapabilities(instance.getCapabilities()); 
    fluent.withPrivileged(instance.getPrivileged()); 
    fluent.withProcMount(instance.getProcMount()); 
    fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    fluent.withRunAsGroup(instance.getRunAsGroup()); 
    fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    fluent.withRunAsUser(instance.getRunAsUser()); 
    fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    fluent.withSeccompProfile(instance.getSeccompProfile()); 
    fluent.withWindowsOptions(instance.getWindowsOptions()); 
    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContext instance) {
    this(instance,false);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withCapabilities(instance.getCapabilities()); 
    this.withPrivileged(instance.getPrivileged()); 
    this.withProcMount(instance.getProcMount()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    this.withSeccompProfile(instance.getSeccompProfile()); 
    this.withWindowsOptions(instance.getWindowsOptions()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecurityContext build() {
    SecurityContext buildable = new SecurityContext(fluent.getAllowPrivilegeEscalation(),fluent.getCapabilities(),fluent.getPrivileged(),fluent.getProcMount(),fluent.getReadOnlyRootFilesystem(),fluent.getRunAsGroup(),fluent.getRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions(),fluent.getSeccompProfile(),fluent.getWindowsOptions());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityContextBuilder that = (SecurityContextBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}