package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ReplicationControllerSpecBuilder extends io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentImpl<io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ReplicationControllerSpec,io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder>{
  public ReplicationControllerSpecBuilder() {
    this(false);
  }
  public ReplicationControllerSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ReplicationControllerSpec(), validationEnabled);
  }
  public ReplicationControllerSpecBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerSpecBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicationControllerSpec(), validationEnabled);
  }
  public ReplicationControllerSpecBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerSpec instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerSpecBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerSpecBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerSpec instance) {
    this(instance,false);
  }
  public ReplicationControllerSpecBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ReplicationControllerSpec build() {
    ReplicationControllerSpec buildable = new ReplicationControllerSpec(fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReplicationControllerSpecBuilder that = (ReplicationControllerSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}