package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Quantity is fixed point representation of a number.
  * It provides convenient marshalling/unmarshalling in JSON or YAML,
  * in addition to String or getAmountInBytes accessors.
  */
public class QuantityBuilder extends io.fabric8.kubernetes.api.model.QuantityFluentImpl<io.fabric8.kubernetes.api.model.QuantityBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Quantity,io.fabric8.kubernetes.api.model.QuantityBuilder>{
  public QuantityBuilder() {
    this(false);
  }
  public QuantityBuilder(java.lang.Boolean validationEnabled) {
    this(new Quantity(), validationEnabled);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent) {
    this(fluent, false);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Quantity(), validationEnabled);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent,io.fabric8.kubernetes.api.model.Quantity instance) {
    this(fluent, instance, false);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent,io.fabric8.kubernetes.api.model.Quantity instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAmount(instance.getAmount()); 
    fluent.withFormat(instance.getFormat());

    this.validationEnabled = validationEnabled; 
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.Quantity instance) {
    this(instance,false);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.Quantity instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAmount(instance.getAmount()); 
    this.withFormat(instance.getFormat());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Quantity build() {
    Quantity buildable = new Quantity(fluent.getAmount());
    buildable.setFormat(fluent.getFormat());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QuantityBuilder that = (QuantityBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}