package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PodBuilder extends io.fabric8.kubernetes.api.model.PodFluentImpl<io.fabric8.kubernetes.api.model.PodBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Pod,io.fabric8.kubernetes.api.model.PodBuilder>{
  public PodBuilder() {
    this(false);
  }
  public PodBuilder(java.lang.Boolean validationEnabled) {
    this(new Pod(), validationEnabled);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent) {
    this(fluent, false);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Pod(), validationEnabled);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent,io.fabric8.kubernetes.api.model.Pod instance) {
    this(fluent, instance, false);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent,io.fabric8.kubernetes.api.model.Pod instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.Pod instance) {
    this(instance,false);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.Pod instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Pod build() {
    Pod buildable = new Pod(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodBuilder that = (PodBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}