package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PodAffinityTermBuilder extends io.fabric8.kubernetes.api.model.PodAffinityTermFluentImpl<io.fabric8.kubernetes.api.model.PodAffinityTermBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodAffinityTerm,io.fabric8.kubernetes.api.model.PodAffinityTermBuilder>{
  public PodAffinityTermBuilder() {
    this(false);
  }
  public PodAffinityTermBuilder(java.lang.Boolean validationEnabled) {
    this(new PodAffinityTerm(), validationEnabled);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodAffinityTerm(), validationEnabled);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinityTerm instance) {
    this(fluent, instance, false);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinityTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withTopologyKey(instance.getTopologyKey()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTerm instance) {
    this(instance,false);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withTopologyKey(instance.getTopologyKey()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodAffinityTerm build() {
    PodAffinityTerm buildable = new PodAffinityTerm(fluent.getLabelSelector(),fluent.getNamespaceSelector(),fluent.getNamespaces(),fluent.getTopologyKey());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodAffinityTermBuilder that = (PodAffinityTermBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}