package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NodeBuilder extends io.fabric8.kubernetes.api.model.NodeFluentImpl<io.fabric8.kubernetes.api.model.NodeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Node,io.fabric8.kubernetes.api.model.NodeBuilder>{
  public NodeBuilder() {
    this(false);
  }
  public NodeBuilder(java.lang.Boolean validationEnabled) {
    this(new Node(), validationEnabled);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Node(), validationEnabled);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent,io.fabric8.kubernetes.api.model.Node instance) {
    this(fluent, instance, false);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent,io.fabric8.kubernetes.api.model.Node instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.Node instance) {
    this(instance,false);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.Node instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Node build() {
    Node buildable = new Node(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeBuilder that = (NodeBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}