package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class EndpointsFluentImpl<A extends io.fabric8.kubernetes.api.model.EndpointsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.EndpointsFluent<A>{
  public EndpointsFluentImpl() {
  }
  public EndpointsFluentImpl(io.fabric8.kubernetes.api.model.Endpoints instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSubsets(instance.getSubsets()); 
  }
  private java.lang.String apiVersion;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.List<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> subsets =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>();
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToSubsets(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointSubset item) {
    if (this.subsets == null) {this.subsets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(item);_visitables.get("subsets").add(index >= 0 ? index : _visitables.get("subsets").size(), builder);this.subsets.add(index >= 0 ? index : subsets.size(), builder); return (A)this;
  }
  public A setToSubsets(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointSubset item) {
    if (this.subsets == null) {this.subsets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(item);
    if (index < 0 || index >= _visitables.get("subsets").size()) { _visitables.get("subsets").add(builder); } else { _visitables.get("subsets").set(index, builder);}
    if (index < 0 || index >= subsets.size()) { subsets.add(builder); } else { subsets.set(index, builder);}
     return (A)this;
  }
  public A addToSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items) {
    if (this.subsets == null) {this.subsets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointSubset item : items) {io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  public A addAllToSubsets(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointSubset> items) {
    if (this.subsets == null) {this.subsets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointSubset item : items) {io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  public A removeFromSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items) {
    for (io.fabric8.kubernetes.api.model.EndpointSubset item : items) {io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(item);_visitables.get("subsets").remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubsets(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointSubset> items) {
    for (io.fabric8.kubernetes.api.model.EndpointSubset item : items) {io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(item);_visitables.get("subsets").remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubsets(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> predicate) {
    if (subsets == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> each = subsets.iterator();
    final List visitables = _visitables.get("subsets");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubsets instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointSubset> getSubsets() {
    return build(subsets);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointSubset> buildSubsets() {
    return build(subsets);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubset buildSubset(java.lang.Integer index) {
    return this.subsets.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubset buildFirstSubset() {
    return this.subsets.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubset buildLastSubset() {
    return this.subsets.get(subsets.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubset buildMatchingSubset(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointSubsetBuilder item: subsets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSubset(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointSubsetBuilder item: subsets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubsets(java.util.List<io.fabric8.kubernetes.api.model.EndpointSubset> subsets) {
    if (this.subsets != null) { _visitables.get("subsets").removeAll(this.subsets);}
    if (subsets != null) {this.subsets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>(); for (io.fabric8.kubernetes.api.model.EndpointSubset item : subsets){this.addToSubsets(item);}} else { this.subsets = null;} return (A) this;
  }
  public A withSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... subsets) {
    if (this.subsets != null) {this.subsets.clear();}
    if (subsets != null) {for (io.fabric8.kubernetes.api.model.EndpointSubset item :subsets){ this.addToSubsets(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubsets() {
    return subsets != null && !subsets.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> addNewSubset() {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentImpl.SubsetsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> addNewSubsetLike(io.fabric8.kubernetes.api.model.EndpointSubset item) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentImpl.SubsetsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> setNewSubsetLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointSubset item) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentImpl.SubsetsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> editSubset(java.lang.Integer index) {
    if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> editFirstSubset() {
    if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
    return setNewSubsetLike(0, buildSubset(0));
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> editLastSubset() {
    int index = subsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<A> editMatchingSubset(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subsets.size();i++) { 
    if (predicate.test(subsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointsFluentImpl that = (EndpointsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  subsets,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.EndpointsFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) EndpointsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class SubsetsNestedImpl<N> extends io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl<io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<N>> implements io.fabric8.kubernetes.api.model.EndpointsFluent.SubsetsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SubsetsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointSubset item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(this, item);
    }
    SubsetsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointSubsetBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointSubsetBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointsFluentImpl.this.setToSubsets(index,builder.build());
    }
    public N endSubset() {
      return and();
    }
    
  }
  
}