package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class ResourceQuotaListFluentImpl<A extends io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<A>{
  public ResourceQuotaListFluentImpl() {
  }
  public ResourceQuotaListFluentImpl(io.fabric8.kubernetes.api.model.ResourceQuotaList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder> items =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder>();
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ListMetaBuilder metadata;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder>();}
    io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder>();}
    io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder>();}
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder>();}
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items) {
    for (io.fabric8.kubernetes.api.model.ResourceQuota item : items) {io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ResourceQuota> getItems() {
    return build(items);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ResourceQuota> buildItems() {
    return build(items);
  }
  public io.fabric8.kubernetes.api.model.ResourceQuota buildItem(java.lang.Integer index) {
    return this.items.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ResourceQuota buildFirstItem() {
    return this.items.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ResourceQuota buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ResourceQuota buildMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ResourceQuotaBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ResourceQuotaBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(java.util.List<io.fabric8.kubernetes.api.model.ResourceQuota> items) {
    if (this.items != null) { _visitables.get("items").removeAll(this.items);}
    if (items != null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder>(); for (io.fabric8.kubernetes.api.model.ResourceQuota item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (io.fabric8.kubernetes.api.model.ResourceQuota item :items){ this.addToItems(item);}} return (A) this;
  }
  public java.lang.Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> addNewItem() {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentImpl.ItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> addNewItemLike(io.fabric8.kubernetes.api.model.ResourceQuota item) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> setNewItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentImpl.ItemsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> editItem(java.lang.Integer index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<A> editMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ResourceQuotaBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ListMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ListMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(java.lang.String _continue,java.lang.Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ListMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceQuotaListFluentImpl that = (ResourceQuotaListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public class ItemsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ResourceQuotaFluentImpl<io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<N>> implements io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ResourceQuota item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ResourceQuotaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceQuotaBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ResourceQuotaListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ListMetaFluentImpl<io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.ResourceQuotaListFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ListMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ListMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ListMetaBuilder builder;
    public N and() {
      return (N) ResourceQuotaListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}