package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LoadBalancerIngressBuilder extends io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LoadBalancerIngress,io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>{
  public LoadBalancerIngressBuilder() {
    this(false);
  }
  public LoadBalancerIngressBuilder(java.lang.Boolean validationEnabled) {
    this(new LoadBalancerIngress(), validationEnabled);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LoadBalancerIngress(), validationEnabled);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerIngress instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostname(instance.getHostname()); 
    fluent.withIp(instance.getIp()); 
    fluent.withPorts(instance.getPorts()); 
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngress instance) {
    this(instance,false);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostname(instance.getHostname()); 
    this.withIp(instance.getIp()); 
    this.withPorts(instance.getPorts()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LoadBalancerIngress build() {
    LoadBalancerIngress buildable = new LoadBalancerIngress(fluent.getHostname(),fluent.getIp(),fluent.getPorts());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LoadBalancerIngressBuilder that = (LoadBalancerIngressBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}