package io.fabric8.kubernetes.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

 /**
  * Generated
  */
public class VolumeFluentImpl<A extends io.fabric8.kubernetes.api.model.VolumeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.VolumeFluent<A>{
  public VolumeFluentImpl() {
  }
  public VolumeFluentImpl(io.fabric8.kubernetes.api.model.Volume instance) {
    this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
    this.withAzureDisk(instance.getAzureDisk()); 
    this.withAzureFile(instance.getAzureFile()); 
    this.withCephfs(instance.getCephfs()); 
    this.withCinder(instance.getCinder()); 
    this.withConfigMap(instance.getConfigMap()); 
    this.withCsi(instance.getCsi()); 
    this.withDownwardAPI(instance.getDownwardAPI()); 
    this.withEmptyDir(instance.getEmptyDir()); 
    this.withEphemeral(instance.getEphemeral()); 
    this.withFc(instance.getFc()); 
    this.withFlexVolume(instance.getFlexVolume()); 
    this.withFlocker(instance.getFlocker()); 
    this.withGcePersistentDisk(instance.getGcePersistentDisk()); 
    this.withGitRepo(instance.getGitRepo()); 
    this.withGlusterfs(instance.getGlusterfs()); 
    this.withHostPath(instance.getHostPath()); 
    this.withIscsi(instance.getIscsi()); 
    this.withName(instance.getName()); 
    this.withNfs(instance.getNfs()); 
    this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
    this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk()); 
    this.withPortworxVolume(instance.getPortworxVolume()); 
    this.withProjected(instance.getProjected()); 
    this.withQuobyte(instance.getQuobyte()); 
    this.withRbd(instance.getRbd()); 
    this.withScaleIO(instance.getScaleIO()); 
    this.withSecret(instance.getSecret()); 
    this.withStorageos(instance.getStorageos()); 
    this.withVsphereVolume(instance.getVsphereVolume()); 
  }
  private io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
  private io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder azureDisk;
  private io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder azureFile;
  private io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder cephfs;
  private io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder cinder;
  private io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder configMap;
  private io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder csi;
  private io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder downwardAPI;
  private io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder emptyDir;
  private io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder ephemeral;
  private io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder fc;
  private io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder flexVolume;
  private io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder flocker;
  private io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
  private io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder gitRepo;
  private io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder glusterfs;
  private io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder hostPath;
  private io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder iscsi;
  private java.lang.String name;
  private io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder nfs;
  private io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder persistentVolumeClaim;
  private io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
  private io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder portworxVolume;
  private io.fabric8.kubernetes.api.model.ProjectedVolumeSourceBuilder projected;
  private io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder quobyte;
  private io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder rbd;
  private io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder scaleIO;
  private io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder secret;
  private io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder storageos;
  private io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;
  
  /**
   * This method has been deprecated, please use method buildAwsElasticBlockStore instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
  }
  public io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
  }
  public A withAwsElasticBlockStore(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    _visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore);
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.get("awsElasticBlockStore").add(this.awsElasticBlockStore);} return (A) this;
  }
  public java.lang.Boolean hasAwsElasticBlockStore() {
    return this.awsElasticBlockStore != null;
  }
  public A withNewAwsElasticBlockStore(java.lang.String fsType,java.lang.Integer partition,java.lang.Boolean readOnly,java.lang.String volumeID) {
    return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.AwsElasticBlockStoreNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.AwsElasticBlockStoreNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource item) {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzureDisk instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.AzureDiskVolumeSource getAzureDisk() {
    return this.azureDisk!=null?this.azureDisk.build():null;
  }
  public io.fabric8.kubernetes.api.model.AzureDiskVolumeSource buildAzureDisk() {
    return this.azureDisk!=null?this.azureDisk.build():null;
  }
  public A withAzureDisk(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource azureDisk) {
    _visitables.get("azureDisk").remove(this.azureDisk);
    if (azureDisk!=null){ this.azureDisk= new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder(azureDisk); _visitables.get("azureDisk").add(this.azureDisk);} return (A) this;
  }
  public java.lang.Boolean hasAzureDisk() {
    return this.azureDisk != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<A> withNewAzureDisk() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.AzureDiskNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<A> withNewAzureDiskLike(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.AzureDiskNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<A> editAzureDisk() {
    return withNewAzureDiskLike(getAzureDisk());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<A> editOrNewAzureDisk() {
    return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<A> editOrNewAzureDiskLike(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource item) {
    return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzureFile instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.AzureFileVolumeSource getAzureFile() {
    return this.azureFile!=null?this.azureFile.build():null;
  }
  public io.fabric8.kubernetes.api.model.AzureFileVolumeSource buildAzureFile() {
    return this.azureFile!=null?this.azureFile.build():null;
  }
  public A withAzureFile(io.fabric8.kubernetes.api.model.AzureFileVolumeSource azureFile) {
    _visitables.get("azureFile").remove(this.azureFile);
    if (azureFile!=null){ this.azureFile= new io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder(azureFile); _visitables.get("azureFile").add(this.azureFile);} return (A) this;
  }
  public java.lang.Boolean hasAzureFile() {
    return this.azureFile != null;
  }
  public A withNewAzureFile(java.lang.Boolean readOnly,java.lang.String secretName,java.lang.String shareName) {
    return (A)withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<A> withNewAzureFile() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.AzureFileNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<A> withNewAzureFileLike(io.fabric8.kubernetes.api.model.AzureFileVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.AzureFileNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<A> editAzureFile() {
    return withNewAzureFileLike(getAzureFile());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<A> editOrNewAzureFile() {
    return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): new io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<A> editOrNewAzureFileLike(io.fabric8.kubernetes.api.model.AzureFileVolumeSource item) {
    return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCephfs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.CephFSVolumeSource getCephfs() {
    return this.cephfs!=null?this.cephfs.build():null;
  }
  public io.fabric8.kubernetes.api.model.CephFSVolumeSource buildCephfs() {
    return this.cephfs!=null?this.cephfs.build():null;
  }
  public A withCephfs(io.fabric8.kubernetes.api.model.CephFSVolumeSource cephfs) {
    _visitables.get("cephfs").remove(this.cephfs);
    if (cephfs!=null){ this.cephfs= new io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder(cephfs); _visitables.get("cephfs").add(this.cephfs);} return (A) this;
  }
  public java.lang.Boolean hasCephfs() {
    return this.cephfs != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<A> withNewCephfs() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.CephfsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<A> withNewCephfsLike(io.fabric8.kubernetes.api.model.CephFSVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.CephfsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<A> editCephfs() {
    return withNewCephfsLike(getCephfs());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<A> editOrNewCephfs() {
    return withNewCephfsLike(getCephfs() != null ? getCephfs(): new io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<A> editOrNewCephfsLike(io.fabric8.kubernetes.api.model.CephFSVolumeSource item) {
    return withNewCephfsLike(getCephfs() != null ? getCephfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCinder instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.CinderVolumeSource getCinder() {
    return this.cinder!=null?this.cinder.build():null;
  }
  public io.fabric8.kubernetes.api.model.CinderVolumeSource buildCinder() {
    return this.cinder!=null?this.cinder.build():null;
  }
  public A withCinder(io.fabric8.kubernetes.api.model.CinderVolumeSource cinder) {
    _visitables.get("cinder").remove(this.cinder);
    if (cinder!=null){ this.cinder= new io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder(cinder); _visitables.get("cinder").add(this.cinder);} return (A) this;
  }
  public java.lang.Boolean hasCinder() {
    return this.cinder != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<A> withNewCinder() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.CinderNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<A> withNewCinderLike(io.fabric8.kubernetes.api.model.CinderVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.CinderNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<A> editCinder() {
    return withNewCinderLike(getCinder());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<A> editOrNewCinder() {
    return withNewCinderLike(getCinder() != null ? getCinder(): new io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<A> editOrNewCinderLike(io.fabric8.kubernetes.api.model.CinderVolumeSource item) {
    return withNewCinderLike(getCinder() != null ? getCinder(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMap instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ConfigMapVolumeSource getConfigMap() {
    return this.configMap!=null?this.configMap.build():null;
  }
  public io.fabric8.kubernetes.api.model.ConfigMapVolumeSource buildConfigMap() {
    return this.configMap!=null?this.configMap.build():null;
  }
  public A withConfigMap(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder(configMap); _visitables.get("configMap").add(this.configMap);} return (A) this;
  }
  public java.lang.Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<A> withNewConfigMap() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.ConfigMapNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<A> withNewConfigMapLike(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.ConfigMapNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(getConfigMap());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<A> editOrNewConfigMapLike(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource item) {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCsi instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.CSIVolumeSource getCsi() {
    return this.csi!=null?this.csi.build():null;
  }
  public io.fabric8.kubernetes.api.model.CSIVolumeSource buildCsi() {
    return this.csi!=null?this.csi.build():null;
  }
  public A withCsi(io.fabric8.kubernetes.api.model.CSIVolumeSource csi) {
    _visitables.get("csi").remove(this.csi);
    if (csi!=null){ this.csi= new io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder(csi); _visitables.get("csi").add(this.csi);} return (A) this;
  }
  public java.lang.Boolean hasCsi() {
    return this.csi != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<A> withNewCsi() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.CsiNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<A> withNewCsiLike(io.fabric8.kubernetes.api.model.CSIVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.CsiNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<A> editCsi() {
    return withNewCsiLike(getCsi());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<A> editOrNewCsi() {
    return withNewCsiLike(getCsi() != null ? getCsi(): new io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<A> editOrNewCsiLike(io.fabric8.kubernetes.api.model.CSIVolumeSource item) {
    return withNewCsiLike(getCsi() != null ? getCsi(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDownwardAPI instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource getDownwardAPI() {
    return this.downwardAPI!=null?this.downwardAPI.build():null;
  }
  public io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource buildDownwardAPI() {
    return this.downwardAPI!=null?this.downwardAPI.build():null;
  }
  public A withDownwardAPI(io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource downwardAPI) {
    _visitables.get("downwardAPI").remove(this.downwardAPI);
    if (downwardAPI!=null){ this.downwardAPI= new io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder(downwardAPI); _visitables.get("downwardAPI").add(this.downwardAPI);} return (A) this;
  }
  public java.lang.Boolean hasDownwardAPI() {
    return this.downwardAPI != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<A> withNewDownwardAPI() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.DownwardAPINestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<A> withNewDownwardAPILike(io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.DownwardAPINestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<A> editDownwardAPI() {
    return withNewDownwardAPILike(getDownwardAPI());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<A> editOrNewDownwardAPI() {
    return withNewDownwardAPILike(getDownwardAPI() != null ? getDownwardAPI(): new io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<A> editOrNewDownwardAPILike(io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource item) {
    return withNewDownwardAPILike(getDownwardAPI() != null ? getDownwardAPI(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEmptyDir instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.EmptyDirVolumeSource getEmptyDir() {
    return this.emptyDir!=null?this.emptyDir.build():null;
  }
  public io.fabric8.kubernetes.api.model.EmptyDirVolumeSource buildEmptyDir() {
    return this.emptyDir!=null?this.emptyDir.build():null;
  }
  public A withEmptyDir(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource emptyDir) {
    _visitables.get("emptyDir").remove(this.emptyDir);
    if (emptyDir!=null){ this.emptyDir= new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder(emptyDir); _visitables.get("emptyDir").add(this.emptyDir);} return (A) this;
  }
  public java.lang.Boolean hasEmptyDir() {
    return this.emptyDir != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<A> withNewEmptyDir() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.EmptyDirNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<A> withNewEmptyDirLike(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.EmptyDirNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<A> editEmptyDir() {
    return withNewEmptyDirLike(getEmptyDir());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<A> editOrNewEmptyDir() {
    return withNewEmptyDirLike(getEmptyDir() != null ? getEmptyDir(): new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<A> editOrNewEmptyDirLike(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource item) {
    return withNewEmptyDirLike(getEmptyDir() != null ? getEmptyDir(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEphemeral instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.EphemeralVolumeSource getEphemeral() {
    return this.ephemeral!=null?this.ephemeral.build():null;
  }
  public io.fabric8.kubernetes.api.model.EphemeralVolumeSource buildEphemeral() {
    return this.ephemeral!=null?this.ephemeral.build():null;
  }
  public A withEphemeral(io.fabric8.kubernetes.api.model.EphemeralVolumeSource ephemeral) {
    _visitables.get("ephemeral").remove(this.ephemeral);
    if (ephemeral!=null){ this.ephemeral= new io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder(ephemeral); _visitables.get("ephemeral").add(this.ephemeral);} return (A) this;
  }
  public java.lang.Boolean hasEphemeral() {
    return this.ephemeral != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<A> withNewEphemeral() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.EphemeralNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<A> withNewEphemeralLike(io.fabric8.kubernetes.api.model.EphemeralVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.EphemeralNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<A> editEphemeral() {
    return withNewEphemeralLike(getEphemeral());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<A> editOrNewEphemeral() {
    return withNewEphemeralLike(getEphemeral() != null ? getEphemeral(): new io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<A> editOrNewEphemeralLike(io.fabric8.kubernetes.api.model.EphemeralVolumeSource item) {
    return withNewEphemeralLike(getEphemeral() != null ? getEphemeral(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFc instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.FCVolumeSource getFc() {
    return this.fc!=null?this.fc.build():null;
  }
  public io.fabric8.kubernetes.api.model.FCVolumeSource buildFc() {
    return this.fc!=null?this.fc.build():null;
  }
  public A withFc(io.fabric8.kubernetes.api.model.FCVolumeSource fc) {
    _visitables.get("fc").remove(this.fc);
    if (fc!=null){ this.fc= new io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder(fc); _visitables.get("fc").add(this.fc);} return (A) this;
  }
  public java.lang.Boolean hasFc() {
    return this.fc != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<A> withNewFc() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.FcNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<A> withNewFcLike(io.fabric8.kubernetes.api.model.FCVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.FcNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<A> editFc() {
    return withNewFcLike(getFc());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<A> editOrNewFc() {
    return withNewFcLike(getFc() != null ? getFc(): new io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<A> editOrNewFcLike(io.fabric8.kubernetes.api.model.FCVolumeSource item) {
    return withNewFcLike(getFc() != null ? getFc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFlexVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.FlexVolumeSource getFlexVolume() {
    return this.flexVolume!=null?this.flexVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.FlexVolumeSource buildFlexVolume() {
    return this.flexVolume!=null?this.flexVolume.build():null;
  }
  public A withFlexVolume(io.fabric8.kubernetes.api.model.FlexVolumeSource flexVolume) {
    _visitables.get("flexVolume").remove(this.flexVolume);
    if (flexVolume!=null){ this.flexVolume= new io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder(flexVolume); _visitables.get("flexVolume").add(this.flexVolume);} return (A) this;
  }
  public java.lang.Boolean hasFlexVolume() {
    return this.flexVolume != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<A> withNewFlexVolume() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.FlexVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<A> withNewFlexVolumeLike(io.fabric8.kubernetes.api.model.FlexVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.FlexVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<A> editFlexVolume() {
    return withNewFlexVolumeLike(getFlexVolume());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<A> editOrNewFlexVolume() {
    return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): new io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(io.fabric8.kubernetes.api.model.FlexVolumeSource item) {
    return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFlocker instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.FlockerVolumeSource getFlocker() {
    return this.flocker!=null?this.flocker.build():null;
  }
  public io.fabric8.kubernetes.api.model.FlockerVolumeSource buildFlocker() {
    return this.flocker!=null?this.flocker.build():null;
  }
  public A withFlocker(io.fabric8.kubernetes.api.model.FlockerVolumeSource flocker) {
    _visitables.get("flocker").remove(this.flocker);
    if (flocker!=null){ this.flocker= new io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder(flocker); _visitables.get("flocker").add(this.flocker);} return (A) this;
  }
  public java.lang.Boolean hasFlocker() {
    return this.flocker != null;
  }
  public A withNewFlocker(java.lang.String datasetName,java.lang.String datasetUUID) {
    return (A)withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<A> withNewFlocker() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.FlockerNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<A> withNewFlockerLike(io.fabric8.kubernetes.api.model.FlockerVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.FlockerNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<A> editFlocker() {
    return withNewFlockerLike(getFlocker());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<A> editOrNewFlocker() {
    return withNewFlockerLike(getFlocker() != null ? getFlocker(): new io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<A> editOrNewFlockerLike(io.fabric8.kubernetes.api.model.FlockerVolumeSource item) {
    return withNewFlockerLike(getFlocker() != null ? getFlocker(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcePersistentDisk instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource getGcePersistentDisk() {
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
  }
  public io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource buildGcePersistentDisk() {
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
  }
  public A withGcePersistentDisk(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource gcePersistentDisk) {
    _visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk);
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.get("gcePersistentDisk").add(this.gcePersistentDisk);} return (A) this;
  }
  public java.lang.Boolean hasGcePersistentDisk() {
    return this.gcePersistentDisk != null;
  }
  public A withNewGcePersistentDisk(java.lang.String fsType,java.lang.Integer partition,java.lang.String pdName,java.lang.Boolean readOnly) {
    return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.GcePersistentDiskNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.GcePersistentDiskNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<A> editGcePersistentDisk() {
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
    return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource item) {
    return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGitRepo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GitRepoVolumeSource getGitRepo() {
    return this.gitRepo!=null?this.gitRepo.build():null;
  }
  public io.fabric8.kubernetes.api.model.GitRepoVolumeSource buildGitRepo() {
    return this.gitRepo!=null?this.gitRepo.build():null;
  }
  public A withGitRepo(io.fabric8.kubernetes.api.model.GitRepoVolumeSource gitRepo) {
    _visitables.get("gitRepo").remove(this.gitRepo);
    if (gitRepo!=null){ this.gitRepo= new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder(gitRepo); _visitables.get("gitRepo").add(this.gitRepo);} return (A) this;
  }
  public java.lang.Boolean hasGitRepo() {
    return this.gitRepo != null;
  }
  public A withNewGitRepo(java.lang.String directory,java.lang.String repository,java.lang.String revision) {
    return (A)withGitRepo(new GitRepoVolumeSource(directory, repository, revision));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<A> withNewGitRepo() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.GitRepoNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<A> withNewGitRepoLike(io.fabric8.kubernetes.api.model.GitRepoVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.GitRepoNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<A> editGitRepo() {
    return withNewGitRepoLike(getGitRepo());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<A> editOrNewGitRepo() {
    return withNewGitRepoLike(getGitRepo() != null ? getGitRepo(): new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<A> editOrNewGitRepoLike(io.fabric8.kubernetes.api.model.GitRepoVolumeSource item) {
    return withNewGitRepoLike(getGitRepo() != null ? getGitRepo(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGlusterfs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GlusterfsVolumeSource getGlusterfs() {
    return this.glusterfs!=null?this.glusterfs.build():null;
  }
  public io.fabric8.kubernetes.api.model.GlusterfsVolumeSource buildGlusterfs() {
    return this.glusterfs!=null?this.glusterfs.build():null;
  }
  public A withGlusterfs(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource glusterfs) {
    _visitables.get("glusterfs").remove(this.glusterfs);
    if (glusterfs!=null){ this.glusterfs= new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder(glusterfs); _visitables.get("glusterfs").add(this.glusterfs);} return (A) this;
  }
  public java.lang.Boolean hasGlusterfs() {
    return this.glusterfs != null;
  }
  public A withNewGlusterfs(java.lang.String endpoints,java.lang.String path,java.lang.Boolean readOnly) {
    return (A)withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<A> withNewGlusterfs() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.GlusterfsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<A> withNewGlusterfsLike(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.GlusterfsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<A> editGlusterfs() {
    return withNewGlusterfsLike(getGlusterfs());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<A> editOrNewGlusterfs() {
    return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<A> editOrNewGlusterfsLike(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource item) {
    return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHostPath instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HostPathVolumeSource getHostPath() {
    return this.hostPath!=null?this.hostPath.build():null;
  }
  public io.fabric8.kubernetes.api.model.HostPathVolumeSource buildHostPath() {
    return this.hostPath!=null?this.hostPath.build():null;
  }
  public A withHostPath(io.fabric8.kubernetes.api.model.HostPathVolumeSource hostPath) {
    _visitables.get("hostPath").remove(this.hostPath);
    if (hostPath!=null){ this.hostPath= new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder(hostPath); _visitables.get("hostPath").add(this.hostPath);} return (A) this;
  }
  public java.lang.Boolean hasHostPath() {
    return this.hostPath != null;
  }
  public A withNewHostPath(java.lang.String path,java.lang.String type) {
    return (A)withHostPath(new HostPathVolumeSource(path, type));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<A> withNewHostPath() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.HostPathNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<A> withNewHostPathLike(io.fabric8.kubernetes.api.model.HostPathVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.HostPathNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<A> editHostPath() {
    return withNewHostPathLike(getHostPath());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<A> editOrNewHostPath() {
    return withNewHostPathLike(getHostPath() != null ? getHostPath(): new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<A> editOrNewHostPathLike(io.fabric8.kubernetes.api.model.HostPathVolumeSource item) {
    return withNewHostPathLike(getHostPath() != null ? getHostPath(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIscsi instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSource getIscsi() {
    return this.iscsi!=null?this.iscsi.build():null;
  }
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSource buildIscsi() {
    return this.iscsi!=null?this.iscsi.build():null;
  }
  public A withIscsi(io.fabric8.kubernetes.api.model.ISCSIVolumeSource iscsi) {
    _visitables.get("iscsi").remove(this.iscsi);
    if (iscsi!=null){ this.iscsi= new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder(iscsi); _visitables.get("iscsi").add(this.iscsi);} return (A) this;
  }
  public java.lang.Boolean hasIscsi() {
    return this.iscsi != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<A> withNewIscsi() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.IscsiNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<A> withNewIscsiLike(io.fabric8.kubernetes.api.model.ISCSIVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.IscsiNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<A> editIscsi() {
    return withNewIscsiLike(getIscsi());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<A> editOrNewIscsi() {
    return withNewIscsiLike(getIscsi() != null ? getIscsi(): new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<A> editOrNewIscsiLike(io.fabric8.kubernetes.api.model.ISCSIVolumeSource item) {
    return withNewIscsiLike(getIscsi() != null ? getIscsi(): item);
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildNfs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.NFSVolumeSource getNfs() {
    return this.nfs!=null?this.nfs.build():null;
  }
  public io.fabric8.kubernetes.api.model.NFSVolumeSource buildNfs() {
    return this.nfs!=null?this.nfs.build():null;
  }
  public A withNfs(io.fabric8.kubernetes.api.model.NFSVolumeSource nfs) {
    _visitables.get("nfs").remove(this.nfs);
    if (nfs!=null){ this.nfs= new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder(nfs); _visitables.get("nfs").add(this.nfs);} return (A) this;
  }
  public java.lang.Boolean hasNfs() {
    return this.nfs != null;
  }
  public A withNewNfs(java.lang.String path,java.lang.Boolean readOnly,java.lang.String server) {
    return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<A> withNewNfs() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.NfsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<A> withNewNfsLike(io.fabric8.kubernetes.api.model.NFSVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.NfsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<A> editNfs() {
    return withNewNfsLike(getNfs());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<A> editOrNewNfs() {
    return withNewNfsLike(getNfs() != null ? getNfs(): new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<A> editOrNewNfsLike(io.fabric8.kubernetes.api.model.NFSVolumeSource item) {
    return withNewNfsLike(getNfs() != null ? getNfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
  }
  public A withPersistentVolumeClaim(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
  }
  public java.lang.Boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  public A withNewPersistentVolumeClaim(java.lang.String claimName,java.lang.Boolean readOnly) {
    return (A)withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.PersistentVolumeClaimNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.PersistentVolumeClaimNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource item) {
    return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPhotonPersistentDisk instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource getPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null?this.photonPersistentDisk.build():null;
  }
  public io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null?this.photonPersistentDisk.build():null;
  }
  public A withPhotonPersistentDisk(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource photonPersistentDisk) {
    _visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk);
    if (photonPersistentDisk!=null){ this.photonPersistentDisk= new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk); _visitables.get("photonPersistentDisk").add(this.photonPersistentDisk);} return (A) this;
  }
  public java.lang.Boolean hasPhotonPersistentDisk() {
    return this.photonPersistentDisk != null;
  }
  public A withNewPhotonPersistentDisk(java.lang.String fsType,java.lang.String pdID) {
    return (A)withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.PhotonPersistentDiskNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.PhotonPersistentDiskNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<A> editPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource item) {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPortworxVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PortworxVolumeSource getPortworxVolume() {
    return this.portworxVolume!=null?this.portworxVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.PortworxVolumeSource buildPortworxVolume() {
    return this.portworxVolume!=null?this.portworxVolume.build():null;
  }
  public A withPortworxVolume(io.fabric8.kubernetes.api.model.PortworxVolumeSource portworxVolume) {
    _visitables.get("portworxVolume").remove(this.portworxVolume);
    if (portworxVolume!=null){ this.portworxVolume= new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder(portworxVolume); _visitables.get("portworxVolume").add(this.portworxVolume);} return (A) this;
  }
  public java.lang.Boolean hasPortworxVolume() {
    return this.portworxVolume != null;
  }
  public A withNewPortworxVolume(java.lang.String fsType,java.lang.Boolean readOnly,java.lang.String volumeID) {
    return (A)withPortworxVolume(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<A> withNewPortworxVolume() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.PortworxVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<A> withNewPortworxVolumeLike(io.fabric8.kubernetes.api.model.PortworxVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.PortworxVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<A> editPortworxVolume() {
    return withNewPortworxVolumeLike(getPortworxVolume());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<A> editOrNewPortworxVolume() {
    return withNewPortworxVolumeLike(getPortworxVolume() != null ? getPortworxVolume(): new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<A> editOrNewPortworxVolumeLike(io.fabric8.kubernetes.api.model.PortworxVolumeSource item) {
    return withNewPortworxVolumeLike(getPortworxVolume() != null ? getPortworxVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProjected instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ProjectedVolumeSource getProjected() {
    return this.projected!=null?this.projected.build():null;
  }
  public io.fabric8.kubernetes.api.model.ProjectedVolumeSource buildProjected() {
    return this.projected!=null?this.projected.build():null;
  }
  public A withProjected(io.fabric8.kubernetes.api.model.ProjectedVolumeSource projected) {
    _visitables.get("projected").remove(this.projected);
    if (projected!=null){ this.projected= new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceBuilder(projected); _visitables.get("projected").add(this.projected);} return (A) this;
  }
  public java.lang.Boolean hasProjected() {
    return this.projected != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<A> withNewProjected() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.ProjectedNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<A> withNewProjectedLike(io.fabric8.kubernetes.api.model.ProjectedVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.ProjectedNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<A> editProjected() {
    return withNewProjectedLike(getProjected());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<A> editOrNewProjected() {
    return withNewProjectedLike(getProjected() != null ? getProjected(): new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<A> editOrNewProjectedLike(io.fabric8.kubernetes.api.model.ProjectedVolumeSource item) {
    return withNewProjectedLike(getProjected() != null ? getProjected(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuobyte instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.QuobyteVolumeSource getQuobyte() {
    return this.quobyte!=null?this.quobyte.build():null;
  }
  public io.fabric8.kubernetes.api.model.QuobyteVolumeSource buildQuobyte() {
    return this.quobyte!=null?this.quobyte.build():null;
  }
  public A withQuobyte(io.fabric8.kubernetes.api.model.QuobyteVolumeSource quobyte) {
    _visitables.get("quobyte").remove(this.quobyte);
    if (quobyte!=null){ this.quobyte= new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder(quobyte); _visitables.get("quobyte").add(this.quobyte);} return (A) this;
  }
  public java.lang.Boolean hasQuobyte() {
    return this.quobyte != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<A> withNewQuobyte() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.QuobyteNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<A> withNewQuobyteLike(io.fabric8.kubernetes.api.model.QuobyteVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.QuobyteNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<A> editQuobyte() {
    return withNewQuobyteLike(getQuobyte());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<A> editOrNewQuobyte() {
    return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<A> editOrNewQuobyteLike(io.fabric8.kubernetes.api.model.QuobyteVolumeSource item) {
    return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRbd instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.RBDVolumeSource getRbd() {
    return this.rbd!=null?this.rbd.build():null;
  }
  public io.fabric8.kubernetes.api.model.RBDVolumeSource buildRbd() {
    return this.rbd!=null?this.rbd.build():null;
  }
  public A withRbd(io.fabric8.kubernetes.api.model.RBDVolumeSource rbd) {
    _visitables.get("rbd").remove(this.rbd);
    if (rbd!=null){ this.rbd= new io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder(rbd); _visitables.get("rbd").add(this.rbd);} return (A) this;
  }
  public java.lang.Boolean hasRbd() {
    return this.rbd != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<A> withNewRbd() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.RbdNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<A> withNewRbdLike(io.fabric8.kubernetes.api.model.RBDVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.RbdNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<A> editRbd() {
    return withNewRbdLike(getRbd());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<A> editOrNewRbd() {
    return withNewRbdLike(getRbd() != null ? getRbd(): new io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<A> editOrNewRbdLike(io.fabric8.kubernetes.api.model.RBDVolumeSource item) {
    return withNewRbdLike(getRbd() != null ? getRbd(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildScaleIO instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ScaleIOVolumeSource getScaleIO() {
    return this.scaleIO!=null?this.scaleIO.build():null;
  }
  public io.fabric8.kubernetes.api.model.ScaleIOVolumeSource buildScaleIO() {
    return this.scaleIO!=null?this.scaleIO.build():null;
  }
  public A withScaleIO(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource scaleIO) {
    _visitables.get("scaleIO").remove(this.scaleIO);
    if (scaleIO!=null){ this.scaleIO= new io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder(scaleIO); _visitables.get("scaleIO").add(this.scaleIO);} return (A) this;
  }
  public java.lang.Boolean hasScaleIO() {
    return this.scaleIO != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<A> withNewScaleIO() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.ScaleIONestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<A> withNewScaleIOLike(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.ScaleIONestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<A> editScaleIO() {
    return withNewScaleIOLike(getScaleIO());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<A> editOrNewScaleIO() {
    return withNewScaleIOLike(getScaleIO() != null ? getScaleIO(): new io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<A> editOrNewScaleIOLike(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource item) {
    return withNewScaleIOLike(getScaleIO() != null ? getScaleIO(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.SecretVolumeSource getSecret() {
    return this.secret!=null?this.secret.build():null;
  }
  public io.fabric8.kubernetes.api.model.SecretVolumeSource buildSecret() {
    return this.secret!=null?this.secret.build():null;
  }
  public A withSecret(io.fabric8.kubernetes.api.model.SecretVolumeSource secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
  }
  public java.lang.Boolean hasSecret() {
    return this.secret != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<A> withNewSecret() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.SecretNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<A> withNewSecretLike(io.fabric8.kubernetes.api.model.SecretVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.SecretNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<A> editOrNewSecretLike(io.fabric8.kubernetes.api.model.SecretVolumeSource item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStorageos instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.StorageOSVolumeSource getStorageos() {
    return this.storageos!=null?this.storageos.build():null;
  }
  public io.fabric8.kubernetes.api.model.StorageOSVolumeSource buildStorageos() {
    return this.storageos!=null?this.storageos.build():null;
  }
  public A withStorageos(io.fabric8.kubernetes.api.model.StorageOSVolumeSource storageos) {
    _visitables.get("storageos").remove(this.storageos);
    if (storageos!=null){ this.storageos= new io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder(storageos); _visitables.get("storageos").add(this.storageos);} return (A) this;
  }
  public java.lang.Boolean hasStorageos() {
    return this.storageos != null;
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<A> withNewStorageos() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.StorageosNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<A> withNewStorageosLike(io.fabric8.kubernetes.api.model.StorageOSVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.StorageosNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<A> editStorageos() {
    return withNewStorageosLike(getStorageos());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<A> editOrNewStorageos() {
    return withNewStorageosLike(getStorageos() != null ? getStorageos(): new io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<A> editOrNewStorageosLike(io.fabric8.kubernetes.api.model.StorageOSVolumeSource item) {
    return withNewStorageosLike(getStorageos() != null ? getStorageos(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildVsphereVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource getVsphereVolume() {
    return this.vsphereVolume!=null?this.vsphereVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource buildVsphereVolume() {
    return this.vsphereVolume!=null?this.vsphereVolume.build():null;
  }
  public A withVsphereVolume(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource vsphereVolume) {
    _visitables.get("vsphereVolume").remove(this.vsphereVolume);
    if (vsphereVolume!=null){ this.vsphereVolume= new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume); _visitables.get("vsphereVolume").add(this.vsphereVolume);} return (A) this;
  }
  public java.lang.Boolean hasVsphereVolume() {
    return this.vsphereVolume != null;
  }
  public A withNewVsphereVolume(java.lang.String fsType,java.lang.String storagePolicyID,java.lang.String storagePolicyName,java.lang.String volumePath) {
    return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolume() {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.VsphereVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentImpl.VsphereVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<A> editVsphereVolume() {
    return withNewVsphereVolumeLike(getVsphereVolume());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<A> editOrNewVsphereVolume() {
    return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource item) {
    return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VolumeFluentImpl that = (VolumeFluentImpl) o;
    if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
    if (azureDisk != null ? !azureDisk.equals(that.azureDisk) :that.azureDisk != null) return false;
    if (azureFile != null ? !azureFile.equals(that.azureFile) :that.azureFile != null) return false;
    if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
    if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
    if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
    if (csi != null ? !csi.equals(that.csi) :that.csi != null) return false;
    if (downwardAPI != null ? !downwardAPI.equals(that.downwardAPI) :that.downwardAPI != null) return false;
    if (emptyDir != null ? !emptyDir.equals(that.emptyDir) :that.emptyDir != null) return false;
    if (ephemeral != null ? !ephemeral.equals(that.ephemeral) :that.ephemeral != null) return false;
    if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
    if (flexVolume != null ? !flexVolume.equals(that.flexVolume) :that.flexVolume != null) return false;
    if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
    if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
    if (gitRepo != null ? !gitRepo.equals(that.gitRepo) :that.gitRepo != null) return false;
    if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
    if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
    if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
    if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
    if (photonPersistentDisk != null ? !photonPersistentDisk.equals(that.photonPersistentDisk) :that.photonPersistentDisk != null) return false;
    if (portworxVolume != null ? !portworxVolume.equals(that.portworxVolume) :that.portworxVolume != null) return false;
    if (projected != null ? !projected.equals(that.projected) :that.projected != null) return false;
    if (quobyte != null ? !quobyte.equals(that.quobyte) :that.quobyte != null) return false;
    if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
    if (scaleIO != null ? !scaleIO.equals(that.scaleIO) :that.scaleIO != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (storageos != null ? !storageos.equals(that.storageos) :that.storageos != null) return false;
    if (vsphereVolume != null ? !vsphereVolume.equals(that.vsphereVolume) :that.vsphereVolume != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(awsElasticBlockStore,  azureDisk,  azureFile,  cephfs,  cinder,  configMap,  csi,  downwardAPI,  emptyDir,  ephemeral,  fc,  flexVolume,  flocker,  gcePersistentDisk,  gitRepo,  glusterfs,  hostPath,  iscsi,  name,  nfs,  persistentVolumeClaim,  photonPersistentDisk,  portworxVolume,  projected,  quobyte,  rbd,  scaleIO,  secret,  storageos,  vsphereVolume,  super.hashCode());
  }
  public class AwsElasticBlockStoreNestedImpl<N> extends io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.AwsElasticBlockStoreNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AwsElasticBlockStoreNestedImpl(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AwsElasticBlockStoreNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withAwsElasticBlockStore(builder.build());
    }
    public N endAwsElasticBlockStore() {
      return and();
    }
    
  }
  public class AzureDiskNestedImpl<N> extends io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.AzureDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AzureDiskNestedImpl(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withAzureDisk(builder.build());
    }
    public N endAzureDisk() {
      return and();
    }
    
  }
  public class AzureFileNestedImpl<N> extends io.fabric8.kubernetes.api.model.AzureFileVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.AzureFileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AzureFileNestedImpl(io.fabric8.kubernetes.api.model.AzureFileVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder(this, item);
    }
    AzureFileNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AzureFileVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withAzureFile(builder.build());
    }
    public N endAzureFile() {
      return and();
    }
    
  }
  public class CephfsNestedImpl<N> extends io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.CephfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CephfsNestedImpl(io.fabric8.kubernetes.api.model.CephFSVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder(this, item);
    }
    CephfsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withCephfs(builder.build());
    }
    public N endCephfs() {
      return and();
    }
    
  }
  public class CinderNestedImpl<N> extends io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.CinderNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CinderNestedImpl(io.fabric8.kubernetes.api.model.CinderVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder(this, item);
    }
    CinderNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CinderVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withCinder(builder.build());
    }
    public N endCinder() {
      return and();
    }
    
  }
  public class ConfigMapNestedImpl<N> extends io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.ConfigMapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigMapNestedImpl(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder(this, item);
    }
    ConfigMapNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  public class CsiNestedImpl<N> extends io.fabric8.kubernetes.api.model.CSIVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.CsiNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CsiNestedImpl(io.fabric8.kubernetes.api.model.CSIVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder(this, item);
    }
    CsiNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withCsi(builder.build());
    }
    public N endCsi() {
      return and();
    }
    
  }
  public class DownwardAPINestedImpl<N> extends io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.DownwardAPINested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DownwardAPINestedImpl(io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder(this, item);
    }
    DownwardAPINestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withDownwardAPI(builder.build());
    }
    public N endDownwardAPI() {
      return and();
    }
    
  }
  public class EmptyDirNestedImpl<N> extends io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.EmptyDirNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EmptyDirNestedImpl(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder(this, item);
    }
    EmptyDirNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withEmptyDir(builder.build());
    }
    public N endEmptyDir() {
      return and();
    }
    
  }
  public class EphemeralNestedImpl<N> extends io.fabric8.kubernetes.api.model.EphemeralVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.EphemeralNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EphemeralNestedImpl(io.fabric8.kubernetes.api.model.EphemeralVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder(this, item);
    }
    EphemeralNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EphemeralVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withEphemeral(builder.build());
    }
    public N endEphemeral() {
      return and();
    }
    
  }
  public class FcNestedImpl<N> extends io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.FcNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FcNestedImpl(io.fabric8.kubernetes.api.model.FCVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder(this, item);
    }
    FcNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withFc(builder.build());
    }
    public N endFc() {
      return and();
    }
    
  }
  public class FlexVolumeNestedImpl<N> extends io.fabric8.kubernetes.api.model.FlexVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.FlexVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FlexVolumeNestedImpl(io.fabric8.kubernetes.api.model.FlexVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder(this, item);
    }
    FlexVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withFlexVolume(builder.build());
    }
    public N endFlexVolume() {
      return and();
    }
    
  }
  public class FlockerNestedImpl<N> extends io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.FlockerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FlockerNestedImpl(io.fabric8.kubernetes.api.model.FlockerVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder(this, item);
    }
    FlockerNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withFlocker(builder.build());
    }
    public N endFlocker() {
      return and();
    }
    
  }
  public class GcePersistentDiskNestedImpl<N> extends io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.GcePersistentDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GcePersistentDiskNestedImpl(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GcePersistentDiskNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withGcePersistentDisk(builder.build());
    }
    public N endGcePersistentDisk() {
      return and();
    }
    
  }
  public class GitRepoNestedImpl<N> extends io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.GitRepoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GitRepoNestedImpl(io.fabric8.kubernetes.api.model.GitRepoVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder(this, item);
    }
    GitRepoNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withGitRepo(builder.build());
    }
    public N endGitRepo() {
      return and();
    }
    
  }
  public class GlusterfsNestedImpl<N> extends io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.GlusterfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GlusterfsNestedImpl(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder(this, item);
    }
    GlusterfsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withGlusterfs(builder.build());
    }
    public N endGlusterfs() {
      return and();
    }
    
  }
  public class HostPathNestedImpl<N> extends io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.HostPathNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostPathNestedImpl(io.fabric8.kubernetes.api.model.HostPathVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder(this, item);
    }
    HostPathNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withHostPath(builder.build());
    }
    public N endHostPath() {
      return and();
    }
    
  }
  public class IscsiNestedImpl<N> extends io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.IscsiNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IscsiNestedImpl(io.fabric8.kubernetes.api.model.ISCSIVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder(this, item);
    }
    IscsiNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withIscsi(builder.build());
    }
    public N endIscsi() {
      return and();
    }
    
  }
  public class NfsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.NfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NfsNestedImpl(io.fabric8.kubernetes.api.model.NFSVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder(this, item);
    }
    NfsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withNfs(builder.build());
    }
    public N endNfs() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder(this, item);
    }
    PersistentVolumeClaimNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withPersistentVolumeClaim(builder.build());
    }
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  }
  public class PhotonPersistentDiskNestedImpl<N> extends io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.PhotonPersistentDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PhotonPersistentDiskNestedImpl(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withPhotonPersistentDisk(builder.build());
    }
    public N endPhotonPersistentDisk() {
      return and();
    }
    
  }
  public class PortworxVolumeNestedImpl<N> extends io.fabric8.kubernetes.api.model.PortworxVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.PortworxVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortworxVolumeNestedImpl(io.fabric8.kubernetes.api.model.PortworxVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withPortworxVolume(builder.build());
    }
    public N endPortworxVolume() {
      return and();
    }
    
  }
  public class ProjectedNestedImpl<N> extends io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.ProjectedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectedNestedImpl(io.fabric8.kubernetes.api.model.ProjectedVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceBuilder(this, item);
    }
    ProjectedNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ProjectedVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withProjected(builder.build());
    }
    public N endProjected() {
      return and();
    }
    
  }
  public class QuobyteNestedImpl<N> extends io.fabric8.kubernetes.api.model.QuobyteVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.QuobyteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    QuobyteNestedImpl(io.fabric8.kubernetes.api.model.QuobyteVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withQuobyte(builder.build());
    }
    public N endQuobyte() {
      return and();
    }
    
  }
  public class RbdNestedImpl<N> extends io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.RbdNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RbdNestedImpl(io.fabric8.kubernetes.api.model.RBDVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder(this, item);
    }
    RbdNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withRbd(builder.build());
    }
    public N endRbd() {
      return and();
    }
    
  }
  public class ScaleIONestedImpl<N> extends io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.ScaleIONested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ScaleIONestedImpl(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder(this, item);
    }
    ScaleIONestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withScaleIO(builder.build());
    }
    public N endScaleIO() {
      return and();
    }
    
  }
  public class SecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.SecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecretNestedImpl(io.fabric8.kubernetes.api.model.SecretVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  public class StorageosNestedImpl<N> extends io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.StorageosNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StorageosNestedImpl(io.fabric8.kubernetes.api.model.StorageOSVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder(this, item);
    }
    StorageosNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withStorageos(builder.build());
    }
    public N endStorageos() {
      return and();
    }
    
  }
  public class VsphereVolumeNestedImpl<N> extends io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<N>> implements io.fabric8.kubernetes.api.model.VolumeFluent.VsphereVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VsphereVolumeNestedImpl(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) VolumeFluentImpl.this.withVsphereVolume(builder.build());
    }
    public N endVsphereVolume() {
      return and();
    }
    
  }
  
}