package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NamedClusterBuilder extends io.fabric8.kubernetes.api.model.NamedClusterFluentImpl<io.fabric8.kubernetes.api.model.NamedClusterBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NamedCluster,io.fabric8.kubernetes.api.model.NamedClusterBuilder>{
  public NamedClusterBuilder() {
    this(false);
  }
  public NamedClusterBuilder(java.lang.Boolean validationEnabled) {
    this(new NamedCluster(), validationEnabled);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamedCluster(), validationEnabled);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedCluster instance) {
    this(fluent, instance, false);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedCluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCluster(instance.getCluster()); 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedCluster instance) {
    this(instance,false);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedCluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCluster(instance.getCluster()); 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamedCluster build() {
    NamedCluster buildable = new NamedCluster(fluent.getCluster(),fluent.getName());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedClusterBuilder that = (NamedClusterBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}