package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HandlerBuilder extends io.fabric8.kubernetes.api.model.HandlerFluentImpl<io.fabric8.kubernetes.api.model.HandlerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Handler,io.fabric8.kubernetes.api.model.HandlerBuilder>{
  public HandlerBuilder() {
    this(false);
  }
  public HandlerBuilder(java.lang.Boolean validationEnabled) {
    this(new Handler(), validationEnabled);
  }
  public HandlerBuilder(io.fabric8.kubernetes.api.model.HandlerFluent<?> fluent) {
    this(fluent, false);
  }
  public HandlerBuilder(io.fabric8.kubernetes.api.model.HandlerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Handler(), validationEnabled);
  }
  public HandlerBuilder(io.fabric8.kubernetes.api.model.HandlerFluent<?> fluent,io.fabric8.kubernetes.api.model.Handler instance) {
    this(fluent, instance, false);
  }
  public HandlerBuilder(io.fabric8.kubernetes.api.model.HandlerFluent<?> fluent,io.fabric8.kubernetes.api.model.Handler instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExec(instance.getExec()); 
    fluent.withHttpGet(instance.getHttpGet()); 
    fluent.withTcpSocket(instance.getTcpSocket()); 
    this.validationEnabled = validationEnabled; 
  }
  public HandlerBuilder(io.fabric8.kubernetes.api.model.Handler instance) {
    this(instance,false);
  }
  public HandlerBuilder(io.fabric8.kubernetes.api.model.Handler instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExec(instance.getExec()); 
    this.withHttpGet(instance.getHttpGet()); 
    this.withTcpSocket(instance.getTcpSocket()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.HandlerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Handler build() {
    Handler buildable = new Handler(fluent.getExec(),fluent.getHttpGet(),fluent.getTcpSocket());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HandlerBuilder that = (HandlerBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}