package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public class APIGroupListFluentImpl<A extends io.fabric8.kubernetes.api.model.APIGroupListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.APIGroupListFluent<A>{
  public APIGroupListFluentImpl() {
  }
  public APIGroupListFluentImpl(io.fabric8.kubernetes.api.model.APIGroupList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroups(instance.getGroups()); 
    this.withKind(instance.getKind()); 
  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.kubernetes.api.model.APIGroupBuilder> groups =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIGroupBuilder>();
  private java.lang.String kind;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToGroups(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIGroup item) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIGroupBuilder>();}
    io.fabric8.kubernetes.api.model.APIGroupBuilder builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(item);_visitables.get("groups").add(index >= 0 ? index : _visitables.get("groups").size(), builder);this.groups.add(index >= 0 ? index : groups.size(), builder); return (A)this;
  }
  public A setToGroups(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIGroup item) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIGroupBuilder>();}
    io.fabric8.kubernetes.api.model.APIGroupBuilder builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(item);
    if (index < 0 || index >= _visitables.get("groups").size()) { _visitables.get("groups").add(builder); } else { _visitables.get("groups").set(index, builder);}
    if (index < 0 || index >= groups.size()) { groups.add(builder); } else { groups.set(index, builder);}
     return (A)this;
  }
  public A addToGroups(io.fabric8.kubernetes.api.model.APIGroup... items) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIGroupBuilder>();}
    for (io.fabric8.kubernetes.api.model.APIGroup item : items) {io.fabric8.kubernetes.api.model.APIGroupBuilder builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
  }
  public A addAllToGroups(java.util.Collection<io.fabric8.kubernetes.api.model.APIGroup> items) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIGroupBuilder>();}
    for (io.fabric8.kubernetes.api.model.APIGroup item : items) {io.fabric8.kubernetes.api.model.APIGroupBuilder builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
  }
  public A removeFromGroups(io.fabric8.kubernetes.api.model.APIGroup... items) {
    for (io.fabric8.kubernetes.api.model.APIGroup item : items) {io.fabric8.kubernetes.api.model.APIGroupBuilder builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
  }
  public A removeAllFromGroups(java.util.Collection<io.fabric8.kubernetes.api.model.APIGroup> items) {
    for (io.fabric8.kubernetes.api.model.APIGroup item : items) {io.fabric8.kubernetes.api.model.APIGroupBuilder builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGroups(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIGroupBuilder> predicate) {
    if (groups == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.APIGroupBuilder> each = groups.iterator();
    final List visitables = _visitables.get("groups");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.APIGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGroups instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.APIGroup> getGroups() {
    return build(groups);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.APIGroup> buildGroups() {
    return build(groups);
  }
  public io.fabric8.kubernetes.api.model.APIGroup buildGroup(java.lang.Integer index) {
    return this.groups.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.APIGroup buildFirstGroup() {
    return this.groups.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.APIGroup buildLastGroup() {
    return this.groups.get(groups.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.APIGroup buildMatchingGroup(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIGroupBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.APIGroupBuilder item: groups) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingGroup(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIGroupBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.APIGroupBuilder item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(java.util.List<io.fabric8.kubernetes.api.model.APIGroup> groups) {
    if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
    if (groups != null) {this.groups = new java.util.ArrayList<io.fabric8.kubernetes.api.model.APIGroupBuilder>(); for (io.fabric8.kubernetes.api.model.APIGroup item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(io.fabric8.kubernetes.api.model.APIGroup... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (io.fabric8.kubernetes.api.model.APIGroup item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public java.lang.Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> addNewGroup() {
    return new io.fabric8.kubernetes.api.model.APIGroupListFluentImpl.GroupsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> addNewGroupLike(io.fabric8.kubernetes.api.model.APIGroup item) {
    return new io.fabric8.kubernetes.api.model.APIGroupListFluentImpl.GroupsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> setNewGroupLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIGroup item) {
    return new io.fabric8.kubernetes.api.model.APIGroupListFluentImpl.GroupsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> editGroup(java.lang.Integer index) {
    if (groups.size() <= index) throw new RuntimeException("Can't edit groups. Index exceeds size.");
    return setNewGroupLike(index, buildGroup(index));
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> editFirstGroup() {
    if (groups.size() == 0) throw new RuntimeException("Can't edit first groups. The list is empty.");
    return setNewGroupLike(0, buildGroup(0));
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> editLastGroup() {
    int index = groups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last groups. The list is empty.");
    return setNewGroupLike(index, buildGroup(index));
  }
  public io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<A> editMatchingGroup(java.util.function.Predicate<io.fabric8.kubernetes.api.model.APIGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<groups.size();i++) { 
    if (predicate.test(groups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching groups. No match found.");
    return setNewGroupLike(index, buildGroup(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIGroupListFluentImpl that = (APIGroupListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  groups,  kind,  super.hashCode());
  }
  public class GroupsNestedImpl<N> extends io.fabric8.kubernetes.api.model.APIGroupFluentImpl<io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<N>> implements io.fabric8.kubernetes.api.model.APIGroupListFluent.GroupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.APIGroup item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(this, item);
    }
    GroupsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.APIGroupBuilder(this);
    }
    io.fabric8.kubernetes.api.model.APIGroupBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) APIGroupListFluentImpl.this.setToGroups(index,builder.build());
    }
    public N endGroup() {
      return and();
    }
    
  }
  
}