package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class VolumeDeviceBuilder extends io.fabric8.kubernetes.api.model.VolumeDeviceFluentImpl<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.VolumeDevice,io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>{
  public VolumeDeviceBuilder() {
    this(false);
  }
  public VolumeDeviceBuilder(java.lang.Boolean validationEnabled) {
    this(new VolumeDevice(), validationEnabled);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VolumeDevice(), validationEnabled);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent,io.fabric8.kubernetes.api.model.VolumeDevice instance) {
    this(fluent, instance, false);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent,io.fabric8.kubernetes.api.model.VolumeDevice instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDevicePath(instance.getDevicePath()); 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDevice instance) {
    this(instance,false);
  }
  public VolumeDeviceBuilder(io.fabric8.kubernetes.api.model.VolumeDevice instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDevicePath(instance.getDevicePath()); 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.VolumeDeviceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.VolumeDevice build() {
    VolumeDevice buildable = new VolumeDevice(fluent.getDevicePath(),fluent.getName());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeDeviceBuilder that = (VolumeDeviceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}