package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceSpecBuilder extends io.fabric8.kubernetes.api.model.ServiceSpecFluentImpl<io.fabric8.kubernetes.api.model.ServiceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServiceSpec,io.fabric8.kubernetes.api.model.ServiceSpecBuilder>{
  public ServiceSpecBuilder() {
    this(false);
  }
  public ServiceSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceSpec(), validationEnabled);
  }
  public ServiceSpecBuilder(io.fabric8.kubernetes.api.model.ServiceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceSpecBuilder(io.fabric8.kubernetes.api.model.ServiceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceSpec(), validationEnabled);
  }
  public ServiceSpecBuilder(io.fabric8.kubernetes.api.model.ServiceSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceSpecBuilder(io.fabric8.kubernetes.api.model.ServiceSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts()); 
    fluent.withClusterIP(instance.getClusterIP()); 
    fluent.withClusterIPs(instance.getClusterIPs()); 
    fluent.withExternalIPs(instance.getExternalIPs()); 
    fluent.withExternalName(instance.getExternalName()); 
    fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy()); 
    fluent.withHealthCheckNodePort(instance.getHealthCheckNodePort()); 
    fluent.withInternalTrafficPolicy(instance.getInternalTrafficPolicy()); 
    fluent.withIpFamilies(instance.getIpFamilies()); 
    fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy()); 
    fluent.withLoadBalancerClass(instance.getLoadBalancerClass()); 
    fluent.withLoadBalancerIP(instance.getLoadBalancerIP()); 
    fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withSessionAffinity(instance.getSessionAffinity()); 
    fluent.withSessionAffinityConfig(instance.getSessionAffinityConfig()); 
    fluent.withTopologyKeys(instance.getTopologyKeys()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceSpecBuilder(io.fabric8.kubernetes.api.model.ServiceSpec instance) {
    this(instance,false);
  }
  public ServiceSpecBuilder(io.fabric8.kubernetes.api.model.ServiceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts()); 
    this.withClusterIP(instance.getClusterIP()); 
    this.withClusterIPs(instance.getClusterIPs()); 
    this.withExternalIPs(instance.getExternalIPs()); 
    this.withExternalName(instance.getExternalName()); 
    this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy()); 
    this.withHealthCheckNodePort(instance.getHealthCheckNodePort()); 
    this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy()); 
    this.withIpFamilies(instance.getIpFamilies()); 
    this.withIpFamilyPolicy(instance.getIpFamilyPolicy()); 
    this.withLoadBalancerClass(instance.getLoadBalancerClass()); 
    this.withLoadBalancerIP(instance.getLoadBalancerIP()); 
    this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
    this.withPorts(instance.getPorts()); 
    this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses()); 
    this.withSelector(instance.getSelector()); 
    this.withSessionAffinity(instance.getSessionAffinity()); 
    this.withSessionAffinityConfig(instance.getSessionAffinityConfig()); 
    this.withTopologyKeys(instance.getTopologyKeys()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceSpec build() {
    ServiceSpec buildable = new ServiceSpec(fluent.getAllocateLoadBalancerNodePorts(),fluent.getClusterIP(),fluent.getClusterIPs(),fluent.getExternalIPs(),fluent.getExternalName(),fluent.getExternalTrafficPolicy(),fluent.getHealthCheckNodePort(),fluent.getInternalTrafficPolicy(),fluent.getIpFamilies(),fluent.getIpFamilyPolicy(),fluent.getLoadBalancerClass(),fluent.getLoadBalancerIP(),fluent.getLoadBalancerSourceRanges(),fluent.getPorts(),fluent.getPublishNotReadyAddresses(),fluent.getSelector(),fluent.getSessionAffinity(),fluent.getSessionAffinityConfig(),fluent.getTopologyKeys(),fluent.getType());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceSpecBuilder that = (ServiceSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}