package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SecretReferenceBuilder extends io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl<io.fabric8.kubernetes.api.model.SecretReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.SecretReference,io.fabric8.kubernetes.api.model.SecretReferenceBuilder>{
  public SecretReferenceBuilder() {
    this(false);
  }
  public SecretReferenceBuilder(java.lang.Boolean validationEnabled) {
    this(new SecretReference(), validationEnabled);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretReference(), validationEnabled);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretReference instance) {
    this(fluent, instance, false);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    this.validationEnabled = validationEnabled; 
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReference instance) {
    this(instance,false);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecretReference build() {
    SecretReference buildable = new SecretReference(fluent.getName(),fluent.getNamespace());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretReferenceBuilder that = (SecretReferenceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}